/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters;

import csbase.logic.algorithms.FileParameterValue;
import csbase.logic.algorithms.parameters.FileParameterMode;
import csbase.logic.algorithms.parameters.FileParameterPipeAcceptance;
import csbase.logic.algorithms.parameters.OutputFileParameter;
import csbase.test.util.Pair;
import java.util.HashMap;
import java.util.Map;

public final class OutputFileParameterFactory {
    public static final FileParameterPipeAcceptance CAN_USE_PIPE_PARAMETER_DEFAULT_VALUE = FileParameterPipeAcceptance.TRUE;
    public static final String CAN_USE_PIPE_PARAMETER_NAME = "canUsePipe";
    public static final String COMMAND_LINE_PATTERN_PARAMETER_DEFAULT_VALUE = "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO";
    public static final String COMMAND_LINE_PATTERN_PARAMETER_NAME = "commandLinePattern";
    public static final String DESCRIPTION_PARAMETER_DEFAULT_VALUE = "Informe o arquivo de sa\u00edda.";
    public static final String DESCRIPTION_PARAMETER_NAME = "description";
    public static final String FILE_TYPE_PARAMETER_DEFAULT_VALUE = null;
    public static final String FILE_TYPE_PARAMETER_NAME = "fileType";
    public static final boolean IS_OPTIONAL_PARAMETER_DEFAULT_VALUE = false;
    public static final String IS_OPTIONAL_PARAMETER_NAME = "isOptional";
    public static final String LABEL_PARAMETER_DEFAULT_VALUE = "Arquivo de Sa\u00edda";
    public static final String LABEL_PARAMETER_NAME = "label";
    public static final FileParameterMode MODE_PARAMETER_DEFAULT_VALUE = FileParameterMode.REGULAR_FILE;
    public static final String MODE_PARAMETER_NAME = "mode";
    public static final boolean MUST_FORCE_EXTENSION_PARAMETER_DEFAULT_VALUE = false;
    public static final String MUST_FORCE_EXTENSION_PARAMETER_NAME = "mustForceExtension";
    public static final boolean USE_FILTER_PARAMETER_DEFAULT_VALUE = false;
    public static final String USE_ROOT_DIRECTORY_AS_DEFAULT = "usar_diretorio_raiz_como_padrao";
    public static final boolean USE_ROOT_DIRECTORY_AS_DEFAULT_DEFAULT_VALUE = false;
    public static final String USE_FILTER_PARAMETER_NAME = "usar_filtro";
    public static final String NAME_PARAMETER_DEFAULT_VALUE = "NOME_DO_ARQUIVO_DE_SAIDA";
    public static final String NAME_PARAMETER_NAME = "name";

    public static OutputFileParameter create(Pair ... parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException("parameters == null");
        }
        HashMap<String, Object> parametersByName = new HashMap<String, Object>();
        for (Pair parameter : parameters) {
            String parameterName = (String)parameter.getKey();
            Object parameterValue = parameter.getValue();
            parametersByName.put(parameterName, parameterValue);
        }
        String name = OutputFileParameterFactory.extractValue(parametersByName, NAME_PARAMETER_NAME, NAME_PARAMETER_DEFAULT_VALUE);
        String label = OutputFileParameterFactory.extractValue(parametersByName, LABEL_PARAMETER_NAME, LABEL_PARAMETER_DEFAULT_VALUE);
        String description = OutputFileParameterFactory.extractValue(parametersByName, DESCRIPTION_PARAMETER_NAME, DESCRIPTION_PARAMETER_DEFAULT_VALUE);
        boolean isOptional = OutputFileParameterFactory.extractValue(parametersByName, IS_OPTIONAL_PARAMETER_NAME, false);
        String commandLinePattern = OutputFileParameterFactory.extractValue(parametersByName, COMMAND_LINE_PATTERN_PARAMETER_NAME, COMMAND_LINE_PATTERN_PARAMETER_DEFAULT_VALUE);
        String type = OutputFileParameterFactory.extractValue(parametersByName, FILE_TYPE_PARAMETER_NAME, FILE_TYPE_PARAMETER_DEFAULT_VALUE);
        FileParameterMode mode = OutputFileParameterFactory.extractValue(parametersByName, MODE_PARAMETER_NAME, MODE_PARAMETER_DEFAULT_VALUE);
        FileParameterPipeAcceptance canUsePipe = OutputFileParameterFactory.extractValue(parametersByName, CAN_USE_PIPE_PARAMETER_NAME, CAN_USE_PIPE_PARAMETER_DEFAULT_VALUE);
        boolean mustForceExtension = OutputFileParameterFactory.extractValue(parametersByName, MUST_FORCE_EXTENSION_PARAMETER_NAME, false);
        boolean useFilter = OutputFileParameterFactory.extractValue(parametersByName, USE_FILTER_PARAMETER_NAME, false);
        boolean useRootAsDefault = OutputFileParameterFactory.extractValue(parametersByName, USE_ROOT_DIRECTORY_AS_DEFAULT, false);
        FileParameterValue rootDirAsDefault = null;
        if (useRootAsDefault) {
            rootDirAsDefault = new FileParameterValue(".");
        }
        if (!parametersByName.isEmpty()) {
            throw new IllegalArgumentException("Par\u00e2metros inv\u00e1lidos: " + parametersByName);
        }
        return new OutputFileParameter(name, label, description, rootDirAsDefault, isOptional, true, commandLinePattern, type, mode, canUsePipe, mustForceExtension, useFilter);
    }

    private static <V> V extractValue(Map<String, Object> parametersByName, String name, V defaultValue) {
        if (parametersByName.containsKey(name)) {
            return (V)parametersByName.remove(name);
        }
        return defaultValue;
    }
}

