/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters;

import csbase.logic.algorithms.parameters.FileParameterMode;
import csbase.logic.algorithms.parameters.FileParameterPipeAcceptance;
import csbase.logic.algorithms.parameters.OutputFileParameter;
import org.junit.Assert;
import org.junit.Test;

public final class OutputFileParameterTest {
    @Test
    public void testOutputFileParameterWithOptionalValue() {
        String name = "NOME_DO_PARAMETRO";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean isOptional = true;
        String fileType = "Tipo de arquivo";
        FileParameterMode mode = FileParameterMode.REGULAR_FILE;
        FileParameterPipeAcceptance canUsePipe = FileParameterPipeAcceptance.TRUE;
        boolean mustForceExtension = false;
        String commandLinePattern = "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO";
        boolean isVisible = true;
        boolean useFilter = false;
        OutputFileParameter parameter = new OutputFileParameter(name, label, description, null, isOptional, isVisible, commandLinePattern, fileType, mode, canUsePipe, mustForceExtension, useFilter);
        this.assertEquals(name, label, description, isOptional, isVisible, commandLinePattern, fileType, mode, canUsePipe, mustForceExtension, useFilter, parameter);
    }

    @Test
    public void testOutputFileParameterWithNonOptionalValue() {
        String name = "NOME_DO_PARAMETRO";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean isOptional = false;
        String fileType = "Tipo de arquivo";
        FileParameterMode mode = FileParameterMode.REGULAR_FILE;
        FileParameterPipeAcceptance canUsePipe = FileParameterPipeAcceptance.TRUE;
        boolean mustForceExtension = false;
        String commandLinePattern = "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO";
        boolean isVisible = true;
        boolean useFilter = false;
        OutputFileParameter parameter = new OutputFileParameter(name, label, description, null, isOptional, isVisible, commandLinePattern, fileType, mode, canUsePipe, mustForceExtension, useFilter);
        this.assertEquals(name, label, description, isOptional, isVisible, commandLinePattern, fileType, mode, canUsePipe, mustForceExtension, useFilter, parameter);
    }

    @Test
    public void testOutputFileParameterWithNullCommandLinePattern() {
        String name = "NOME_DO_PARAMETRO";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean isOptional = false;
        String fileType = "Tipo de arquivo";
        FileParameterMode mode = FileParameterMode.REGULAR_FILE;
        FileParameterPipeAcceptance canUsePipe = FileParameterPipeAcceptance.TRUE;
        boolean mustForceExtension = false;
        String commandLinePattern = null;
        boolean isVisible = true;
        boolean useFilter = false;
        OutputFileParameter parameter = new OutputFileParameter(name, label, description, null, isOptional, isVisible, commandLinePattern, fileType, mode, canUsePipe, mustForceExtension, useFilter);
        this.assertEquals(name, label, description, isOptional, isVisible, commandLinePattern, fileType, mode, canUsePipe, mustForceExtension, useFilter, parameter);
    }

    @Test
    public void testOutputFileParameterWithNullFileType() {
        String name = "NOME_DO_PARAMETRO";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean isOptional = false;
        String fileType = null;
        FileParameterMode mode = FileParameterMode.REGULAR_FILE;
        FileParameterPipeAcceptance canUsePipe = FileParameterPipeAcceptance.TRUE;
        boolean mustForceExtension = false;
        String commandLinePattern = "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO";
        boolean isVisible = true;
        boolean useFilter = false;
        OutputFileParameter parameter = new OutputFileParameter(name, label, description, null, isOptional, isVisible, commandLinePattern, fileType, mode, canUsePipe, mustForceExtension, useFilter);
        this.assertEquals(name, label, description, isOptional, isVisible, commandLinePattern, fileType, mode, canUsePipe, mustForceExtension, useFilter, parameter);
    }

    @Test
    public void testOutputFileParameterWithDirectoryMode() {
        String name = "NOME_DO_PARAMETRO";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean isOptional = false;
        String fileType = null;
        FileParameterMode mode = FileParameterMode.DIRECTORY;
        FileParameterPipeAcceptance canUsePipe = FileParameterPipeAcceptance.TRUE;
        boolean mustForceExtension = false;
        String commandLinePattern = "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO";
        boolean isVisible = true;
        boolean useFilter = false;
        OutputFileParameter parameter = new OutputFileParameter(name, label, description, null, isOptional, isVisible, commandLinePattern, fileType, mode, canUsePipe, mustForceExtension, useFilter);
        this.assertEquals(name, label, description, isOptional, isVisible, commandLinePattern, fileType, mode, canUsePipe, mustForceExtension, useFilter, parameter);
    }

    @Test
    public void testOutputFileParameterWithPipeAcceptance() {
        String name = "NOME_DO_PARAMETRO";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean isOptional = false;
        String fileType = null;
        FileParameterMode mode = FileParameterMode.REGULAR_FILE;
        FileParameterPipeAcceptance canUsePipe = FileParameterPipeAcceptance.FALSE;
        boolean mustForceExtension = false;
        String commandLinePattern = "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO";
        boolean isVisible = true;
        boolean useFilter = false;
        OutputFileParameter parameter = new OutputFileParameter(name, label, description, null, isOptional, isVisible, commandLinePattern, fileType, mode, canUsePipe, mustForceExtension, useFilter);
        this.assertEquals(name, label, description, isOptional, isVisible, commandLinePattern, fileType, mode, canUsePipe, mustForceExtension, useFilter, parameter);
    }

    @Test
    public void testOutputFileParameterWithForcedExtension() {
        String name = "NOME_DO_PARAMETRO";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean isOptional = false;
        String fileType = null;
        FileParameterMode mode = FileParameterMode.REGULAR_FILE;
        FileParameterPipeAcceptance canUsePipe = FileParameterPipeAcceptance.TRUE;
        boolean mustForceExtension = true;
        String commandLinePattern = "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO";
        boolean isVisible = true;
        boolean useFilter = false;
        OutputFileParameter parameter = new OutputFileParameter(name, label, description, null, isOptional, isVisible, commandLinePattern, fileType, mode, canUsePipe, mustForceExtension, useFilter);
        this.assertEquals(name, label, description, isOptional, isVisible, commandLinePattern, fileType, mode, canUsePipe, mustForceExtension, useFilter, parameter);
    }

    @Test
    public void testOutputFileParameterWithFilter() {
        String name = "NOME_DO_PARAMETRO";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean isOptional = false;
        String fileType = null;
        FileParameterMode mode = FileParameterMode.REGULAR_FILE;
        FileParameterPipeAcceptance canUsePipe = FileParameterPipeAcceptance.TRUE;
        boolean mustForceExtension = false;
        String commandLinePattern = "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO";
        boolean isVisible = true;
        boolean useFilter = true;
        OutputFileParameter parameter = new OutputFileParameter(name, label, description, null, isOptional, isVisible, commandLinePattern, fileType, mode, canUsePipe, mustForceExtension, useFilter);
        this.assertEquals(name, label, description, isOptional, isVisible, commandLinePattern, fileType, mode, canUsePipe, mustForceExtension, useFilter, parameter);
    }

    @Test
    public void testOutputFileParameterNotVisible() {
        String name = "NOME_DO_PARAMETRO";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean isOptional = false;
        String fileType = null;
        FileParameterMode mode = FileParameterMode.REGULAR_FILE;
        FileParameterPipeAcceptance canUsePipe = FileParameterPipeAcceptance.TRUE;
        boolean mustForceExtension = false;
        String commandLinePattern = "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO";
        boolean isVisible = false;
        boolean useFilter = true;
        OutputFileParameter parameter = new OutputFileParameter(name, label, description, null, isOptional, isVisible, commandLinePattern, fileType, mode, canUsePipe, mustForceExtension, useFilter);
        this.assertEquals(name, label, description, isOptional, isVisible, commandLinePattern, fileType, mode, canUsePipe, mustForceExtension, useFilter, parameter);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testOutputFileParameterWithNullName() {
        String name = null;
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean isOptional = true;
        String fileType = "Tipo de arquivo";
        FileParameterMode mode = FileParameterMode.REGULAR_FILE;
        FileParameterPipeAcceptance canUsePipe = FileParameterPipeAcceptance.TRUE;
        boolean mustForceExtension = false;
        String commandLinePattern = "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO";
        boolean isVisible = true;
        boolean useFilter = false;
        new OutputFileParameter(name, label, description, null, isOptional, isVisible, commandLinePattern, fileType, mode, canUsePipe, mustForceExtension, useFilter);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testOutputFileParameterWithNullLabel() {
        String name = "NOME_DO_PARAMETRO";
        String label = null;
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean isOptional = true;
        String fileType = "Tipo de arquivo";
        FileParameterMode mode = FileParameterMode.REGULAR_FILE;
        FileParameterPipeAcceptance canUsePipe = FileParameterPipeAcceptance.TRUE;
        boolean mustForceExtension = false;
        String commandLinePattern = "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO";
        boolean isVisible = true;
        boolean useFilter = false;
        new OutputFileParameter(name, label, description, null, isOptional, isVisible, commandLinePattern, fileType, mode, canUsePipe, mustForceExtension, useFilter);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testOutputFileParameterWithNullDescription() {
        String name = "NOME_DO_PARAMETRO";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = null;
        boolean isOptional = true;
        String fileType = "Tipo de arquivo";
        FileParameterMode mode = FileParameterMode.REGULAR_FILE;
        FileParameterPipeAcceptance canUsePipe = FileParameterPipeAcceptance.TRUE;
        boolean mustForceExtension = false;
        String commandLinePattern = "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO";
        boolean isVisible = true;
        boolean useFilter = false;
        new OutputFileParameter(name, label, description, null, isOptional, isVisible, commandLinePattern, fileType, mode, canUsePipe, mustForceExtension, useFilter);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testOutputFileParameterWithNullMode() {
        String name = "NOME_DO_PARAMETRO";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean isOptional = true;
        String fileType = "Tipo de arquivo";
        FileParameterMode mode = null;
        FileParameterPipeAcceptance canUsePipe = FileParameterPipeAcceptance.TRUE;
        boolean mustForceExtension = false;
        String commandLinePattern = "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO";
        boolean isVisible = true;
        boolean useFilter = false;
        new OutputFileParameter(name, label, description, null, isOptional, isVisible, commandLinePattern, fileType, mode, canUsePipe, mustForceExtension, useFilter);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testOutputFileParameterWithDirectoryAndFileMode() {
        String name = "NOME_DO_PARAMETRO";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        boolean isOptional = false;
        String fileType = null;
        FileParameterMode mode = FileParameterMode.DIRECTORY_AND_REGULAR_FILE;
        FileParameterPipeAcceptance canUsePipe = FileParameterPipeAcceptance.TRUE;
        boolean mustForceExtension = false;
        String commandLinePattern = "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO";
        boolean isVisible = true;
        boolean useFilter = false;
        new OutputFileParameter(name, label, description, null, isOptional, isVisible, commandLinePattern, fileType, mode, canUsePipe, mustForceExtension, useFilter);
    }

    private void assertEquals(String name, String label, String description, boolean isOptional, boolean isVisible, String commandLinePattern, String fileType, FileParameterMode mode, FileParameterPipeAcceptance canUsePipe, boolean mustForceExtension, boolean useFilter, OutputFileParameter parameter) {
        Assert.assertEquals((Object)name, (Object)parameter.getName());
        Assert.assertEquals((Object)label, (Object)parameter.getLabel());
        Assert.assertEquals((Object)description, (Object)parameter.getDescription());
        Assert.assertEquals((Object)isOptional, (Object)parameter.isOptional());
        Assert.assertEquals((Object)isVisible, (Object)parameter.isVisible());
        Assert.assertEquals((Object)useFilter, (Object)parameter.usesFilter());
        Assert.assertEquals((Object)commandLinePattern, (Object)parameter.getCommandLinePattern());
        Assert.assertEquals((Object)fileType, (Object)parameter.getFileType());
        Assert.assertEquals((Object)mode, (Object)parameter.getMode());
        Assert.assertNull((Object)parameter.getDefaultValue());
        Assert.assertEquals((Object)canUsePipe, (Object)parameter.usesPipe());
    }
}

