/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters;

import csbase.exception.algorithms.ExpressionFunctionExecutionException;
import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.AlgorithmVersionId;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import csbase.logic.algorithms.ExecutionLocation;
import csbase.logic.algorithms.ExecutionType;
import csbase.logic.algorithms.parameters.ReflectionExpressionFunction;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import java.lang.reflect.Method;
import java.util.Hashtable;
import junit.framework.Assert;
import junit.framework.TestCase;

public final class ReflectionExpressionFunctionTest
extends TestCase {
    private static final String CMD_PATTERN = "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO";

    public void testReflectionExpressionFunction1() throws NoSuchMethodException, ExpressionFunctionExecutionException {
        AlgorithmInfo algorithm = new AlgorithmInfo("Identificador do algoritmo", "Nome do algoritmo", "Diret\u00f3ro do algoritmo", "algorithms", new Hashtable());
        AlgorithmVersionInfo version = new AlgorithmVersionInfo(algorithm, new AlgorithmVersionId(1, 2, 3), new Hashtable(), new Hashtable());
        SimpleAlgorithmConfigurator configurator = new SimpleAlgorithmConfigurator(version, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, "Comando", null, null, true, CMD_PATTERN);
        Method method = Method1.class.getMethod("publicStaticMethod", String.class, Float.class, Integer.class);
        ReflectionExpressionFunction function = new ReflectionExpressionFunction(method);
        String expectedParameter1 = "Texto 1";
        Float expectedParameter2 = Float.valueOf(2.0f);
        Integer expectedParameter3 = 3;
        Double expectedResult = 3.0;
        Method1.allowExecute(expectedParameter1, expectedParameter2, expectedParameter3, expectedResult);
        Object result = function.execute(configurator, new Object[]{expectedParameter1, expectedParameter2, expectedParameter3});
        ReflectionExpressionFunctionTest.assertEquals((Object)expectedResult, (Object)result);
    }

    public void testReflectionExpressionFunction2() throws NoSuchMethodException {
        Method method = Method1.class.getDeclaredMethod("privateStaticMethod", Integer.class);
        try {
            new ReflectionExpressionFunction(method);
            ReflectionExpressionFunctionTest.fail((String)IllegalArgumentException.class.getName());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testReflectionExpressionFunction3() throws NoSuchMethodException {
        Method method = Method1.class.getMethod("publicInstanceMethod", String.class);
        try {
            new ReflectionExpressionFunction(method);
            ReflectionExpressionFunctionTest.fail((String)IllegalArgumentException.class.getName());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testReflectionExpressionFunction4() {
        try {
            new ReflectionExpressionFunction(null);
            ReflectionExpressionFunctionTest.fail((String)NullPointerException.class.getName());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    protected void setUp() {
        Method1.denyExecute();
    }

    protected void tearDown() {
        Method1.denyExecute();
    }

    static class Method1 {
        private static boolean canExecute;
        private static Double result;
        private static String expectedParameter1;
        private static Float expectedParameter2;
        private static Integer expectedParameter3;

        Method1() {
        }

        static void denyExecute() {
            canExecute = false;
            expectedParameter1 = null;
            expectedParameter2 = null;
            expectedParameter3 = null;
            result = null;
        }

        static void allowExecute(String expectedParameter1, Float expectedParameter2, Integer expectedParameter3, Double result) {
            Method1.expectedParameter1 = expectedParameter1;
            Method1.expectedParameter2 = expectedParameter2;
            Method1.expectedParameter3 = expectedParameter3;
            Method1.result = result;
            canExecute = true;
        }

        public static Double publicStaticMethod(String parameter1, Float parameter2, Integer parameter3) {
            Assert.assertTrue((boolean)canExecute);
            Assert.assertEquals((String)expectedParameter1, (String)parameter1);
            Assert.assertEquals((Object)expectedParameter2, (Object)parameter2);
            Assert.assertEquals((Object)expectedParameter3, (Object)parameter3);
            return result;
        }

        private static Boolean privateStaticMethod(Integer parameter) {
            return false;
        }

        public String publicInstanceMethod(String parameter) {
            return null;
        }
    }
}

