/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters;

import csbase.logic.algorithms.parameters.TextParameter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.junit.Assert;
import org.junit.Test;

public final class TextParameterTest {
    @Test
    public void testTextParameterWithIsOptionalTrue() {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        String defaultValue = "Valor-padr\u00e3o";
        boolean isOptional = true;
        String commandLinePattern = "{0}={1}";
        Integer maxCharacters = new Integer(1234);
        TextParameter parameter = new TextParameter(name, label, description, defaultValue, isOptional, true, commandLinePattern, maxCharacters);
        Assert.assertEquals((Object)name, (Object)parameter.getName());
        Assert.assertEquals((Object)label, (Object)parameter.getLabel());
        Assert.assertEquals((Object)description, (Object)parameter.getDescription());
        Assert.assertEquals((Object)defaultValue, (Object)parameter.getDefaultValue());
        Assert.assertEquals((Object)isOptional, (Object)parameter.isOptional());
        Assert.assertEquals((Object)maxCharacters, (Object)parameter.getMaxCharacters());
    }

    @Test
    public void testTextParameterWithIsOptionalFalse() {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        String defaultValue = "Valor-padr\u00e3o";
        boolean isOptional = false;
        String commandLinePattern = "{0}={1}";
        Integer maxCharacters = new Integer(1234);
        TextParameter parameter = new TextParameter(name, label, description, defaultValue, isOptional, true, commandLinePattern, maxCharacters);
        Assert.assertEquals((Object)name, (Object)parameter.getName());
        Assert.assertEquals((Object)label, (Object)parameter.getLabel());
        Assert.assertEquals((Object)description, (Object)parameter.getDescription());
        Assert.assertEquals((Object)defaultValue, (Object)parameter.getDefaultValue());
        Assert.assertEquals((Object)isOptional, (Object)parameter.isOptional());
        Assert.assertEquals((Object)maxCharacters, (Object)parameter.getMaxCharacters());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testTextParameterWithNullName() {
        String name = null;
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        String defaultValue = "Valor-padr\u00e3o";
        boolean isOptional = false;
        String commandLinePattern = "{0}={1}";
        Integer maxCharacters = new Integer(1234);
        new TextParameter(name, label, description, defaultValue, isOptional, true, commandLinePattern, maxCharacters);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testTextParameterWithNullLabel() {
        String name = "Nome do par\u00e2metro";
        String label = null;
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        String defaultValue = "Valor-padr\u00e3o";
        boolean isOptional = false;
        String commandLinePattern = "{0}={1}";
        Integer maxCharacters = new Integer(1234);
        new TextParameter(name, label, description, defaultValue, isOptional, true, commandLinePattern, maxCharacters);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testTextParameterWithNullDescription() {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = null;
        String defaultValue = "Valor-padr\u00e3o";
        boolean isOptional = false;
        String commandLinePattern = "{0}={1}";
        Integer maxCharacters = new Integer(1234);
        new TextParameter(name, label, description, defaultValue, isOptional, true, commandLinePattern, maxCharacters);
    }

    @Test
    public void testTextParameterWithNullDefaultValue() {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        String defaultValue = null;
        boolean isOptional = true;
        String commandLinePattern = "{0}={1}";
        Integer maxCharacters = new Integer(1234);
        TextParameter parameter = new TextParameter(name, label, description, defaultValue, isOptional, true, commandLinePattern, maxCharacters);
        Assert.assertEquals((Object)name, (Object)parameter.getName());
        Assert.assertEquals((Object)label, (Object)parameter.getLabel());
        Assert.assertEquals((Object)description, (Object)parameter.getDescription());
        Assert.assertEquals(defaultValue, (Object)parameter.getDefaultValue());
        Assert.assertEquals((Object)isOptional, (Object)parameter.isOptional());
        Assert.assertEquals((Object)maxCharacters, (Object)parameter.getMaxCharacters());
    }

    @Test
    public void testTextParameterWithNullMaxCharacters() {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        String defaultValue = "Valor-padr\u00e3o";
        boolean isOptional = true;
        String commandLinePattern = "{0}={1}";
        Integer maxCharacters = null;
        TextParameter parameter = new TextParameter(name, label, description, defaultValue, isOptional, true, commandLinePattern, maxCharacters);
        Assert.assertEquals((Object)name, (Object)parameter.getName());
        Assert.assertEquals((Object)label, (Object)parameter.getLabel());
        Assert.assertEquals((Object)description, (Object)parameter.getDescription());
        Assert.assertEquals((Object)defaultValue, (Object)parameter.getDefaultValue());
        Assert.assertEquals((Object)isOptional, (Object)parameter.isOptional());
        Assert.assertNull((Object)parameter.getMaxCharacters());
    }

    @Test
    public void testGetValueAsText() {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        String defaultValue = "ValorPadraoDoParametro";
        boolean isOptional = true;
        String commandLinePattern = "{0}={1}";
        TextParameter textParameter = new TextParameter(name, label, description, defaultValue, isOptional, true, commandLinePattern, null);
        Assert.assertEquals((Object)defaultValue, (Object)textParameter.getValueAsText());
    }

    @Test
    public void testGetValueAsTextWithNullValue() {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        String defaultValue = null;
        boolean isOptional = true;
        String commandLinePattern = "{0}={1}";
        TextParameter textParameter = new TextParameter(name, label, description, defaultValue, isOptional, true, commandLinePattern, null);
        Assert.assertNull((Object)textParameter.getValueAsText());
    }

    @Test
    public void testSetValueAsText() {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        String defaultValue = "ValorPadraoDoParametro";
        boolean isOptional = true;
        String commandLinePattern = "{0}={1}";
        TextParameter textParameter = new TextParameter(name, label, description, defaultValue, isOptional, true, commandLinePattern, null);
        String value = "Valor do par\u00e2metro";
        textParameter.setValueAsText(value);
        Assert.assertEquals((Object)value, (Object)textParameter.getValueAsText());
        Assert.assertEquals((Object)value, (Object)textParameter.getValue());
    }

    @Test
    public void testSetValueAsTextWithNull() {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        String defaultValue = "Valor padr\u00e3o do par\u00e2metro";
        boolean isOptional = true;
        String commandLinePattern = "{0}={1}";
        TextParameter textParameter = new TextParameter(name, label, description, defaultValue, isOptional, true, commandLinePattern, null);
        textParameter.setValueAsText(null);
        Assert.assertNull((Object)textParameter.getValueAsText());
        Assert.assertNull((Object)textParameter.getValue());
    }

    @Test
    public void testSerialize() throws IOException, ClassNotFoundException {
        String name = "Nome do par\u00e2metro";
        String label = "R\u00f3tulo do par\u00e2metro";
        String description = "Descri\u00e7\u00e3o do par\u00e2metro";
        String defaultValue = "Valor-padr\u00e3o";
        boolean isOptional = true;
        String commandLinePattern = "{0}={1}";
        Integer maxCharacters = new Integer(1234);
        TextParameter outputParameter = new TextParameter(name, label, description, defaultValue, isOptional, true, commandLinePattern, maxCharacters);
        ByteArrayOutputStream outputSource = new ByteArrayOutputStream();
        ObjectOutputStream objectOutput = new ObjectOutputStream(outputSource);
        objectOutput.writeObject(outputParameter);
        ByteArrayInputStream inputSource = new ByteArrayInputStream(outputSource.toByteArray());
        ObjectInputStream objectInput = new ObjectInputStream(inputSource);
        TextParameter inputParameter = (TextParameter)objectInput.readObject();
        Assert.assertEquals((Object)outputParameter, (Object)inputParameter);
        Assert.assertEquals((Object)outputParameter.getName(), (Object)inputParameter.getName());
        Assert.assertEquals((Object)outputParameter.getLabel(), (Object)inputParameter.getLabel());
        Assert.assertEquals((Object)outputParameter.getDescription(), (Object)inputParameter.getDescription());
        Assert.assertEquals((Object)outputParameter.getDefaultValue(), (Object)inputParameter.getDefaultValue());
        Assert.assertEquals((Object)outputParameter.isOptional(), (Object)inputParameter.isOptional());
        Assert.assertEquals((Object)outputParameter.getMaxCharacters(), (Object)inputParameter.getMaxCharacters());
    }
}

