/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters.conditions;

import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.AlgorithmVersionId;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import csbase.logic.algorithms.ExecutionLocation;
import csbase.logic.algorithms.ExecutionType;
import csbase.logic.algorithms.parameters.MockSimpleParameter;
import csbase.logic.algorithms.parameters.Parameter;
import csbase.logic.algorithms.parameters.ParameterGroup;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parameters.conditions.SimpleCondition;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Hashtable;
import org.junit.Assert;
import org.junit.Test;

public final class SimpleConditionTest {
    private static final String CMD_PATTERN = "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO";

    @Test
    public void testSimpleCondition() {
        String parameterName = "Nome do par\u00e2metro";
        String conditionValue = "Valor condi\u00e7\u00e3o";
        SimpleCondition condition = new SimpleCondition(parameterName, (Object)conditionValue);
        Assert.assertEquals((Object)parameterName, (Object)condition.getParameterName());
        Assert.assertEquals((Object)conditionValue, (Object)condition.getValue());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSimpleConditionWithNullParameter() {
        String conditionValue = "Valor condi\u00e7\u00e3o";
        new SimpleCondition(null, (Object)conditionValue);
    }

    @Test
    public void testEquals() {
        String parameterName = "Nome do par\u00e2metro";
        String conditionValue = "Valor condi\u00e7\u00e3o";
        SimpleCondition condition1 = new SimpleCondition(parameterName, (Object)conditionValue);
        SimpleCondition condition2 = new SimpleCondition(parameterName, (Object)conditionValue);
        Assert.assertTrue((boolean)condition1.equals((Object)condition2));
    }

    @Test
    public void testEqualsWithNullValues() {
        String parameterName = "Nome do par\u00e2metro";
        Object conditionValue = null;
        SimpleCondition condition1 = new SimpleCondition(parameterName, conditionValue);
        SimpleCondition condition2 = new SimpleCondition(parameterName, conditionValue);
        Assert.assertTrue((boolean)condition1.equals((Object)condition2));
    }

    @Test
    public void testEqualsWithDifferentParameter() {
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterName2 = "Nome do par\u00e2metro 2";
        String conditionValue = "Valor condi\u00e7\u00e3o";
        SimpleCondition condition1 = new SimpleCondition(parameterName1, (Object)conditionValue);
        SimpleCondition condition2 = new SimpleCondition(parameterName2, (Object)conditionValue);
        Assert.assertFalse((boolean)condition1.equals((Object)condition2));
    }

    @Test
    public void testEqualsWithDifferentValue() {
        String parameterName = "Nome do par\u00e2metro";
        String conditionValue1 = "Valor condi\u00e7\u00e3o 1";
        String conditionValue2 = "Valor condi\u00e7\u00e3o 2";
        SimpleCondition condition1 = new SimpleCondition(parameterName, (Object)conditionValue1);
        SimpleCondition condition2 = new SimpleCondition(parameterName, (Object)conditionValue2);
        Assert.assertFalse((boolean)condition1.equals((Object)condition2));
    }

    @Test
    public void testEqualsWithNullValueAndNotNullValue() {
        String parameterName = "Nome do par\u00e2metro";
        Object conditionValue1 = null;
        String conditionValue2 = "Valor condi\u00e7\u00e3o 2";
        SimpleCondition condition1 = new SimpleCondition(parameterName, conditionValue1);
        SimpleCondition condition2 = new SimpleCondition(parameterName, (Object)conditionValue2);
        Assert.assertFalse((boolean)condition1.equals((Object)condition2));
    }

    @Test
    public void testEqualsWithNullNotValueAndNullValue() {
        String defaultValue = "Valor-padr\u00e3o";
        MockSimpleParameter parameter = new MockSimpleParameter("Nome do par\u00e2metro", "R\u00f3tulo do par\u00e2mtro", "Descri\u00e7\u00e3o do par\u00e2metro", defaultValue, false, true, "{0}{1}");
        String conditionValue1 = "Valor condi\u00e7\u00e3o 1";
        Object conditionValue2 = null;
        SimpleCondition condition1 = new SimpleCondition(parameter.getName(), (Object)conditionValue1);
        SimpleCondition condition2 = new SimpleCondition(parameter.getName(), conditionValue2);
        Assert.assertFalse((boolean)condition1.equals((Object)condition2));
    }

    @Test
    public void testEqualsWithNull() {
        SimpleCondition condition = new SimpleCondition("Nome do par\u00e2metro", (Object)"Valor condi\u00e7\u00e3o");
        Assert.assertFalse((boolean)condition.equals(null));
    }

    @Test
    public void testEqualsWithObjectOfAnotherClass() {
        SimpleCondition condition = new SimpleCondition("Nome do par\u00e2metro", (Object)"Valor condi\u00e7\u00e3o");
        Assert.assertFalse((boolean)condition.equals((Object)"Objeto de outra classe"));
    }

    @Test
    public void testHashCode() {
        String parameterName = "Nome do par\u00e2metro";
        String conditionValue = "Valor condi\u00e7\u00e3o";
        SimpleCondition condition1 = new SimpleCondition(parameterName, (Object)conditionValue);
        SimpleCondition condition2 = new SimpleCondition(parameterName, (Object)conditionValue);
        Assert.assertEquals((long)condition1.hashCode(), (long)condition2.hashCode());
    }

    @Test
    public void testEvaluate() {
        SimpleAlgorithmConfigurator configurator = this.createAlgorithmVersion();
        ParameterGroup group = new ParameterGroup("Nome do grupo");
        configurator.addGroup(group);
        String defaultValue = "Valor-padr\u00e3o";
        MockSimpleParameter parameter = new MockSimpleParameter("Nome do par\u00e2metro", "R\u00f3tulo do par\u00e2mtro", "Descri\u00e7\u00e3o do par\u00e2metro", defaultValue, false, true, "{0}{1}");
        group.addParameter((Parameter)parameter);
        SimpleCondition condition = new SimpleCondition(parameter.getName(), (Object)defaultValue);
        Assert.assertTrue((boolean)condition.evaluate(configurator));
    }

    @Test
    public void testEvaluateWithConfiguratorValueNotEqualsConditionValue() {
        SimpleAlgorithmConfigurator configurator = this.createAlgorithmVersion();
        ParameterGroup group = new ParameterGroup("Nome do grupo");
        configurator.addGroup(group);
        String defaultValue = "Valor-padr\u00e3o";
        MockSimpleParameter parameter = new MockSimpleParameter("Nome do par\u00e2metro", "R\u00f3tulo do par\u00e2mtro", "Descri\u00e7\u00e3o do par\u00e2metro", defaultValue, false, true, "{0}{1}");
        group.addParameter((Parameter)parameter);
        String conditionValue = "Outro valor";
        SimpleCondition condition = new SimpleCondition(parameter.getName(), (Object)conditionValue);
        Assert.assertFalse((boolean)condition.evaluate(configurator));
    }

    @Test
    public void testEvaluateWithNullConfiguratorValueAndNullConditionValue() {
        SimpleAlgorithmConfigurator version = this.createAlgorithmVersion();
        ParameterGroup group = new ParameterGroup("Nome do grupo");
        version.addGroup(group);
        Object defaultValue = null;
        MockSimpleParameter parameter = new MockSimpleParameter("Nome do par\u00e2metro", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", defaultValue, false, true, "{0}{1}");
        group.addParameter((Parameter)parameter);
        SimpleCondition condition = new SimpleCondition(parameter.getName(), defaultValue);
        Assert.assertTrue((boolean)condition.evaluate(version));
    }

    @Test
    public void testEvaluateWithNullParameterValueAndAConditionValue() {
        SimpleAlgorithmConfigurator configurator = this.createAlgorithmVersion();
        ParameterGroup group = new ParameterGroup("Nome do grupo");
        configurator.addGroup(group);
        Object defaultValue = null;
        MockSimpleParameter parameter = new MockSimpleParameter("Nome do par\u00e2metro", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", defaultValue, false, true, "{0}{1}");
        group.addParameter((Parameter)parameter);
        String anotherValue = "Outro valor";
        SimpleCondition condition = new SimpleCondition(parameter.getName(), (Object)anotherValue);
        Assert.assertFalse((boolean)condition.evaluate(configurator));
    }

    @Test
    public void testEvaluateWithAParameterValueAndNullConditionValue() {
        SimpleAlgorithmConfigurator configurator = this.createAlgorithmVersion();
        ParameterGroup group = new ParameterGroup("Nome do grupo");
        configurator.addGroup(group);
        String defaultValue = "Valor-padr\u00e3o";
        MockSimpleParameter parameter = new MockSimpleParameter("Nome do par\u00e2metro", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", defaultValue, false, true, "{0}{1}");
        group.addParameter((Parameter)parameter);
        Object anotherValue = null;
        SimpleCondition condition = new SimpleCondition(parameter.getName(), anotherValue);
        Assert.assertFalse((boolean)condition.evaluate(configurator));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEvaluateWithNull() {
        SimpleCondition condition = new SimpleCondition("Nome do par\u00e2metro", (Object)"Valor");
        condition.evaluate(null);
    }

    @Test
    public void testSerialize() throws IOException, ClassNotFoundException {
        SimpleCondition outputCondition = new SimpleCondition("Nome do par\u00e2metro", (Object)"Valor");
        ByteArrayOutputStream outputSource = new ByteArrayOutputStream();
        ObjectOutputStream objectOutput = new ObjectOutputStream(outputSource);
        objectOutput.writeObject(outputCondition);
        ByteArrayInputStream inputSource = new ByteArrayInputStream(outputSource.toByteArray());
        ObjectInputStream objectInput = new ObjectInputStream(inputSource);
        SimpleCondition inputCondition = (SimpleCondition)objectInput.readObject();
        Assert.assertEquals((Object)outputCondition, (Object)inputCondition);
        Assert.assertEquals((Object)outputCondition.getParameterName(), (Object)inputCondition.getParameterName());
        Assert.assertEquals((Object)outputCondition.getValue(), (Object)inputCondition.getValue());
    }

    private SimpleAlgorithmConfigurator createAlgorithmVersion() {
        AlgorithmInfo algorithmInfo = new AlgorithmInfo("ID Algoritmo", "Algoritmo", "DIR Algoritmo", "algorithms", new Hashtable());
        AlgorithmVersionId algorithmVersionId = new AlgorithmVersionId(1, 2, 3);
        AlgorithmVersionInfo algorithmVersionInfo = new AlgorithmVersionInfo(algorithmInfo, algorithmVersionId, new Hashtable(), new Hashtable());
        return new SimpleAlgorithmConfigurator(algorithmVersionInfo, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, "Comando", null, null, true, CMD_PATTERN);
    }
}

