/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters.triggers;

import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.AlgorithmVersionId;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import csbase.logic.algorithms.ExecutionLocation;
import csbase.logic.algorithms.ExecutionType;
import csbase.logic.algorithms.FileParameterValue;
import csbase.logic.algorithms.parameters.FileParameter;
import csbase.logic.algorithms.parameters.FileParameterMode;
import csbase.logic.algorithms.parameters.FileParameterPipeAcceptance;
import csbase.logic.algorithms.parameters.MockFileParameter;
import csbase.logic.algorithms.parameters.Parameter;
import csbase.logic.algorithms.parameters.ParameterGroup;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parameters.conditions.Condition;
import csbase.logic.algorithms.parameters.conditions.SimpleCondition;
import csbase.logic.algorithms.parameters.triggers.ChangeFileTypeTrigger;
import java.util.Hashtable;
import org.junit.Assert;
import org.junit.Test;

public final class ChangeFileTypeTriggerTest {
    private static final String CMD_PATTERN = "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO";

    @Test
    public void testChangeFileTypeTrigger1() {
        FileParameter fileParameter = this.createMockFileParameter();
        Condition condition = this.createMockCondition();
        String fileType = "Texto";
        ChangeFileTypeTrigger trigger = new ChangeFileTypeTrigger(fileParameter, condition, fileType);
        Assert.assertEquals((Object)fileParameter, (Object)trigger.getParameter());
        Assert.assertEquals((Object)condition, (Object)trigger.getCondition());
        Assert.assertEquals((Object)fileType, (Object)trigger.getFileType());
    }

    @Test
    public void testChangeFileTypeTrigger2() {
        FileParameter fileParameter = this.createMockFileParameter();
        Condition condition = this.createMockCondition();
        String fileType = null;
        ChangeFileTypeTrigger trigger = new ChangeFileTypeTrigger(fileParameter, condition, fileType);
        Assert.assertEquals((Object)fileParameter, (Object)trigger.getParameter());
        Assert.assertEquals((Object)condition, (Object)trigger.getCondition());
        Assert.assertEquals(fileType, (Object)trigger.getFileType());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testChangeFileTypeTrigger3() {
        Condition condition = this.createMockCondition();
        String fileType = "Texto";
        new ChangeFileTypeTrigger(null, condition, fileType);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testChangeFileTypeTrigger4() {
        FileParameter fileParameter = this.createMockFileParameter();
        String fileType = "Texto";
        new ChangeFileTypeTrigger(fileParameter, null, fileType);
    }

    @Test
    public void testDoAction1() {
        String parameterName = "Nome do par\u00e2metro";
        String fileType = "Tipo de arquivo";
        FileParameter parameter = this.createMockFileParameter(parameterName, fileType);
        FileParameterValue fileParameterValue = this.createMockFileParameterValue("Arquivo_do_parametro", fileType);
        parameter.setValue((Object)fileParameterValue);
        SimpleCondition condition = new SimpleCondition(parameterName, (Object)fileParameterValue);
        SimpleAlgorithmConfigurator configurator = this.createMockAlgorithmConfigurator();
        ParameterGroup group = this.createMockParameterGroup();
        group.addParameter((Parameter)parameter);
        configurator.addGroup(group);
        Assert.assertTrue((boolean)condition.evaluate(configurator));
        String newFileType = "Novo Tipo de arquivo";
        ChangeFileTypeTrigger trigger = new ChangeFileTypeTrigger(parameter, (Condition)condition, newFileType);
        Assert.assertTrue((boolean)trigger.update(configurator));
        Assert.assertEquals((Object)newFileType, (Object)parameter.getFileType());
    }

    @Test
    public void testDoAction2() {
        String parameterName = "Nome do par\u00e2metro";
        String fileType = "Tipo de arquivo";
        FileParameter parameter = this.createMockFileParameter(parameterName, fileType);
        FileParameterValue fileParameterValue = this.createMockFileParameterValue("Arquivo_do_parametro", fileType);
        parameter.setValue((Object)fileParameterValue);
        SimpleCondition condition = new SimpleCondition(parameterName, null);
        SimpleAlgorithmConfigurator configurator = this.createMockAlgorithmConfigurator();
        ParameterGroup group = this.createMockParameterGroup();
        group.addParameter((Parameter)parameter);
        configurator.addGroup(group);
        Assert.assertFalse((boolean)condition.evaluate(configurator));
        String newFileType = "Novo Tipo de arquivo";
        ChangeFileTypeTrigger trigger = new ChangeFileTypeTrigger(parameter, (Condition)condition, newFileType);
        Assert.assertFalse((boolean)trigger.update(configurator));
        Assert.assertEquals((Object)fileType, (Object)parameter.getFileType());
    }

    @Test
    public void testEquals1() {
        String parameterName = "Nome do par\u00e2metro";
        String fileType = "Tipo de arquivo";
        FileParameter parameter = this.createMockFileParameter(parameterName, fileType);
        SimpleCondition condition1 = new SimpleCondition("Nome do par\u00e2metro 1", (Object)"Valor 1");
        SimpleCondition condition2 = new SimpleCondition("Nome do par\u00e2metro 2", (Object)"Valor 2");
        ChangeFileTypeTrigger trigger1 = new ChangeFileTypeTrigger(parameter, (Condition)condition1, fileType);
        ChangeFileTypeTrigger trigger2 = new ChangeFileTypeTrigger(parameter, (Condition)condition2, fileType);
        Assert.assertTrue((boolean)trigger1.equals((Object)trigger2));
    }

    @Test
    public void testEquals2() {
        String fileType = "Tipo de arquivo";
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterName2 = "Nome do par\u00e2metro 2";
        FileParameter parameter1 = this.createMockFileParameter(parameterName1, fileType);
        FileParameter parameter2 = this.createMockFileParameter(parameterName2, fileType);
        SimpleCondition condition = new SimpleCondition("Nome do par\u00e2metro", (Object)"Valor");
        ChangeFileTypeTrigger trigger1 = new ChangeFileTypeTrigger(parameter1, (Condition)condition, fileType);
        ChangeFileTypeTrigger trigger2 = new ChangeFileTypeTrigger(parameter2, (Condition)condition, fileType);
        Assert.assertFalse((boolean)trigger1.equals((Object)trigger2));
    }

    @Test
    public void testEquals3() {
        String parameterName = "Nome do par\u00e2metro";
        String fileType = "Tipo de arquivo";
        FileParameter parameter = this.createMockFileParameter(parameterName, fileType);
        SimpleCondition condition = new SimpleCondition("Nome do par\u00e2metro", (Object)"Valor");
        String fileType1 = "Tipo de arquivo 1";
        String fileType2 = "Tipo de arquivo 2";
        ChangeFileTypeTrigger trigger1 = new ChangeFileTypeTrigger(parameter, (Condition)condition, fileType1);
        ChangeFileTypeTrigger trigger2 = new ChangeFileTypeTrigger(parameter, (Condition)condition, fileType2);
        Assert.assertFalse((boolean)trigger1.equals((Object)trigger2));
    }

    private SimpleAlgorithmConfigurator createMockAlgorithmConfigurator() {
        AlgorithmInfo algorithmInfo = new AlgorithmInfo("ID Algoritmo", "Algoritmo", "DIR Algoritmo", "algorithms", new Hashtable());
        AlgorithmVersionId algorithmVersionId = new AlgorithmVersionId(1, 2, 3);
        AlgorithmVersionInfo algorithmVersionInfo = new AlgorithmVersionInfo(algorithmInfo, algorithmVersionId, new Hashtable(), new Hashtable());
        return new SimpleAlgorithmConfigurator(algorithmVersionInfo, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, "Comando", null, null, true, CMD_PATTERN);
    }

    private Condition createMockCondition() {
        return new SimpleCondition("Nome do par\u00e2metro", (Object)"Valor qualquer");
    }

    private FileParameter createMockFileParameter() {
        String parameterName = "Nome do par\u00e2metro";
        String fileType = "Tipo de arquivo";
        return this.createMockFileParameter(parameterName, fileType);
    }

    private FileParameter createMockFileParameter(String parameterName, String fileType) {
        return new MockFileParameter(parameterName, "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", false, true, "{0}={1}", fileType, FileParameterMode.REGULAR_FILE, false, FileParameterPipeAcceptance.TRUE, true, false, false);
    }

    private FileParameterValue createMockFileParameterValue(String filePath, String fileType) {
        FileParameterValue file = new FileParameterValue(filePath, fileType);
        return file;
    }

    private ParameterGroup createMockParameterGroup() {
        ParameterGroup group = new ParameterGroup("Grupo de par\u00e2metros");
        return group;
    }
}

