/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters.triggers;

import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.AlgorithmVersionId;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import csbase.logic.algorithms.ExecutionLocation;
import csbase.logic.algorithms.ExecutionType;
import csbase.logic.algorithms.parameters.DoubleListParameter;
import csbase.logic.algorithms.parameters.DoubleParameter;
import csbase.logic.algorithms.parameters.Parameter;
import csbase.logic.algorithms.parameters.ParameterGroup;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parameters.conditions.Condition;
import csbase.logic.algorithms.parameters.conditions.SimpleCondition;
import csbase.logic.algorithms.parameters.triggers.ChangeMaximumForDoublesTrigger;
import java.util.Hashtable;
import org.junit.Assert;
import org.junit.Test;

public final class ChangeMaximumForDoublesTriggerTest {
    private static final String CMD_PATTERN = "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO";

    @Test
    public void testChangeMaximumTrigger1() {
        DoubleParameter parameter = this.createMockDoubleParameter();
        Condition condition = this.createMockCondition();
        Double maximum = 10.5;
        boolean includeMaximum = true;
        ChangeMaximumForDoublesTrigger trigger = new ChangeMaximumForDoublesTrigger(parameter, condition, maximum, includeMaximum);
        Assert.assertEquals((Object)parameter, (Object)trigger.getParameter());
        Assert.assertEquals((Object)condition, (Object)trigger.getCondition());
        Assert.assertEquals((Object)maximum, (Object)trigger.getMaximum());
        Assert.assertEquals((Object)includeMaximum, (Object)trigger.isMaximumIncluded());
    }

    @Test
    public void testChangeMaximumTrigger2() {
        DoubleParameter parameter = this.createMockDoubleParameter();
        Condition condition = this.createMockCondition();
        Double maximum = 10.5;
        boolean includeMaximum = false;
        ChangeMaximumForDoublesTrigger trigger = new ChangeMaximumForDoublesTrigger(parameter, condition, maximum, includeMaximum);
        Assert.assertEquals((Object)parameter, (Object)trigger.getParameter());
        Assert.assertEquals((Object)condition, (Object)trigger.getCondition());
        Assert.assertEquals((Object)maximum, (Object)trigger.getMaximum());
        Assert.assertEquals((Object)includeMaximum, (Object)trigger.isMaximumIncluded());
    }

    @Test
    public void testChangeMaximumTrigger3() {
        DoubleParameter parameter = this.createMockDoubleParameter();
        Condition condition = this.createMockCondition();
        Double maximum = null;
        boolean includeMaximum = false;
        ChangeMaximumForDoublesTrigger trigger = new ChangeMaximumForDoublesTrigger(parameter, condition, maximum, includeMaximum);
        Assert.assertEquals((Object)parameter, (Object)trigger.getParameter());
        Assert.assertEquals((Object)condition, (Object)trigger.getCondition());
        Assert.assertEquals(maximum, (Object)trigger.getMaximum());
        Assert.assertEquals((Object)includeMaximum, (Object)trigger.isMaximumIncluded());
    }

    @Test
    public void testChangeMaximumTrigger4() {
        DoubleListParameter parameter = this.createMockDoubleListParameter();
        Condition condition = this.createMockCondition();
        Double maximum = 10.5;
        boolean includeMaximum = true;
        ChangeMaximumForDoublesTrigger trigger = new ChangeMaximumForDoublesTrigger(parameter, condition, maximum, includeMaximum);
        Assert.assertEquals((Object)parameter, (Object)trigger.getParameter());
        Assert.assertEquals((Object)condition, (Object)trigger.getCondition());
        Assert.assertEquals((Object)maximum, (Object)trigger.getMaximum());
        Assert.assertEquals((Object)includeMaximum, (Object)trigger.isMaximumIncluded());
    }

    @Test
    public void testChangeMaximumTrigger5() {
        DoubleListParameter parameter = this.createMockDoubleListParameter();
        Condition condition = this.createMockCondition();
        Double maximum = 10.5;
        boolean includeMaximum = false;
        ChangeMaximumForDoublesTrigger trigger = new ChangeMaximumForDoublesTrigger(parameter, condition, maximum, includeMaximum);
        Assert.assertEquals((Object)parameter, (Object)trigger.getParameter());
        Assert.assertEquals((Object)condition, (Object)trigger.getCondition());
        Assert.assertEquals((Object)maximum, (Object)trigger.getMaximum());
        Assert.assertEquals((Object)includeMaximum, (Object)trigger.isMaximumIncluded());
    }

    @Test
    public void testChangeMaximumTrigger6() {
        DoubleListParameter parameter = this.createMockDoubleListParameter();
        Condition condition = this.createMockCondition();
        Double maximum = null;
        boolean includeMaximum = false;
        ChangeMaximumForDoublesTrigger trigger = new ChangeMaximumForDoublesTrigger(parameter, condition, maximum, includeMaximum);
        Assert.assertEquals((Object)parameter, (Object)trigger.getParameter());
        Assert.assertEquals((Object)condition, (Object)trigger.getCondition());
        Assert.assertEquals(maximum, (Object)trigger.getMaximum());
        Assert.assertEquals((Object)includeMaximum, (Object)trigger.isMaximumIncluded());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testChangeMaximumTrigger7() {
        DoubleParameter parameter = null;
        Condition condition = this.createMockCondition();
        Double maximum = 10.5;
        boolean includeMaximum = true;
        new ChangeMaximumForDoublesTrigger(parameter, condition, maximum, includeMaximum);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testChangeMaximumTrigger8() {
        DoubleListParameter parameter = null;
        Condition condition = this.createMockCondition();
        Double maximum = 10.5;
        boolean includeMaximum = true;
        new ChangeMaximumForDoublesTrigger(parameter, condition, maximum, includeMaximum);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testChangeMaximumTrigger9() {
        DoubleParameter parameter = this.createMockDoubleParameter();
        Condition condition = null;
        Double maximum = 10.5;
        boolean includeMaximum = true;
        new ChangeMaximumForDoublesTrigger(parameter, condition, maximum, includeMaximum);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testChangeMaximumTrigger10() {
        DoubleListParameter parameter = this.createMockDoubleListParameter();
        Condition condition = null;
        Double maximum = 10.5;
        boolean includeMaximum = true;
        new ChangeMaximumForDoublesTrigger(parameter, condition, maximum, includeMaximum);
    }

    @Test
    public void testDoAction1() {
        String parameterName = "Nome do par\u00e2metro";
        Double defaultValue = 10.5;
        Double maximum = 21.0;
        boolean isMaximumIncluded = true;
        DoubleParameter parameter = this.createMockDoubleParameter(parameterName, defaultValue, maximum, isMaximumIncluded);
        Assert.assertEquals((Object)maximum, (Object)parameter.getMaximum());
        Assert.assertEquals((Object)isMaximumIncluded, (Object)parameter.isMaximumIncluded());
        SimpleCondition condition = new SimpleCondition(parameterName, (Object)defaultValue);
        SimpleAlgorithmConfigurator configurator = this.createMockAlgorithmConfigurator();
        ParameterGroup group = new ParameterGroup("Grupo de par\u00e2metros");
        group.addParameter((Parameter)parameter);
        configurator.addGroup(group);
        Assert.assertTrue((boolean)condition.evaluate(configurator));
        Double newMaximum = 31.5;
        boolean newIsMaximumIncluded = !isMaximumIncluded;
        ChangeMaximumForDoublesTrigger trigger = new ChangeMaximumForDoublesTrigger(parameter, (Condition)condition, newMaximum, newIsMaximumIncluded);
        Assert.assertTrue((boolean)trigger.update(configurator));
        Assert.assertEquals((Object)newMaximum, (Object)parameter.getMaximum());
        Assert.assertEquals((Object)newIsMaximumIncluded, (Object)parameter.isMaximumIncluded());
    }

    @Test
    public void testDoAction2() {
        String parameterName = "Nome do par\u00e2metro";
        Double maximum = 21.0;
        boolean isMaximumIncluded = true;
        DoubleListParameter parameter = this.createMockDoubleListParameter(parameterName, maximum, isMaximumIncluded);
        Assert.assertEquals((Object)maximum, (Object)parameter.getMaximum());
        Assert.assertEquals((Object)isMaximumIncluded, (Object)parameter.isMaximumIncluded());
        SimpleCondition condition = new SimpleCondition(parameterName, null);
        SimpleAlgorithmConfigurator configurator = this.createMockAlgorithmConfigurator();
        ParameterGroup group = new ParameterGroup("Grupo de par\u00e2metros");
        group.addParameter((Parameter)parameter);
        configurator.addGroup(group);
        Assert.assertTrue((boolean)condition.evaluate(configurator));
        Double newMaximum = 31.5;
        boolean newIsMaximumIncluded = !isMaximumIncluded;
        ChangeMaximumForDoublesTrigger trigger = new ChangeMaximumForDoublesTrigger(parameter, (Condition)condition, newMaximum, newIsMaximumIncluded);
        Assert.assertTrue((boolean)trigger.update(configurator));
        Assert.assertEquals((Object)newMaximum, (Object)parameter.getMaximum());
        Assert.assertEquals((Object)newIsMaximumIncluded, (Object)parameter.isMaximumIncluded());
    }

    @Test
    public void testDoAction3() {
        String parameterName = "Nome do par\u00e2metro";
        Double defaultValue = 10.5;
        Double maximum = 21.0;
        boolean isMaximumIncluded = true;
        DoubleParameter parameter = this.createMockDoubleParameter(parameterName, defaultValue, maximum, isMaximumIncluded);
        Assert.assertEquals((Object)maximum, (Object)parameter.getMaximum());
        Assert.assertEquals((Object)isMaximumIncluded, (Object)parameter.isMaximumIncluded());
        SimpleCondition condition = new SimpleCondition(parameterName, null);
        SimpleAlgorithmConfigurator configurator = this.createMockAlgorithmConfigurator();
        ParameterGroup group = new ParameterGroup("Grupo de par\u00e2metros");
        group.addParameter((Parameter)parameter);
        configurator.addGroup(group);
        Assert.assertFalse((boolean)condition.evaluate(configurator));
        Double newMaximum = 31.5;
        boolean newIsMaximumIncluded = !isMaximumIncluded;
        ChangeMaximumForDoublesTrigger trigger = new ChangeMaximumForDoublesTrigger(parameter, (Condition)condition, newMaximum, newIsMaximumIncluded);
        Assert.assertFalse((boolean)trigger.update(configurator));
        Assert.assertEquals((Object)maximum, (Object)parameter.getMaximum());
        Assert.assertEquals((Object)isMaximumIncluded, (Object)parameter.isMaximumIncluded());
    }

    @Test
    public void testDoAction4() {
        String parameterName = "Nome do par\u00e2metro";
        Double maximum = 21.0;
        boolean isMaximumIncluded = true;
        DoubleListParameter parameter = this.createMockDoubleListParameter(parameterName, maximum, isMaximumIncluded);
        Assert.assertEquals((Object)maximum, (Object)parameter.getMaximum());
        Assert.assertEquals((Object)isMaximumIncluded, (Object)parameter.isMaximumIncluded());
        Double value = 34.5;
        SimpleCondition condition = new SimpleCondition(parameterName, (Object)value);
        SimpleAlgorithmConfigurator configurator = this.createMockAlgorithmConfigurator();
        ParameterGroup group = new ParameterGroup("Grupo de par\u00e2metros");
        group.addParameter((Parameter)parameter);
        configurator.addGroup(group);
        Assert.assertFalse((boolean)condition.evaluate(configurator));
        Double newMaximum = 31.5;
        boolean newIsMaximumIncluded = !isMaximumIncluded;
        ChangeMaximumForDoublesTrigger trigger = new ChangeMaximumForDoublesTrigger(parameter, (Condition)condition, newMaximum, newIsMaximumIncluded);
        Assert.assertFalse((boolean)trigger.update(configurator));
        Assert.assertEquals((Object)maximum, (Object)parameter.getMaximum());
        Assert.assertEquals((Object)isMaximumIncluded, (Object)parameter.isMaximumIncluded());
    }

    @Test
    public void testEquals1() {
        String parameterName = "Nome do par\u00e2metro";
        DoubleParameter parameter = this.createMockDoubleParameter(parameterName);
        Double maximum = 10.5;
        boolean isMaximumIncluded = true;
        SimpleCondition condition1 = new SimpleCondition("Nome do par\u00e2metro 1", (Object)"Valor 1");
        SimpleCondition condition2 = new SimpleCondition("Nome do par\u00e2metro 2", (Object)"Valor 2");
        ChangeMaximumForDoublesTrigger trigger1 = new ChangeMaximumForDoublesTrigger(parameter, (Condition)condition1, maximum, isMaximumIncluded);
        ChangeMaximumForDoublesTrigger trigger2 = new ChangeMaximumForDoublesTrigger(parameter, (Condition)condition2, maximum, isMaximumIncluded);
        Assert.assertTrue((boolean)trigger1.equals((Object)trigger2));
    }

    @Test
    public void testEquals2() {
        String parameterName = "Nome do par\u00e2metro";
        DoubleListParameter parameter = this.createMockDoubleListParameter(parameterName);
        Double maximum = 10.5;
        boolean isMaximumIncluded = true;
        SimpleCondition condition1 = new SimpleCondition("Nome do par\u00e2metro 1", (Object)"Valor 1");
        SimpleCondition condition2 = new SimpleCondition("Nome do par\u00e2metro 2", (Object)"Valor 2");
        ChangeMaximumForDoublesTrigger trigger1 = new ChangeMaximumForDoublesTrigger(parameter, (Condition)condition1, maximum, isMaximumIncluded);
        ChangeMaximumForDoublesTrigger trigger2 = new ChangeMaximumForDoublesTrigger(parameter, (Condition)condition2, maximum, isMaximumIncluded);
        Assert.assertTrue((boolean)trigger1.equals((Object)trigger2));
    }

    @Test
    public void testEquals3() {
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterName2 = "Nome do par\u00e2metro 2";
        DoubleParameter parameter1 = this.createMockDoubleParameter(parameterName1);
        DoubleParameter parameter2 = this.createMockDoubleParameter(parameterName2);
        Double maximum = 10.5;
        boolean isMaximumIncluded = true;
        SimpleCondition condition = new SimpleCondition("Nome do par\u00e2metro", (Object)"Valor");
        ChangeMaximumForDoublesTrigger trigger1 = new ChangeMaximumForDoublesTrigger(parameter1, (Condition)condition, maximum, isMaximumIncluded);
        ChangeMaximumForDoublesTrigger trigger2 = new ChangeMaximumForDoublesTrigger(parameter2, (Condition)condition, maximum, isMaximumIncluded);
        Assert.assertFalse((boolean)trigger1.equals((Object)trigger2));
    }

    @Test
    public void testEquals4() {
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterName2 = "Nome do par\u00e2metro 2";
        DoubleListParameter parameter1 = this.createMockDoubleListParameter(parameterName1);
        DoubleListParameter parameter2 = this.createMockDoubleListParameter(parameterName2);
        Double maximum = 10.5;
        boolean isMaximumIncluded = true;
        SimpleCondition condition = new SimpleCondition("Nome do par\u00e2metro", (Object)"Valor");
        ChangeMaximumForDoublesTrigger trigger1 = new ChangeMaximumForDoublesTrigger(parameter1, (Condition)condition, maximum, isMaximumIncluded);
        ChangeMaximumForDoublesTrigger trigger2 = new ChangeMaximumForDoublesTrigger(parameter2, (Condition)condition, maximum, isMaximumIncluded);
        Assert.assertFalse((boolean)trigger1.equals((Object)trigger2));
    }

    @Test
    public void testEquals5() {
        String parameterName = "Nome do par\u00e2metro";
        DoubleParameter parameter = this.createMockDoubleParameter(parameterName);
        Double maximum1 = 11.1;
        Double maximum2 = 22.2;
        boolean isMaximumIncluded = true;
        SimpleCondition condition = new SimpleCondition("Nome do par\u00e2metro", (Object)"Valor");
        ChangeMaximumForDoublesTrigger trigger1 = new ChangeMaximumForDoublesTrigger(parameter, (Condition)condition, maximum1, isMaximumIncluded);
        ChangeMaximumForDoublesTrigger trigger2 = new ChangeMaximumForDoublesTrigger(parameter, (Condition)condition, maximum2, isMaximumIncluded);
        Assert.assertFalse((boolean)trigger1.equals((Object)trigger2));
    }

    @Test
    public void testEquals6() {
        String parameterName = "Nome do par\u00e2metro";
        DoubleListParameter parameter = this.createMockDoubleListParameter(parameterName);
        Double maximum1 = 11.1;
        Double maximum2 = 22.2;
        boolean isMaximumIncluded = true;
        SimpleCondition condition = new SimpleCondition("Nome do par\u00e2metro", (Object)"Valor");
        ChangeMaximumForDoublesTrigger trigger1 = new ChangeMaximumForDoublesTrigger(parameter, (Condition)condition, maximum1, isMaximumIncluded);
        ChangeMaximumForDoublesTrigger trigger2 = new ChangeMaximumForDoublesTrigger(parameter, (Condition)condition, maximum2, isMaximumIncluded);
        Assert.assertFalse((boolean)trigger1.equals((Object)trigger2));
    }

    @Test
    public void testEquals7() {
        String parameterName = "Nome do par\u00e2metro";
        DoubleParameter parameter = this.createMockDoubleParameter(parameterName);
        Double maximum = 10.5;
        boolean isMaximumIncluded1 = true;
        boolean isMaximumIncluded2 = false;
        SimpleCondition condition = new SimpleCondition("Nome do par\u00e2metro", (Object)"Valor");
        ChangeMaximumForDoublesTrigger trigger1 = new ChangeMaximumForDoublesTrigger(parameter, (Condition)condition, maximum, isMaximumIncluded1);
        ChangeMaximumForDoublesTrigger trigger2 = new ChangeMaximumForDoublesTrigger(parameter, (Condition)condition, maximum, isMaximumIncluded2);
        Assert.assertFalse((boolean)trigger1.equals((Object)trigger2));
    }

    @Test
    public void testEquals8() {
        String parameterName = "Nome do par\u00e2metro";
        DoubleListParameter parameter = this.createMockDoubleListParameter(parameterName);
        Double maximum = 10.5;
        boolean isMaximumIncluded1 = true;
        boolean isMaximumIncluded2 = false;
        SimpleCondition condition = new SimpleCondition("Nome do par\u00e2metro", (Object)"Valor");
        ChangeMaximumForDoublesTrigger trigger1 = new ChangeMaximumForDoublesTrigger(parameter, (Condition)condition, maximum, isMaximumIncluded1);
        ChangeMaximumForDoublesTrigger trigger2 = new ChangeMaximumForDoublesTrigger(parameter, (Condition)condition, maximum, isMaximumIncluded2);
        Assert.assertFalse((boolean)trigger1.equals((Object)trigger2));
    }

    @Test
    public void testEquals9() {
        String parameterName = "Nome do par\u00e2metro";
        DoubleListParameter parameter1 = this.createMockDoubleListParameter(parameterName);
        DoubleParameter parameter2 = this.createMockDoubleParameter(parameterName);
        Double maximum = 10.5;
        boolean isMaximumIncluded = true;
        SimpleCondition condition = new SimpleCondition("Nome do par\u00e2metro", (Object)"Valor");
        ChangeMaximumForDoublesTrigger trigger1 = new ChangeMaximumForDoublesTrigger(parameter1, (Condition)condition, maximum, isMaximumIncluded);
        ChangeMaximumForDoublesTrigger trigger2 = new ChangeMaximumForDoublesTrigger(parameter2, (Condition)condition, maximum, isMaximumIncluded);
        Assert.assertFalse((boolean)trigger1.equals((Object)trigger2));
    }

    @Test
    public void testEquals10() {
        String parameterName = "Nome do par\u00e2metro";
        DoubleParameter parameter = this.createMockDoubleParameter(parameterName);
        Double maximum = 10.5;
        boolean isMaximumIncluded = true;
        SimpleCondition condition = new SimpleCondition("Nome do par\u00e2metro", (Object)"Valor");
        ChangeMaximumForDoublesTrigger trigger = new ChangeMaximumForDoublesTrigger(parameter, (Condition)condition, maximum, isMaximumIncluded);
        Assert.assertFalse((boolean)trigger.equals(null));
    }

    @Test
    public void testEquals11() {
        String parameterName = "Nome do par\u00e2metro";
        DoubleParameter parameter = this.createMockDoubleParameter(parameterName);
        Double maximum = 10.5;
        boolean isMaximumIncluded = true;
        SimpleCondition condition = new SimpleCondition("Nome do par\u00e2metro", (Object)"Valor");
        ChangeMaximumForDoublesTrigger trigger = new ChangeMaximumForDoublesTrigger(parameter, (Condition)condition, maximum, isMaximumIncluded);
        Assert.assertFalse((boolean)trigger.equals((Object)"Outra classe"));
    }

    @Test
    public void testEquals12() {
        String parameterName = "Nome do par\u00e2metro";
        DoubleListParameter parameter = this.createMockDoubleListParameter(parameterName);
        Double maximum = 10.5;
        boolean isMaximumIncluded = true;
        SimpleCondition condition = new SimpleCondition("Nome do par\u00e2metro", (Object)"Valor");
        ChangeMaximumForDoublesTrigger trigger = new ChangeMaximumForDoublesTrigger(parameter, (Condition)condition, maximum, isMaximumIncluded);
        Assert.assertFalse((boolean)trigger.equals(null));
    }

    @Test
    public void testEquals13() {
        String parameterName = "Nome do par\u00e2metro";
        DoubleListParameter parameter = this.createMockDoubleListParameter(parameterName);
        Double maximum = 10.5;
        boolean isMaximumIncluded = true;
        SimpleCondition condition = new SimpleCondition("Nome do par\u00e2metro", (Object)"Valor");
        ChangeMaximumForDoublesTrigger trigger = new ChangeMaximumForDoublesTrigger(parameter, (Condition)condition, maximum, isMaximumIncluded);
        Assert.assertFalse((boolean)trigger.equals((Object)"Outra classe"));
    }

    private SimpleAlgorithmConfigurator createMockAlgorithmConfigurator() {
        AlgorithmInfo algorithmInfo = new AlgorithmInfo("ID Algoritmo", "Algoritmo", "DIR Algoritmo", "algorithms", new Hashtable());
        AlgorithmVersionId algorithmVersionId = new AlgorithmVersionId(1, 2, 3);
        AlgorithmVersionInfo algorithmVersionInfo = new AlgorithmVersionInfo(algorithmInfo, algorithmVersionId, new Hashtable(), new Hashtable());
        return new SimpleAlgorithmConfigurator(algorithmVersionInfo, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, "Comando", null, null, true, CMD_PATTERN);
    }

    private DoubleListParameter createMockDoubleListParameter() {
        String parameterName = "Nome do par\u00e2metro";
        return this.createMockDoubleListParameter(parameterName);
    }

    private DoubleListParameter createMockDoubleListParameter(String parameterName) {
        Double maximum = null;
        boolean isMaximumIncluded = false;
        return this.createMockDoubleListParameter(parameterName, maximum, isMaximumIncluded);
    }

    private DoubleListParameter createMockDoubleListParameter(String parameterName, Double maximum, boolean isMaximumIncluded) {
        return new DoubleListParameter(parameterName, "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", null, false, true, "{0}={1}", maximum, isMaximumIncluded, null, false);
    }

    private DoubleParameter createMockDoubleParameter() {
        String parameterName = "Nome do par\u00e2metro";
        return this.createMockDoubleParameter(parameterName);
    }

    private DoubleParameter createMockDoubleParameter(String parameterName) {
        Double defaultValue = null;
        Double maximum = null;
        boolean isMaximumIncluded = false;
        return this.createMockDoubleParameter(parameterName, defaultValue, maximum, isMaximumIncluded);
    }

    private DoubleParameter createMockDoubleParameter(String parameterName, Double defaultValue, Double maximum, boolean isMaximumIncluded) {
        return new DoubleParameter(parameterName, "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", defaultValue, false, true, "{0}={1}", maximum, isMaximumIncluded, null, false);
    }

    private Condition createMockCondition() {
        return new SimpleCondition("Nome do par\u00e2metro", (Object)"Valor qualquer");
    }
}

