/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters.triggers;

import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.AlgorithmVersionId;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import csbase.logic.algorithms.ExecutionLocation;
import csbase.logic.algorithms.ExecutionType;
import csbase.logic.algorithms.parameters.DoubleListParameter;
import csbase.logic.algorithms.parameters.DoubleParameter;
import csbase.logic.algorithms.parameters.Parameter;
import csbase.logic.algorithms.parameters.ParameterGroup;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parameters.conditions.Condition;
import csbase.logic.algorithms.parameters.conditions.SimpleCondition;
import csbase.logic.algorithms.parameters.triggers.ChangeMinimumForDoublesTrigger;
import java.util.Hashtable;
import org.junit.Assert;
import org.junit.Test;

public final class ChangeMinimumForDoublesTriggerTest {
    private static final String CMD_PATTERN = "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO";

    @Test
    public void testChangeMinimumTrigger1() {
        DoubleParameter parameter = this.createMockDoubleParameter();
        Condition condition = this.createMockCondition();
        Double minimum = 10.5;
        boolean includeMinimum = true;
        ChangeMinimumForDoublesTrigger trigger = new ChangeMinimumForDoublesTrigger(parameter, condition, minimum, includeMinimum);
        Assert.assertEquals((Object)parameter, (Object)trigger.getParameter());
        Assert.assertEquals((Object)condition, (Object)trigger.getCondition());
        Assert.assertEquals((Object)minimum, (Object)trigger.getMinimum());
        Assert.assertEquals((Object)includeMinimum, (Object)trigger.isMinimumIncluded());
    }

    @Test
    public void testChangeMinimumTrigger2() {
        DoubleParameter parameter = this.createMockDoubleParameter();
        Condition condition = this.createMockCondition();
        Double minimum = 10.5;
        boolean includeMinimum = false;
        ChangeMinimumForDoublesTrigger trigger = new ChangeMinimumForDoublesTrigger(parameter, condition, minimum, includeMinimum);
        Assert.assertEquals((Object)parameter, (Object)trigger.getParameter());
        Assert.assertEquals((Object)condition, (Object)trigger.getCondition());
        Assert.assertEquals((Object)minimum, (Object)trigger.getMinimum());
        Assert.assertEquals((Object)includeMinimum, (Object)trigger.isMinimumIncluded());
    }

    @Test
    public void testChangeMinimumTrigger3() {
        DoubleParameter parameter = this.createMockDoubleParameter();
        Condition condition = this.createMockCondition();
        Double minimum = null;
        boolean includeMinimum = false;
        ChangeMinimumForDoublesTrigger trigger = new ChangeMinimumForDoublesTrigger(parameter, condition, minimum, includeMinimum);
        Assert.assertEquals((Object)parameter, (Object)trigger.getParameter());
        Assert.assertEquals((Object)condition, (Object)trigger.getCondition());
        Assert.assertEquals(minimum, (Object)trigger.getMinimum());
        Assert.assertEquals((Object)includeMinimum, (Object)trigger.isMinimumIncluded());
    }

    @Test
    public void testChangeMinimumTrigger4() {
        DoubleListParameter parameter = this.createMockDoubleListParameter();
        Condition condition = this.createMockCondition();
        Double minimum = 10.5;
        boolean includeMinimum = true;
        ChangeMinimumForDoublesTrigger trigger = new ChangeMinimumForDoublesTrigger(parameter, condition, minimum, includeMinimum);
        Assert.assertEquals((Object)parameter, (Object)trigger.getParameter());
        Assert.assertEquals((Object)condition, (Object)trigger.getCondition());
        Assert.assertEquals((Object)minimum, (Object)trigger.getMinimum());
        Assert.assertEquals((Object)includeMinimum, (Object)trigger.isMinimumIncluded());
    }

    @Test
    public void testChangeMinimumTrigger5() {
        DoubleListParameter parameter = this.createMockDoubleListParameter();
        Condition condition = this.createMockCondition();
        Double minimum = 10.5;
        boolean includeMinimum = false;
        ChangeMinimumForDoublesTrigger trigger = new ChangeMinimumForDoublesTrigger(parameter, condition, minimum, includeMinimum);
        Assert.assertEquals((Object)parameter, (Object)trigger.getParameter());
        Assert.assertEquals((Object)condition, (Object)trigger.getCondition());
        Assert.assertEquals((Object)minimum, (Object)trigger.getMinimum());
        Assert.assertEquals((Object)includeMinimum, (Object)trigger.isMinimumIncluded());
    }

    @Test
    public void testChangeMinimumTrigger6() {
        DoubleListParameter parameter = this.createMockDoubleListParameter();
        Condition condition = this.createMockCondition();
        Double minimum = null;
        boolean includeMinimum = false;
        ChangeMinimumForDoublesTrigger trigger = new ChangeMinimumForDoublesTrigger(parameter, condition, minimum, includeMinimum);
        Assert.assertEquals((Object)parameter, (Object)trigger.getParameter());
        Assert.assertEquals((Object)condition, (Object)trigger.getCondition());
        Assert.assertEquals(minimum, (Object)trigger.getMinimum());
        Assert.assertEquals((Object)includeMinimum, (Object)trigger.isMinimumIncluded());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testChangeMinimumTrigger7() {
        DoubleParameter parameter = null;
        Condition condition = this.createMockCondition();
        Double minimum = 10.5;
        boolean includeMinimum = true;
        new ChangeMinimumForDoublesTrigger(parameter, condition, minimum, includeMinimum);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testChangeMinimumTrigger8() {
        DoubleListParameter parameter = null;
        Condition condition = this.createMockCondition();
        Double minimum = 10.5;
        boolean includeMinimum = true;
        new ChangeMinimumForDoublesTrigger(parameter, condition, minimum, includeMinimum);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testChangeMinimumTrigger9() {
        DoubleParameter parameter = this.createMockDoubleParameter();
        Condition condition = null;
        Double minimum = 10.5;
        boolean includeMinimum = true;
        new ChangeMinimumForDoublesTrigger(parameter, condition, minimum, includeMinimum);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testChangeMinimumTrigger10() {
        DoubleListParameter parameter = this.createMockDoubleListParameter();
        Condition condition = null;
        Double minimum = 10.5;
        boolean includeMinimum = true;
        new ChangeMinimumForDoublesTrigger(parameter, condition, minimum, includeMinimum);
    }

    @Test
    public void testDoAction1() {
        String parameterName = "Nome do par\u00e2metro";
        Double defaultValue = 10.5;
        Double minimum = 21.0;
        boolean isMinimumIncluded = true;
        DoubleParameter parameter = this.createMockDoubleParameter(parameterName, defaultValue, minimum, isMinimumIncluded);
        Assert.assertEquals((Object)minimum, (Object)parameter.getMinimum());
        Assert.assertEquals((Object)isMinimumIncluded, (Object)parameter.isMinimumIncluded());
        SimpleCondition condition = new SimpleCondition(parameterName, (Object)defaultValue);
        SimpleAlgorithmConfigurator configurator = this.createMockAlgorithmConfigurator();
        ParameterGroup group = new ParameterGroup("Grupo de par\u00e2metros");
        group.addParameter((Parameter)parameter);
        configurator.addGroup(group);
        Assert.assertTrue((boolean)condition.evaluate(configurator));
        Double newMinimum = 31.5;
        boolean newIsMinimumIncluded = !isMinimumIncluded;
        ChangeMinimumForDoublesTrigger trigger = new ChangeMinimumForDoublesTrigger(parameter, (Condition)condition, newMinimum, newIsMinimumIncluded);
        Assert.assertTrue((boolean)trigger.update(configurator));
        Assert.assertEquals((Object)newMinimum, (Object)parameter.getMinimum());
        Assert.assertEquals((Object)newIsMinimumIncluded, (Object)parameter.isMinimumIncluded());
    }

    @Test
    public void testDoAction2() {
        String parameterName = "Nome do par\u00e2metro";
        Double minimum = 21.0;
        boolean isMinimumIncluded = true;
        DoubleListParameter parameter = this.createMockDoubleListParameter(parameterName, minimum, isMinimumIncluded);
        Assert.assertEquals((Object)minimum, (Object)parameter.getMinimum());
        Assert.assertEquals((Object)isMinimumIncluded, (Object)parameter.isMinimumIncluded());
        SimpleCondition condition = new SimpleCondition(parameterName, null);
        SimpleAlgorithmConfigurator configurator = this.createMockAlgorithmConfigurator();
        ParameterGroup group = new ParameterGroup("Grupo de par\u00e2metros");
        group.addParameter((Parameter)parameter);
        configurator.addGroup(group);
        Assert.assertTrue((boolean)condition.evaluate(configurator));
        Double newMinimum = 31.5;
        boolean newIsMinimumIncluded = !isMinimumIncluded;
        ChangeMinimumForDoublesTrigger trigger = new ChangeMinimumForDoublesTrigger(parameter, (Condition)condition, newMinimum, newIsMinimumIncluded);
        Assert.assertTrue((boolean)trigger.update(configurator));
        Assert.assertEquals((Object)newMinimum, (Object)parameter.getMinimum());
        Assert.assertEquals((Object)newIsMinimumIncluded, (Object)parameter.isMinimumIncluded());
    }

    @Test
    public void testDoAction3() {
        String parameterName = "Nome do par\u00e2metro";
        Double defaultValue = 10.5;
        Double minimum = 21.0;
        boolean isMinimumIncluded = true;
        DoubleParameter parameter = this.createMockDoubleParameter(parameterName, defaultValue, minimum, isMinimumIncluded);
        Assert.assertEquals((Object)minimum, (Object)parameter.getMinimum());
        Assert.assertEquals((Object)isMinimumIncluded, (Object)parameter.isMinimumIncluded());
        SimpleCondition condition = new SimpleCondition(parameterName, null);
        SimpleAlgorithmConfigurator configurator = this.createMockAlgorithmConfigurator();
        ParameterGroup group = new ParameterGroup("Grupo de par\u00e2metros");
        group.addParameter((Parameter)parameter);
        configurator.addGroup(group);
        Assert.assertFalse((boolean)condition.evaluate(configurator));
        Double newMinimum = 31.5;
        boolean newIsMinimumIncluded = !isMinimumIncluded;
        ChangeMinimumForDoublesTrigger trigger = new ChangeMinimumForDoublesTrigger(parameter, (Condition)condition, newMinimum, newIsMinimumIncluded);
        Assert.assertFalse((boolean)trigger.update(configurator));
        Assert.assertEquals((Object)minimum, (Object)parameter.getMinimum());
        Assert.assertEquals((Object)isMinimumIncluded, (Object)parameter.isMinimumIncluded());
    }

    @Test
    public void testDoAction4() {
        String parameterName = "Nome do par\u00e2metro";
        Double minimum = 21.0;
        boolean isMinimumIncluded = true;
        DoubleListParameter parameter = this.createMockDoubleListParameter(parameterName, minimum, isMinimumIncluded);
        Assert.assertEquals((Object)minimum, (Object)parameter.getMinimum());
        Assert.assertEquals((Object)isMinimumIncluded, (Object)parameter.isMinimumIncluded());
        Double value = 34.5;
        SimpleCondition condition = new SimpleCondition(parameterName, (Object)value);
        SimpleAlgorithmConfigurator configurator = this.createMockAlgorithmConfigurator();
        ParameterGroup group = new ParameterGroup("Grupo de par\u00e2metros");
        group.addParameter((Parameter)parameter);
        configurator.addGroup(group);
        Assert.assertFalse((boolean)condition.evaluate(configurator));
        Double newMinimum = 31.5;
        boolean newIsMinimumIncluded = !isMinimumIncluded;
        ChangeMinimumForDoublesTrigger trigger = new ChangeMinimumForDoublesTrigger(parameter, (Condition)condition, newMinimum, newIsMinimumIncluded);
        Assert.assertFalse((boolean)trigger.update(configurator));
        Assert.assertEquals((Object)minimum, (Object)parameter.getMinimum());
        Assert.assertEquals((Object)isMinimumIncluded, (Object)parameter.isMinimumIncluded());
    }

    @Test
    public void testEquals1() {
        String parameterName = "Nome do par\u00e2metro";
        DoubleParameter parameter = this.createMockDoubleParameter(parameterName);
        Double minimum = 10.5;
        boolean isMinimumIncluded = true;
        SimpleCondition condition1 = new SimpleCondition("Nome do par\u00e2metro 1", (Object)"Valor 1");
        SimpleCondition condition2 = new SimpleCondition("Nome do par\u00e2metro 2", (Object)"Valor 2");
        ChangeMinimumForDoublesTrigger trigger1 = new ChangeMinimumForDoublesTrigger(parameter, (Condition)condition1, minimum, isMinimumIncluded);
        ChangeMinimumForDoublesTrigger trigger2 = new ChangeMinimumForDoublesTrigger(parameter, (Condition)condition2, minimum, isMinimumIncluded);
        Assert.assertTrue((boolean)trigger1.equals((Object)trigger2));
    }

    @Test
    public void testEquals2() {
        String parameterName = "Nome do par\u00e2metro";
        DoubleListParameter parameter = this.createMockDoubleListParameter(parameterName);
        Double minimum = 10.5;
        boolean isMinimumIncluded = true;
        SimpleCondition condition1 = new SimpleCondition("Nome do par\u00e2metro 1", (Object)"Valor 1");
        SimpleCondition condition2 = new SimpleCondition("Nome do par\u00e2metro 2", (Object)"Valor 2");
        ChangeMinimumForDoublesTrigger trigger1 = new ChangeMinimumForDoublesTrigger(parameter, (Condition)condition1, minimum, isMinimumIncluded);
        ChangeMinimumForDoublesTrigger trigger2 = new ChangeMinimumForDoublesTrigger(parameter, (Condition)condition2, minimum, isMinimumIncluded);
        Assert.assertTrue((boolean)trigger1.equals((Object)trigger2));
    }

    @Test
    public void testEquals3() {
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterName2 = "Nome do par\u00e2metro 2";
        DoubleParameter parameter1 = this.createMockDoubleParameter(parameterName1);
        DoubleParameter parameter2 = this.createMockDoubleParameter(parameterName2);
        Double minimum = 10.5;
        boolean isMinimumIncluded = true;
        SimpleCondition condition = new SimpleCondition("Nome do par\u00e2metro", (Object)"Valor");
        ChangeMinimumForDoublesTrigger trigger1 = new ChangeMinimumForDoublesTrigger(parameter1, (Condition)condition, minimum, isMinimumIncluded);
        ChangeMinimumForDoublesTrigger trigger2 = new ChangeMinimumForDoublesTrigger(parameter2, (Condition)condition, minimum, isMinimumIncluded);
        Assert.assertFalse((boolean)trigger1.equals((Object)trigger2));
    }

    @Test
    public void testEquals4() {
        String parameterName1 = "Nome do par\u00e2metro 1";
        String parameterName2 = "Nome do par\u00e2metro 2";
        DoubleListParameter parameter1 = this.createMockDoubleListParameter(parameterName1);
        DoubleListParameter parameter2 = this.createMockDoubleListParameter(parameterName2);
        Double minimum = 10.5;
        boolean isMinimumIncluded = true;
        SimpleCondition condition = new SimpleCondition("Nome do par\u00e2metro", (Object)"Valor");
        ChangeMinimumForDoublesTrigger trigger1 = new ChangeMinimumForDoublesTrigger(parameter1, (Condition)condition, minimum, isMinimumIncluded);
        ChangeMinimumForDoublesTrigger trigger2 = new ChangeMinimumForDoublesTrigger(parameter2, (Condition)condition, minimum, isMinimumIncluded);
        Assert.assertFalse((boolean)trigger1.equals((Object)trigger2));
    }

    @Test
    public void testEquals5() {
        String parameterName = "Nome do par\u00e2metro";
        DoubleParameter parameter = this.createMockDoubleParameter(parameterName);
        Double minimum1 = 11.1;
        Double minimum2 = 22.2;
        boolean isMinimumIncluded = true;
        SimpleCondition condition = new SimpleCondition("Nome do par\u00e2metro", (Object)"Valor");
        ChangeMinimumForDoublesTrigger trigger1 = new ChangeMinimumForDoublesTrigger(parameter, (Condition)condition, minimum1, isMinimumIncluded);
        ChangeMinimumForDoublesTrigger trigger2 = new ChangeMinimumForDoublesTrigger(parameter, (Condition)condition, minimum2, isMinimumIncluded);
        Assert.assertFalse((boolean)trigger1.equals((Object)trigger2));
    }

    @Test
    public void testEquals6() {
        String parameterName = "Nome do par\u00e2metro";
        DoubleListParameter parameter = this.createMockDoubleListParameter(parameterName);
        Double minimum1 = 11.1;
        Double minimum2 = 22.2;
        boolean isMinimumIncluded = true;
        SimpleCondition condition = new SimpleCondition("Nome do par\u00e2metro", (Object)"Valor");
        ChangeMinimumForDoublesTrigger trigger1 = new ChangeMinimumForDoublesTrigger(parameter, (Condition)condition, minimum1, isMinimumIncluded);
        ChangeMinimumForDoublesTrigger trigger2 = new ChangeMinimumForDoublesTrigger(parameter, (Condition)condition, minimum2, isMinimumIncluded);
        Assert.assertFalse((boolean)trigger1.equals((Object)trigger2));
    }

    @Test
    public void testEquals7() {
        String parameterName = "Nome do par\u00e2metro";
        DoubleParameter parameter = this.createMockDoubleParameter(parameterName);
        Double minimum = 10.5;
        boolean isMinimumIncluded1 = true;
        boolean isMinimumIncluded2 = false;
        SimpleCondition condition = new SimpleCondition("Nome do par\u00e2metro", (Object)"Valor");
        ChangeMinimumForDoublesTrigger trigger1 = new ChangeMinimumForDoublesTrigger(parameter, (Condition)condition, minimum, isMinimumIncluded1);
        ChangeMinimumForDoublesTrigger trigger2 = new ChangeMinimumForDoublesTrigger(parameter, (Condition)condition, minimum, isMinimumIncluded2);
        Assert.assertFalse((boolean)trigger1.equals((Object)trigger2));
    }

    @Test
    public void testEquals8() {
        String parameterName = "Nome do par\u00e2metro";
        DoubleListParameter parameter = this.createMockDoubleListParameter(parameterName);
        Double minimum = 10.5;
        boolean isMinimumIncluded1 = true;
        boolean isMinimumIncluded2 = false;
        SimpleCondition condition = new SimpleCondition("Nome do par\u00e2metro", (Object)"Valor");
        ChangeMinimumForDoublesTrigger trigger1 = new ChangeMinimumForDoublesTrigger(parameter, (Condition)condition, minimum, isMinimumIncluded1);
        ChangeMinimumForDoublesTrigger trigger2 = new ChangeMinimumForDoublesTrigger(parameter, (Condition)condition, minimum, isMinimumIncluded2);
        Assert.assertFalse((boolean)trigger1.equals((Object)trigger2));
    }

    @Test
    public void testEquals9() {
        String parameterName = "Nome do par\u00e2metro";
        DoubleListParameter parameter1 = this.createMockDoubleListParameter(parameterName);
        DoubleParameter parameter2 = this.createMockDoubleParameter(parameterName);
        Double minimum = 10.5;
        boolean isMinimumIncluded = true;
        SimpleCondition condition = new SimpleCondition("Nome do par\u00e2metro", (Object)"Valor");
        ChangeMinimumForDoublesTrigger trigger1 = new ChangeMinimumForDoublesTrigger(parameter1, (Condition)condition, minimum, isMinimumIncluded);
        ChangeMinimumForDoublesTrigger trigger2 = new ChangeMinimumForDoublesTrigger(parameter2, (Condition)condition, minimum, isMinimumIncluded);
        Assert.assertFalse((boolean)trigger1.equals((Object)trigger2));
    }

    @Test
    public void testEquals10() {
        String parameterName = "Nome do par\u00e2metro";
        DoubleParameter parameter = this.createMockDoubleParameter(parameterName);
        Double minimum = 10.5;
        boolean isMinimumIncluded = true;
        SimpleCondition condition = new SimpleCondition("Nome do par\u00e2metro", (Object)"Valor");
        ChangeMinimumForDoublesTrigger trigger = new ChangeMinimumForDoublesTrigger(parameter, (Condition)condition, minimum, isMinimumIncluded);
        Assert.assertFalse((boolean)trigger.equals(null));
    }

    @Test
    public void testEquals11() {
        String parameterName = "Nome do par\u00e2metro";
        DoubleParameter parameter = this.createMockDoubleParameter(parameterName);
        Double minimum = 10.5;
        boolean isMinimumIncluded = true;
        SimpleCondition condition = new SimpleCondition("Nome do par\u00e2metro", (Object)"Valor");
        ChangeMinimumForDoublesTrigger trigger = new ChangeMinimumForDoublesTrigger(parameter, (Condition)condition, minimum, isMinimumIncluded);
        Assert.assertFalse((boolean)trigger.equals((Object)"Outra classe"));
    }

    @Test
    public void testEquals12() {
        String parameterName = "Nome do par\u00e2metro";
        DoubleListParameter parameter = this.createMockDoubleListParameter(parameterName);
        Double minimum = 10.5;
        boolean isMinimumIncluded = true;
        SimpleCondition condition = new SimpleCondition("Nome do par\u00e2metro", (Object)"Valor");
        ChangeMinimumForDoublesTrigger trigger = new ChangeMinimumForDoublesTrigger(parameter, (Condition)condition, minimum, isMinimumIncluded);
        Assert.assertFalse((boolean)trigger.equals(null));
    }

    @Test
    public void testEquals13() {
        String parameterName = "Nome do par\u00e2metro";
        DoubleListParameter parameter = this.createMockDoubleListParameter(parameterName);
        Double minimum = 10.5;
        boolean isMinimumIncluded = true;
        SimpleCondition condition = new SimpleCondition("Nome do par\u00e2metro", (Object)"Valor");
        ChangeMinimumForDoublesTrigger trigger = new ChangeMinimumForDoublesTrigger(parameter, (Condition)condition, minimum, isMinimumIncluded);
        Assert.assertFalse((boolean)trigger.equals((Object)"Outra classe"));
    }

    private SimpleAlgorithmConfigurator createMockAlgorithmConfigurator() {
        AlgorithmInfo algorithmInfo = new AlgorithmInfo("ID Algoritmo", "Algoritmo", "DIR Algoritmo", "algorithms", new Hashtable());
        AlgorithmVersionId algorithmVersionId = new AlgorithmVersionId(1, 2, 3);
        AlgorithmVersionInfo algorithmVersionInfo = new AlgorithmVersionInfo(algorithmInfo, algorithmVersionId, new Hashtable(), new Hashtable());
        return new SimpleAlgorithmConfigurator(algorithmVersionInfo, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, "Comando", null, null, true, CMD_PATTERN);
    }

    private DoubleListParameter createMockDoubleListParameter() {
        String parameterName = "Nome do par\u00e2metro";
        return this.createMockDoubleListParameter(parameterName);
    }

    private DoubleListParameter createMockDoubleListParameter(String parameterName) {
        Double minimum = null;
        boolean isMinimumIncluded = false;
        return this.createMockDoubleListParameter(parameterName, minimum, isMinimumIncluded);
    }

    private DoubleListParameter createMockDoubleListParameter(String parameterName, Double minimum, boolean isMinimumIncluded) {
        return new DoubleListParameter(parameterName, "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", null, false, true, null, null, false, minimum, isMinimumIncluded);
    }

    private DoubleParameter createMockDoubleParameter() {
        String parameterName = "Nome do par\u00e2metro";
        return this.createMockDoubleParameter(parameterName);
    }

    private DoubleParameter createMockDoubleParameter(String parameterName) {
        Double defaultValue = null;
        Double minimum = null;
        boolean isMinimumIncluded = false;
        return this.createMockDoubleParameter(parameterName, defaultValue, minimum, isMinimumIncluded);
    }

    private DoubleParameter createMockDoubleParameter(String parameterName, Double defaultValue, Double minimum, boolean isMinimumIncluded) {
        return new DoubleParameter(parameterName, "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", defaultValue, false, true, null, null, false, minimum, isMinimumIncluded);
    }

    private Condition createMockCondition() {
        return new SimpleCondition("Nome do par\u00e2metro", (Object)"Valor qualquer");
    }
}

