/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters.triggers;

import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.AlgorithmVersionId;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import csbase.logic.algorithms.ExecutionLocation;
import csbase.logic.algorithms.ExecutionType;
import csbase.logic.algorithms.parameters.MockSimpleParameter;
import csbase.logic.algorithms.parameters.ParameterGroup;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.parameters.conditions.Condition;
import csbase.logic.algorithms.parameters.conditions.SimpleCondition;
import csbase.logic.algorithms.parameters.triggers.DisableParameterTrigger;
import java.util.Hashtable;
import org.junit.Assert;
import org.junit.Test;

public final class DisableParameterTriggerTest {
    private static final String CMD_PATTERN = "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO";

    @Test
    public void testDisableParameterTrigger1() {
        SimpleParameter<?> parameter = this.createMockParameter();
        Condition condition = this.createMockCondition();
        DisableParameterTrigger trigger = new DisableParameterTrigger(parameter, condition);
        Assert.assertEquals(parameter, (Object)trigger.getParameter());
        Assert.assertEquals((Object)condition, (Object)trigger.getCondition());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDisableParameterTrigger2() {
        Condition condition = this.createMockCondition();
        new DisableParameterTrigger(null, condition);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDisableParameterTrigger3() {
        SimpleParameter<?> parameter = this.createMockParameter();
        new DisableParameterTrigger(parameter, null);
    }

    @Test
    public void testDoAction1() {
        String parameterName = "Nome do par\u00e2metro";
        String defaultValue = "Valor-padr\u00e3o";
        SimpleParameter<?> parameter = this.createMockParameter(parameterName, defaultValue);
        Assert.assertEquals((Object)parameterName, (Object)parameter.getName());
        Assert.assertEquals((Object)defaultValue, (Object)parameter.getValue());
        Assert.assertTrue((boolean)parameter.isEnabled());
        SimpleCondition condition = new SimpleCondition(parameterName, (Object)defaultValue);
        ParameterGroup group = this.createMockParameterGroup();
        group.addParameter(parameter);
        SimpleAlgorithmConfigurator configurator = this.createMockAlgorithmConfigurator();
        configurator.addGroup(group);
        Assert.assertTrue((boolean)condition.evaluate(configurator));
        DisableParameterTrigger trigger = new DisableParameterTrigger(parameter, (Condition)condition);
        Assert.assertTrue((boolean)trigger.update(configurator));
        Assert.assertFalse((boolean)parameter.isEnabled());
    }

    @Test
    public void testDoAction2() {
        String parameterName = "Nome do par\u00e2metro";
        String defaultValue = "Valor-padr\u00e3o";
        SimpleParameter<?> parameter = this.createMockParameter(parameterName, defaultValue);
        parameter.setEnabled(false);
        Assert.assertEquals((Object)parameterName, (Object)parameter.getName());
        Assert.assertEquals((Object)defaultValue, (Object)parameter.getValue());
        Assert.assertFalse((boolean)parameter.isEnabled());
        SimpleCondition condition = new SimpleCondition(parameterName, null);
        ParameterGroup group = this.createMockParameterGroup();
        group.addParameter(parameter);
        SimpleAlgorithmConfigurator configurator = this.createMockAlgorithmConfigurator();
        configurator.addGroup(group);
        Assert.assertFalse((boolean)condition.evaluate(configurator));
        DisableParameterTrigger trigger = new DisableParameterTrigger(parameter, (Condition)condition);
        Assert.assertFalse((boolean)trigger.update(configurator));
        Assert.assertTrue((boolean)parameter.isEnabled());
    }

    @Test
    public void testEquals1() {
        String parameterName = "Nome do par\u00e2metro";
        SimpleParameter<?> parameter = this.createMockParameter(parameterName);
        SimpleCondition condition1 = new SimpleCondition("Nome do par\u00e2metro 1", (Object)"Valor 1");
        SimpleCondition condition2 = new SimpleCondition("Nome do par\u00e2metro 2", (Object)"Valor 2");
        DisableParameterTrigger trigger1 = new DisableParameterTrigger(parameter, (Condition)condition1);
        DisableParameterTrigger trigger2 = new DisableParameterTrigger(parameter, (Condition)condition2);
        Assert.assertTrue((boolean)trigger1.equals((Object)trigger2));
    }

    @Test
    public void testEquals2() {
        String parameterName1 = "Nome do par\u00e2metro 1";
        SimpleParameter<?> parameter1 = this.createMockParameter(parameterName1);
        String parameterName2 = "Nome do par\u00e2metro 2";
        SimpleParameter<?> parameter2 = this.createMockParameter(parameterName2);
        SimpleCondition condition = new SimpleCondition("Nome do par\u00e2metro", (Object)"Valor");
        DisableParameterTrigger trigger1 = new DisableParameterTrigger(parameter1, (Condition)condition);
        DisableParameterTrigger trigger2 = new DisableParameterTrigger(parameter2, (Condition)condition);
        Assert.assertFalse((boolean)trigger1.equals((Object)trigger2));
    }

    @Test
    public void testEquals3() {
        SimpleParameter<?> parameter = this.createMockParameter();
        Condition condition = this.createMockCondition();
        DisableParameterTrigger trigger = new DisableParameterTrigger(parameter, condition);
        Assert.assertFalse((boolean)trigger.equals(null));
    }

    @Test
    public void testEquals4() {
        SimpleParameter<?> parameter = this.createMockParameter();
        Condition condition = this.createMockCondition();
        DisableParameterTrigger trigger = new DisableParameterTrigger(parameter, condition);
        Assert.assertFalse((boolean)trigger.equals((Object)"Outra classe"));
    }

    private SimpleAlgorithmConfigurator createMockAlgorithmConfigurator() {
        AlgorithmInfo algorithmInfo = new AlgorithmInfo("ID Algoritmo", "Algoritmo", "DIR Algoritmo", "algorithms", new Hashtable());
        AlgorithmVersionId algorithmVersionId = new AlgorithmVersionId(1, 2, 3);
        AlgorithmVersionInfo algorithmVersionInfo = new AlgorithmVersionInfo(algorithmInfo, algorithmVersionId, new Hashtable(), new Hashtable());
        return new SimpleAlgorithmConfigurator(algorithmVersionInfo, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, "Comando", null, null, true, CMD_PATTERN);
    }

    private Condition createMockCondition() {
        return new SimpleCondition("Nome do par\u00e2metro", (Object)"Valor qualquer");
    }

    private SimpleParameter<?> createMockParameter() {
        String parameterName = "Nome do par\u00e2metro";
        return this.createMockParameter(parameterName);
    }

    private SimpleParameter<?> createMockParameter(String parameterName) {
        String defaultValue = "Valor-padr\u00e3o do par\u00e2metro";
        return this.createMockParameter(parameterName, defaultValue);
    }

    private SimpleParameter<?> createMockParameter(String parameterName, Object defaultValue) {
        return new MockSimpleParameter(parameterName, "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", defaultValue, false, true, null);
    }

    private ParameterGroup createMockParameterGroup() {
        return new ParameterGroup("Grupo de par\u00e2metros");
    }
}

