/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters.triggers;

import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.AlgorithmVersionId;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import csbase.logic.algorithms.ExecutionLocation;
import csbase.logic.algorithms.ExecutionType;
import csbase.logic.algorithms.parameters.MockSimpleParameter;
import csbase.logic.algorithms.parameters.ParameterGroup;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.parameters.conditions.Condition;
import csbase.logic.algorithms.parameters.conditions.SimpleCondition;
import csbase.logic.algorithms.parameters.triggers.HideGroupTrigger;
import java.util.Hashtable;
import org.junit.Assert;
import org.junit.Test;

public final class HideGroupTriggerTest {
    private static final String CMD_PATTERN = "$NOME_DO_PARAMETRO=$VALOR_DO_PARAMETRO";

    @Test
    public void testHideGroupTriggerWithValidCondition() {
        ParameterGroup group = this.createMockParameterGroup();
        Condition condition = this.createMockCondition();
        HideGroupTrigger trigger = new HideGroupTrigger(group, condition);
        Assert.assertEquals((Object)group, (Object)trigger.getParameter());
        Assert.assertEquals((Object)condition, (Object)trigger.getCondition());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testHideGroupTriggerWithNoGroup() {
        Condition condition = this.createMockCondition();
        new HideGroupTrigger(null, condition);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testHideGroupTriggerWithNoCondition() {
        ParameterGroup group = this.createMockParameterGroup();
        new HideGroupTrigger(group, null);
    }

    @Test
    public void testDoActionWithNoId() {
        String groupName = "grupo";
        ParameterGroup group = this.createMockParameterGroup(groupName);
        String parameterName = "Nome do par\u00e2metro";
        String defaultValue = "Valor-padr\u00e3o";
        SimpleParameter<?> parameter = this.createMockParameter(parameterName, defaultValue);
        SimpleCondition condition = new SimpleCondition(parameterName, (Object)defaultValue);
        group.addParameter(parameter);
        Assert.assertEquals((Object)groupName, (Object)group.getLabel());
        Assert.assertEquals((Object)groupName, (Object)group.getName());
        Assert.assertTrue((boolean)group.isVisible());
        Assert.assertTrue((boolean)parameter.isVisible());
        SimpleAlgorithmConfigurator configurator = this.createMockAlgorithmConfigurator();
        configurator.addGroup(group);
        Assert.assertTrue((boolean)condition.evaluate(configurator));
        HideGroupTrigger trigger = new HideGroupTrigger(group, (Condition)condition);
        Assert.assertTrue((boolean)trigger.update(configurator));
        Assert.assertFalse((boolean)group.isVisible());
        Assert.assertFalse((boolean)parameter.isVisible());
    }

    @Test
    public void testDoActionWithTrueCondition() {
        String groupName = "grupo";
        String groupId = "id_grupo";
        ParameterGroup group = this.createMockParameterGroup(groupName, groupId);
        String parameterName = "Nome do par\u00e2metro";
        String defaultValue = "Valor-padr\u00e3o";
        SimpleParameter<?> parameter = this.createMockParameter(parameterName, defaultValue);
        SimpleCondition condition = new SimpleCondition(parameterName, (Object)defaultValue);
        group.addParameter(parameter);
        Assert.assertEquals((Object)groupName, (Object)group.getLabel());
        Assert.assertEquals((Object)groupId, (Object)group.getName());
        Assert.assertTrue((boolean)group.isVisible());
        Assert.assertTrue((boolean)parameter.isVisible());
        SimpleAlgorithmConfigurator configurator = this.createMockAlgorithmConfigurator();
        configurator.addGroup(group);
        Assert.assertTrue((boolean)condition.evaluate(configurator));
        HideGroupTrigger trigger = new HideGroupTrigger(group, (Condition)condition);
        Assert.assertTrue((boolean)trigger.update(configurator));
        Assert.assertFalse((boolean)group.isVisible());
        Assert.assertFalse((boolean)parameter.isVisible());
    }

    @Test
    public void testDoActionWithFalseCondition() {
        String groupName = "grupo";
        String groupId = "id_grupo";
        ParameterGroup group = this.createMockParameterGroup(groupName, groupId);
        String parameterName = "Nome do par\u00e2metro";
        String defaultValue = "Valor-padr\u00e3o";
        SimpleParameter<?> parameter = this.createMockParameter(parameterName, defaultValue);
        SimpleCondition condition = new SimpleCondition(parameterName, null);
        group.addParameter(parameter);
        group.setVisible(false);
        Assert.assertEquals((Object)groupName, (Object)group.getLabel());
        Assert.assertEquals((Object)groupId, (Object)group.getName());
        Assert.assertFalse((boolean)group.isVisible());
        Assert.assertFalse((boolean)parameter.isVisible());
        SimpleAlgorithmConfigurator configurator = this.createMockAlgorithmConfigurator();
        configurator.addGroup(group);
        Assert.assertFalse((boolean)condition.evaluate(configurator));
        HideGroupTrigger trigger = new HideGroupTrigger(group, (Condition)condition);
        Assert.assertFalse((boolean)trigger.update(configurator));
        Assert.assertTrue((boolean)group.isVisible());
        Assert.assertTrue((boolean)parameter.isVisible());
    }

    @Test
    public void testEqualsWithSimilarTriggers() {
        ParameterGroup group = this.createMockParameterGroup();
        SimpleCondition condition1 = new SimpleCondition("Nome do par\u00e2metro 1", (Object)"Valor 1");
        SimpleCondition condition2 = new SimpleCondition("Nome do par\u00e2metro 2", (Object)"Valor 2");
        HideGroupTrigger trigger1 = new HideGroupTrigger(group, (Condition)condition1);
        HideGroupTrigger trigger2 = new HideGroupTrigger(group, (Condition)condition2);
        Assert.assertTrue((boolean)trigger1.equals((Object)trigger2));
    }

    @Test
    public void testEqualsWithDifferentTriggers() {
        String groupName1 = "Nome do grupo 1";
        String groupName2 = "Nome do grupo 2";
        ParameterGroup group1 = this.createMockParameterGroup(groupName1);
        ParameterGroup group2 = this.createMockParameterGroup(groupName2);
        Condition condition = this.createMockCondition();
        HideGroupTrigger trigger1 = new HideGroupTrigger(group1, condition);
        HideGroupTrigger trigger2 = new HideGroupTrigger(group2, condition);
        Assert.assertFalse((boolean)trigger1.equals((Object)trigger2));
    }

    @Test
    public void testEqualsWithNullTrigger() {
        ParameterGroup group = this.createMockParameterGroup();
        Condition condition = this.createMockCondition();
        HideGroupTrigger trigger = new HideGroupTrigger(group, condition);
        Assert.assertFalse((boolean)trigger.equals(null));
    }

    @Test
    public void testEqualsWithNonTriggerObject() {
        ParameterGroup group = this.createMockParameterGroup();
        Condition condition = this.createMockCondition();
        HideGroupTrigger trigger = new HideGroupTrigger(group, condition);
        Assert.assertFalse((boolean)trigger.equals((Object)"Outra classe"));
    }

    private SimpleAlgorithmConfigurator createMockAlgorithmConfigurator() {
        AlgorithmInfo algorithmInfo = new AlgorithmInfo("ID Algoritmo", "Algoritmo", "DIR Algoritmo", "algorithms", new Hashtable());
        AlgorithmVersionId algorithmVersionId = new AlgorithmVersionId(1, 2, 3);
        AlgorithmVersionInfo algorithmVersionInfo = new AlgorithmVersionInfo(algorithmInfo, algorithmVersionId, new Hashtable(), new Hashtable());
        return new SimpleAlgorithmConfigurator(algorithmVersionInfo, null, ExecutionType.SIMPLE, ExecutionLocation.BINARY_DIR, null, false, "Comando", null, null, true, CMD_PATTERN);
    }

    private Condition createMockCondition() {
        return new SimpleCondition("Nome do par\u00e2metro", (Object)"Valor qualquer");
    }

    private SimpleParameter<?> createMockParameter(String parameterName, Object defaultValue) {
        return new MockSimpleParameter(parameterName, "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", defaultValue, false, true, null);
    }

    private ParameterGroup createMockParameterGroup() {
        return new ParameterGroup("Grupo de par\u00e2metros");
    }

    private ParameterGroup createMockParameterGroup(String groupName) {
        return new ParameterGroup(groupName);
    }

    private ParameterGroup createMockParameterGroup(String groupName, String groupId) {
        return new ParameterGroup(groupId, groupName, false);
    }
}

