/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters.validators;

import csbase.logic.algorithms.parameters.DoubleParameter;
import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.parameters.validators.DoubleParameterValidator;
import csbase.logic.algorithms.validation.Validation;
import java.rmi.RemoteException;
import java.util.Locale;
import org.junit.Assert;
import org.junit.Test;
import tecgraf.javautils.core.lng.LNG;

public final class DoubleParameterValidatorTest {
    @Test
    public void testDoubleParameterValidatorWithOptionalTrue() {
        boolean isOptional = true;
        Double maximum = new Double(5.5);
        boolean isMaximumIncluded = true;
        Double minimum = new Double(1.1);
        boolean isMinimumIncluded = true;
        DoubleParameterValidator validator = new DoubleParameterValidator(isOptional, maximum, isMaximumIncluded, minimum, isMinimumIncluded);
        Assert.assertEquals((Object)isOptional, (Object)validator.isOptional());
        Assert.assertEquals((Object)maximum, (Object)validator.getMaximum());
        Assert.assertEquals((Object)isMaximumIncluded, (Object)validator.isMaximumIncluded());
        Assert.assertEquals((Object)minimum, (Object)validator.getMinimum());
        Assert.assertEquals((Object)isMinimumIncluded, (Object)validator.isMinimumIncluded());
    }

    @Test
    public void testDoubleParameterValidatorWithOptionalFalse() {
        boolean isOptional = false;
        Double maximum = new Double(5.5);
        boolean isMaximumIncluded = true;
        Double minimum = new Double(1.1);
        boolean isMinimumIncluded = true;
        DoubleParameterValidator validator = new DoubleParameterValidator(isOptional, maximum, isMaximumIncluded, minimum, isMinimumIncluded);
        Assert.assertEquals((Object)isOptional, (Object)validator.isOptional());
        Assert.assertEquals((Object)maximum, (Object)validator.getMaximum());
        Assert.assertEquals((Object)isMaximumIncluded, (Object)validator.isMaximumIncluded());
        Assert.assertEquals((Object)minimum, (Object)validator.getMinimum());
        Assert.assertEquals((Object)isMinimumIncluded, (Object)validator.isMinimumIncluded());
    }

    @Test
    public void testDoubleParameterValidatorWithNullMaximum() {
        boolean isOptional = true;
        boolean isMaximumIncluded = true;
        Double minimum = new Double(1.1);
        boolean isMinimumIncluded = true;
        DoubleParameterValidator validator = new DoubleParameterValidator(isOptional, null, isMaximumIncluded, minimum, isMinimumIncluded);
        Assert.assertEquals((Object)isOptional, (Object)validator.isOptional());
        Assert.assertNull((Object)validator.getMaximum());
        Assert.assertFalse((boolean)validator.isMaximumIncluded());
        Assert.assertEquals((Object)minimum, (Object)validator.getMinimum());
        Assert.assertEquals((Object)isMinimumIncluded, (Object)validator.isMinimumIncluded());
    }

    @Test
    public void testDoubleParameterValidatorWithNullMinimum() {
        boolean isOptional = true;
        Double maximum = new Double(5.5);
        boolean isMaximumIncluded = true;
        boolean isMinimumIncluded = true;
        DoubleParameterValidator validator = new DoubleParameterValidator(isOptional, maximum, isMaximumIncluded, null, isMinimumIncluded);
        Assert.assertEquals((Object)isOptional, (Object)validator.isOptional());
        Assert.assertEquals((Object)maximum, (Object)validator.getMaximum());
        Assert.assertEquals((Object)isMaximumIncluded, (Object)validator.isMaximumIncluded());
        Assert.assertNull((Object)validator.getMinimum());
        Assert.assertFalse((boolean)validator.isMinimumIncluded());
    }

    @Test
    public void testDoubleParameterValidatorWithIsMaximumIncludedFalse() {
        boolean isOptional = true;
        Double maximum = new Double(5.5);
        boolean isMaximumIncluded = false;
        Double minimum = new Double(1.1);
        boolean isMinimumIncluded = true;
        DoubleParameterValidator validator = new DoubleParameterValidator(isOptional, maximum, isMaximumIncluded, minimum, isMinimumIncluded);
        Assert.assertEquals((Object)isOptional, (Object)validator.isOptional());
        Assert.assertEquals((Object)maximum, (Object)validator.getMaximum());
        Assert.assertEquals((Object)isMaximumIncluded, (Object)validator.isMaximumIncluded());
        Assert.assertEquals((Object)minimum, (Object)validator.getMinimum());
        Assert.assertEquals((Object)isMinimumIncluded, (Object)validator.isMinimumIncluded());
    }

    @Test
    public void testDoubleParameterValidatorWithIsMinimumIncludedFalse() {
        boolean isOptional = true;
        Double maximum = new Double(5.5);
        boolean isMaximumIncluded = true;
        Double minimum = new Double(1.1);
        boolean isMinimumIncluded = false;
        DoubleParameterValidator validator = new DoubleParameterValidator(isOptional, maximum, isMaximumIncluded, minimum, isMinimumIncluded);
        Assert.assertEquals((Object)isOptional, (Object)validator.isOptional());
        Assert.assertEquals((Object)maximum, (Object)validator.getMaximum());
        Assert.assertEquals((Object)isMaximumIncluded, (Object)validator.isMaximumIncluded());
        Assert.assertEquals((Object)minimum, (Object)validator.getMinimum());
        Assert.assertEquals((Object)isMinimumIncluded, (Object)validator.isMinimumIncluded());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDoubleParameterValidatorWithMinimumLargerThanMaximum() {
        boolean isOptional = true;
        Double maximum = new Double(5.5);
        boolean isMaximumIncluded = true;
        Double minimum = new Double(11.11);
        boolean isMinimumIncluded = true;
        new DoubleParameterValidator(isOptional, maximum, isMaximumIncluded, minimum, isMinimumIncluded);
    }

    @Test
    public void testValidateValueWithTrueIsOptionalAndNullValue() throws RemoteException {
        boolean isOptional = true;
        DoubleParameterValidator validator = new DoubleParameterValidator(isOptional, null, false, null, false);
        DoubleParameter parameter = new DoubleParameter("Nome do par\u00e2metro", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", null, isOptional, true, "{0} {1}", null, false, null, false);
        Validation result = validator.validateValue((SimpleParameter)parameter, null, null);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.isWellSucceded());
    }

    @Test
    public void testValidateValueWithFalseIsOptionalAndNullValue() throws RemoteException {
        boolean isOptional = false;
        DoubleParameterValidator validator = new DoubleParameterValidator(isOptional, null, false, null, false);
        DoubleParameter parameter = new DoubleParameter("Nome do par\u00e2metro", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", null, isOptional, true, "{0} {1}", null, false, null, false);
        Validation result = validator.validateValue((SimpleParameter)parameter, null, null);
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.isWellSucceded());
        Assert.assertNotNull((Object)result.getMessage());
    }

    @Test
    public void testValidateValueWithValueEqualsMaximumWithTrueIsMaximumIncluded() throws RemoteException {
        boolean isMaximumIncluded = true;
        Double maximum = new Double(10.0);
        DoubleParameterValidator validator = new DoubleParameterValidator(false, maximum, isMaximumIncluded, null, false);
        DoubleParameter parameter = new DoubleParameter("Nome do par\u00e2metro", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", null, false, true, "{0} {1}", maximum, isMaximumIncluded, null, false);
        Validation result = validator.validateValue((SimpleParameter)parameter, maximum, null);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.isWellSucceded());
    }

    @Test
    public void testValidateValueWithValueEqualsMaximumWithFalseIsMaximumIncluded() throws RemoteException {
        boolean isMaximumIncluded = false;
        Double maximum = new Double(10.0);
        DoubleParameterValidator validator = new DoubleParameterValidator(false, maximum, isMaximumIncluded, null, false);
        DoubleParameter parameter = new DoubleParameter("Nome do par\u00e2metro", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", null, false, true, "{0} {1}", maximum, isMaximumIncluded, null, false);
        Validation result = validator.validateValue((SimpleParameter)parameter, maximum, null);
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.isWellSucceded());
        Assert.assertNotNull((Object)result.getMessage());
    }

    @Test
    public void testValidateValueWithValueEqualsMinimumWithTrueIsMinimumIncluded() throws RemoteException {
        boolean isMinimumIncluded = true;
        Double minimum = new Double(10.0);
        DoubleParameterValidator validator = new DoubleParameterValidator(false, null, false, minimum, isMinimumIncluded);
        DoubleParameter parameter = new DoubleParameter("Nome do par\u00e2metro", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", null, false, true, "{0} {1}", null, false, minimum, isMinimumIncluded);
        Validation result = validator.validateValue((SimpleParameter)parameter, minimum, null);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.isWellSucceded());
    }

    @Test
    public void testValidateValueWithValueEqualsMinimumWithFalseIsMinimumIncluded() throws RemoteException {
        boolean isMinimumIncluded = false;
        Double minimum = new Double(10.0);
        DoubleParameterValidator validator = new DoubleParameterValidator(false, null, false, minimum, isMinimumIncluded);
        DoubleParameter parameter = new DoubleParameter("Nome do par\u00e2metro", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", null, false, true, "{0} {1}", null, false, minimum, isMinimumIncluded);
        Validation result = validator.validateValue((SimpleParameter)parameter, minimum, null);
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.isWellSucceded());
        Assert.assertNotNull((Object)result.getMessage());
    }

    @Test
    public void testValidateValueWithValueLargerThanMaximum() throws RemoteException {
        boolean isMaximumIncluded = true;
        Double maximum = new Double(10.0);
        DoubleParameterValidator validator = new DoubleParameterValidator(false, maximum, isMaximumIncluded, null, false);
        DoubleParameter parameter = new DoubleParameter("Nome do par\u00e2metro", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", null, false, true, "{0} {1}", maximum, isMaximumIncluded, null, false);
        Validation result = validator.validateValue((SimpleParameter)parameter, new Double(maximum + 0.1), null);
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.isWellSucceded());
        Assert.assertNotNull((Object)result.getMessage());
    }

    @Test
    public void testValidateValueWithValueLesserThanMinimum() throws RemoteException {
        boolean isMinimumIncluded = true;
        Double minimum = new Double(10.0);
        DoubleParameterValidator validator = new DoubleParameterValidator(false, null, false, minimum, isMinimumIncluded);
        DoubleParameter parameter = new DoubleParameter("Nome do par\u00e2metro", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", null, false, true, "{0} {1}", null, false, minimum, isMinimumIncluded);
        Validation result = validator.validateValue((SimpleParameter)parameter, new Double(minimum - 1.0), null);
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.isWellSucceded());
        Assert.assertNotNull((Object)result.getMessage());
    }

    @Test
    public void testGetErrorMessage() throws RemoteException {
        boolean isMinimumIncluded = true;
        Double minimum = new Double(10.0);
        DoubleParameterValidator validator = new DoubleParameterValidator(false, null, false, minimum, isMinimumIncluded);
        DoubleParameter parameter = new DoubleParameter("Nome do par\u00e2metro", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", null, false, true, "{0} {1}", null, false, minimum, isMinimumIncluded);
        Validation result = validator.validateValue((SimpleParameter)parameter, new Double(minimum - 1.0), null);
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.isWellSucceded());
        Assert.assertNotNull((Object)result.getMessage());
    }

    static {
        LNG.load((String)"csbase.client.resources.properties.language.idiom", (Locale)new Locale("pt", "BR"));
    }
}

