/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters.validators;

import csbase.logic.algorithms.parameters.MockSimpleParameter;
import csbase.logic.algorithms.parameters.validators.MockParameterValidator;
import java.rmi.RemoteException;
import java.util.Locale;
import org.junit.Assert;
import org.junit.Test;
import tecgraf.javautils.core.lng.LNG;

public final class SimpleParameterValidatorTest {
    @Test
    public void testSimpleParameterValidatorWithOptionalValue() {
        boolean isOptional = true;
        MockParameterValidator validator = new MockParameterValidator(isOptional);
        Assert.assertEquals((Object)isOptional, (Object)validator.isOptional());
    }

    @Test
    public void testSimpleParameterValidatorWithNonOptionalValue() {
        boolean isOptional = false;
        MockParameterValidator validator = new MockParameterValidator(isOptional);
        Assert.assertEquals((Object)isOptional, (Object)validator.isOptional());
    }

    @Test
    public void testValidateValueWithNullOptionalValue() throws RemoteException {
        boolean isOptional = true;
        MockParameterValidator validator = new MockParameterValidator(isOptional);
        Assert.assertEquals((Object)isOptional, (Object)validator.isOptional());
        MockSimpleParameter parameter = new MockSimpleParameter("Nome do par\u00e2metro", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", null, isOptional, true, "{0}{1}");
        Assert.assertNotNull((Object)validator.validateValue(parameter, null, null));
        Assert.assertTrue((boolean)validator.validateValue(parameter, null, null).isWellSucceded());
    }

    @Test
    public void testValidateValueWithNullNonOptionalValue() throws RemoteException {
        boolean isOptional = false;
        MockParameterValidator validator = new MockParameterValidator(isOptional);
        Assert.assertEquals((Object)isOptional, (Object)validator.isOptional());
        MockSimpleParameter parameter = new MockSimpleParameter("Nome do par\u00e2metro", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", null, isOptional, true, "{0}{1}");
        Assert.assertNotNull((Object)validator.validateValue(parameter, null, null));
        Assert.assertFalse((boolean)validator.validateValue(parameter, null, null).isWellSucceded());
    }

    @Test
    public void testValidateValueWithValidOptionalValue() throws RemoteException {
        boolean isOptional = true;
        MockParameterValidator validator = new MockParameterValidator(isOptional);
        Assert.assertEquals((Object)isOptional, (Object)validator.isOptional());
        MockSimpleParameter parameter = new MockSimpleParameter("Nome do par\u00e2metro", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", null, isOptional, true, "{0}{1}");
        Assert.assertNotNull((Object)validator.validateValue(parameter, "Algum valor", null));
        Assert.assertTrue((boolean)validator.validateValue(parameter, "Algum valor", null).isWellSucceded());
    }

    @Test
    public void testValidateValueWithValidlNonOptionalValue() throws RemoteException {
        boolean isOptional = false;
        MockParameterValidator validator = new MockParameterValidator(isOptional);
        Assert.assertEquals((Object)isOptional, (Object)validator.isOptional());
        MockSimpleParameter parameter = new MockSimpleParameter("Nome do par\u00e2metro", "R\u00f3tulo do par\u00e2metro", "Descri\u00e7\u00e3o do par\u00e2metro", null, isOptional, true, "{0}{1}");
        Assert.assertNotNull((Object)validator.validateValue(parameter, "Algum valor", null));
        Assert.assertTrue((boolean)validator.validateValue(parameter, "Algum valor", null).isWellSucceded());
    }

    static {
        LNG.load((String)"csbase.client.resources.properties.language.idiom", (Locale)new Locale("pt", "BR"));
    }
}

