package csbase.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.io.InputStream;

import java.util.Hashtable;
import java.util.Enumeration;
import java.util.Properties;

/**
 * Programa usado para migrar a base de permisses quando houver alteraro
 * no pacote ou no nome da classe.
 * @author Jorge Alexandre e Glucio
 */
public class PermissionRefactor {

  private ObjectInputStream ois;
  private ObjectOutputStream oos;
  private final String CLASS = "class";


  public PermissionRefactor(String propertiesFilePath, 
                            String permissionFilePath) throws Exception {
    FileInputStream permission = new FileInputStream(permissionFilePath);
    ois = new ObjectInputStream(permission);
    Hashtable permHash = (Hashtable)ois.readObject();
    ois.close();
    Properties properties = loadProperties(propertiesFilePath);
    
    Enumeration keys = permHash.keys();
    boolean hasChanged = false;
    while (keys.hasMoreElements()) {
      Object id = keys.nextElement();
      Hashtable permissionHash = (Hashtable)permHash.get(id);
      System.out.println("Valores da chave: " + id);

      String className = (String)permissionHash.get(CLASS);
      String name = (String)permissionHash.get("name");

      System.out.println("Nome da classe: " + className + "\n" +
                         "Nome: " + name + "\n" );
      /* obtem a propriedade referente a classe */
      String newValue = properties.getProperty(className, className);

      if (!newValue.equals(className)) {
        /* sobrescreve a hash com a classe */
        permissionHash.put(CLASS, newValue);

        /* sobrescreve a hash do arquivo com a hash de permissoes */
        permHash.put(id, permissionHash);
        hasChanged = true;
      }
    }

    if (hasChanged) {
      /* escreve a permissao no arquivo */
      FileOutputStream newPermission = new FileOutputStream(
        permissionFilePath+"_NEW");
      oos = new ObjectOutputStream(newPermission);

      oos.writeObject(permHash);
      oos.close();
    } else {
      System.out.println("Nenhuma permisso foi migrada");
      System.exit(1);
    }
    
  }


  private Properties loadProperties(String propertiesFilePath) 
  throws Exception {
    InputStream input = new FileInputStream(propertiesFilePath);
    Properties prop = new Properties();
    prop.load(input);
    return prop;
  }

 /**
  * Mtodo principal da classe que receber dois parmetros: o primeiro  o
  * arquivo de propriedades com o mapeamento das classes e o segundo  o
  * arquivos de dados que ser migrado, que no caso de permisses ser o
  * permission.dat . O resultado da execuo desse programa ser um arquivo
  * com o mesmo nome do arquivo de dados de permisses
  * concatenado com "_NEW".
  */
  public static void main(String[] args) {
    if (args.length != 2) {
      System.out.println("uso:");
      System.out.print("java -cp <classpath> ");
      System.out.print("csbase.tools.PermissionRefactor ");
      System.out.print("<caminho do arquivo de properties> ");
      System.out.println("<caminho do arquivo permisses> ");
      System.exit(1);
    }
    try {
      new PermissionRefactor(args[0], args[1]);
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

}
