/*
 * Decompiled with CFR 0.152.
 */
package csbase.tools;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class PermissionRefactor {
    private ObjectInputStream ois;
    private ObjectOutputStream oos;
    private final String CLASS = "class";

    public PermissionRefactor(String propertiesFilePath, String permissionFilePath) throws Exception {
        FileInputStream permission = new FileInputStream(permissionFilePath);
        this.ois = new ObjectInputStream(permission);
        Hashtable permHash = (Hashtable)this.ois.readObject();
        this.ois.close();
        Properties properties = this.loadProperties(propertiesFilePath);
        Enumeration keys = permHash.keys();
        boolean hasChanged = false;
        while (keys.hasMoreElements()) {
            Object id = keys.nextElement();
            Hashtable permissionHash = (Hashtable)permHash.get(id);
            System.out.println("Valores da chave: " + id);
            String className = (String)permissionHash.get("class");
            String name = (String)permissionHash.get("name");
            System.out.println("Nome da classe: " + className + "\nNome: " + name + "\n");
            String newValue = properties.getProperty(className, className);
            if (newValue.equals(className)) continue;
            permissionHash.put("class", newValue);
            permHash.put(id, permissionHash);
            hasChanged = true;
        }
        if (hasChanged) {
            FileOutputStream newPermission = new FileOutputStream(permissionFilePath + "_NEW");
            this.oos = new ObjectOutputStream(newPermission);
            this.oos.writeObject(permHash);
            this.oos.close();
        } else {
            System.out.println("Nenhuma permiss\u00e3o foi migrada");
            System.exit(1);
        }
    }

    private Properties loadProperties(String propertiesFilePath) throws Exception {
        FileInputStream input = new FileInputStream(propertiesFilePath);
        Properties prop = new Properties();
        prop.load(input);
        return prop;
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("uso:");
            System.out.print("java -cp <classpath> ");
            System.out.print("csbase.tools.PermissionRefactor ");
            System.out.print("<caminho do arquivo de properties> ");
            System.out.println("<caminho do arquivo permiss\u00f5es> ");
            System.exit(1);
        }
        try {
            new PermissionRefactor(args[0], args[1]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

