/*
 * Decompiled with CFR 0.152.
 */
package csbase.util.restart;

import csbase.util.restart.RestartListener;
import java.util.LinkedList;
import java.util.List;

public final class RestartManager {
    private static RestartManager instance;
    private final List<RestartListener> restartListenerList = new LinkedList<RestartListener>();

    public static RestartManager getInstance() {
        if (instance == null) {
            instance = new RestartManager();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(RestartListener restartListener) {
        List<RestartListener> list = this.restartListenerList;
        synchronized (list) {
            this.restartListenerList.add(restartListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restart() {
        List<RestartListener> list = this.restartListenerList;
        synchronized (list) {
            for (RestartListener restartListener : this.restartListenerList) {
                try {
                    restartListener.restart();
                }
                catch (Exception e) {
                    String name = restartListener.getClass().getName();
                    String err = "Erro ao reiniciar a classe " + name;
                    System.err.println(err);
                    e.printStackTrace();
                }
            }
        }
    }

    private RestartManager() {
    }
}

