/*
 * Decompiled with CFR 0.152.
 */
package csbase.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipUtils {
    private static final int BUFFER_SIZE = 65536;

    public static byte[] zipFiles(File ... files) throws IOException {
        if (null == files || 0 == files.length) {
            return new byte[0];
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ZipOutputStream zip = new ZipOutputStream(out);
        zip.setMethod(8);
        for (File file : files) {
            ZipUtils.addFile(zip, file, 0);
        }
        zip.flush();
        out.flush();
        zip.close();
        byte[] data = out.toByteArray();
        out.close();
        return data;
    }

    public static void addFile(ZipOutputStream zip, File file, int level) throws IOException {
        if (file.isDirectory()) {
            if (0 == file.list().length) {
                String string = ZipUtils.getFilePath(file, level);
                ZipEntry entry = new ZipEntry(string);
                zip.putNextEntry(entry);
                zip.closeEntry();
            } else {
                for (File child : file.listFiles()) {
                    ZipUtils.addFile(zip, child, level + 1);
                }
                String string = ZipUtils.getFilePath(file, level);
                ZipEntry entry = new ZipEntry(string);
                zip.putNextEntry(entry);
                zip.closeEntry();
            }
        } else {
            String string = ZipUtils.getFilePath(file, level);
            ZipEntry entry = new ZipEntry(string);
            entry.setSize(file.length());
            zip.putNextEntry(entry);
            byte[] buffer = new byte[65536];
            FileInputStream fis = new FileInputStream(file);
            BufferedInputStream bis = new BufferedInputStream(fis, buffer.length);
            int bytesLidos = 0;
            while ((bytesLidos = bis.read(buffer, 0, buffer.length)) != -1) {
                zip.write(buffer, 0, bytesLidos);
            }
            zip.closeEntry();
            bis.close();
            fis.close();
        }
    }

    private static String getFilePath(File file, int level) {
        File[] parents = new File[level];
        File parent = file.getParentFile();
        for (int inx = parents.length - 1; inx >= 0 && null != parent; parent = parent.getParentFile(), --inx) {
            parents[inx] = parent;
        }
        StringBuffer filePath = new StringBuffer();
        for (File aParent : parents) {
            if (null == aParent) break;
            filePath.append(aParent.getName()).append("/");
        }
        filePath.append(file.getName());
        if (file.isDirectory() && !file.getName().endsWith("/")) {
            filePath.append("/");
        }
        return filePath.toString();
    }
}

