-------------------------------------------------------------------------
-- $Author$
-- $Revision$  - $Date$
-------------------------------------------------------------------------

require "scheduler"
require "oil"
local verbose = require "sga.verbose"

function main()
  SGA_DAEMON:loadBasicConfiguration()
  SGA_DAEMON:doPresentation()

  local status, error_msg = SGA_DAEMON:initServer()
  if not status then
     verbose.init( "Erro ao iniciar o SGA.\n\t\t\t"..error_msg )
     os.exit(0)
  end
  SGA_DAEMON:register()
  if CSFS.launch_daemon == YES and CSFS.process == nil then
    SGA_DAEMON:createCSFSProcess()
  end  
  if SGAD_CONF.net_benchmark == YES and IPERF.process == nil then
    SGA_DAEMON:createIPerfProcess()
  end  
  SGA_DAEMON:startServer()
end

-------------------------------------------------------------------------

scheduler.new(main)
scheduler.new(oil.run)
scheduler.run()
