/*
 * Decompiled with CFR 0.152.
 */
package csfs.datatransfer.blockingnio;

import csfs.datatransfer.DataTransferMethod;
import csfs.impl.util.SystemProperties;
import csfs.impl.util.Util;
import csfs.remote.InvalidStateException;
import csfs.remote.NotFileException;
import csfs.remote.RemoteFile;
import csfs.remote.ServerException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.SocketChannel;

public class BlockingNIOMethod
implements DataTransferMethod {
    @Override
    public boolean copy(File localFile, RemoteFile destination, String method) throws NotFileException, InvalidStateException, IOException, ServerException {
        boolean response = false;
        if (destination.isDirectory()) {
            throw new NotFileException(destination.getFullName());
        }
        String buffer = method.substring(method.indexOf(120) + 1);
        String nioAddress = destination.getFileServer().getCopyServerAddress(method);
        int index = nioAddress.lastIndexOf(58);
        String host = nioAddress.substring(0, index);
        int port = Integer.parseInt(nioAddress.substring(index + 1));
        InetSocketAddress nio = new InetSocketAddress(host, port);
        long size = localFile.length();
        String targetFilename = Util.stringArrayToString(destination.getFullName());
        int tcpBuffer = SystemProperties.getIntProperty(buffer + "_SIZE");
        SocketChannel socketChannel = null;
        while (socketChannel == null || !socketChannel.isConnected()) {
            socketChannel = SocketChannel.open();
            if (tcpBuffer != 0) {
                System.out.println("TCP_BUFFER=" + tcpBuffer);
                Socket s = socketChannel.socket();
                s.setSendBufferSize(tcpBuffer);
                System.out.println("SendBufferSize=" + s.getSendBufferSize());
                socketChannel.socket().setReceiveBufferSize(tcpBuffer);
                System.out.println("ReceiveBufferSize=" + s.getReceiveBufferSize());
            }
            try {
                socketChannel.socket().setSoTimeout(14400000);
                socketChannel.socket().connect(nio, 14400000);
            }
            catch (IOException e) {
                System.out.println("DATE: " + System.currentTimeMillis() + "\tIOException em BlockingNIOMethod! Ignoring!!!");
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
            }
        }
        FileInputStream file = new FileInputStream(localFile);
        FileChannel fileChannel = file.getChannel();
        String initProtocol = "" + size + "\n" + targetFilename + "\n";
        int headerSize = initProtocol.length();
        String headerSizeStr = headerSize + "\n";
        ByteBuffer headerLength = ByteBuffer.allocate(7);
        headerLength.put(headerSizeStr.getBytes());
        headerLength.rewind();
        socketChannel.write(headerLength);
        ByteBuffer out = ByteBuffer.allocate(initProtocol.length());
        out.put(initProtocol.getBytes());
        out.rewind();
        socketChannel.write(out);
        for (long bytesWritten = 0L; bytesWritten < size; bytesWritten += fileChannel.transferTo(bytesWritten, size - bytesWritten, socketChannel)) {
        }
        fileChannel.close();
        ByteBuffer result = ByteBuffer.allocate(1);
        socketChannel.read(result);
        if (result.get(0) == 0) {
            response = true;
        }
        socketChannel.close();
        return response;
    }

    @Override
    public String getName() {
        return "BLOCKING_NIO";
    }

    @Override
    public String getDetailedInfo() {
        return "BLOCKING_NIO Single Stream";
    }
}

