/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.idl;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.jacorb.idl.ConstrTypeSpec;
import org.jacorb.idl.Environment;
import org.jacorb.idl.GlobalInputStream;
import org.jacorb.idl.IDLTreeVisitor;
import org.jacorb.idl.IDLTypes;
import org.jacorb.idl.IdlSymbol;
import org.jacorb.idl.NameAlreadyDefined;
import org.jacorb.idl.NameTable;
import org.jacorb.idl.ScopedName;
import org.jacorb.idl.SwitchTypeSpec;
import org.jacorb.idl.SymbolList;
import org.jacorb.idl.TypeDeclaration;
import org.jacorb.idl.TypeMap;
import org.jacorb.idl.TypeSpec;
import org.jacorb.idl.parser;

public class EnumType
extends TypeDeclaration
implements SwitchTypeSpec {
    public SymbolList enumlist;
    int const_counter = 0;
    private boolean written = false;
    private boolean parsed = false;

    public EnumType(int num) {
        super(num);
        this.pack_name = "";
    }

    @Override
    public Object clone() {
        EnumType et = new EnumType(EnumType.new_num());
        et.enumlist = this.enumlist;
        et.typeName = this.typeName;
        et.pack_name = this.pack_name;
        et.name = this.name;
        et.token = this.token;
        et.included = this.included;
        et.enclosing_symbol = this.enclosing_symbol;
        et.parsed = this.parsed;
        return et;
    }

    @Override
    public TypeDeclaration declaration() {
        return this;
    }

    public int size() {
        return this.enumlist.v.size();
    }

    @Override
    public void set_included(boolean i) {
        this.included = i;
    }

    @Override
    public String typeName() {
        if (this.typeName == null) {
            this.setPrintPhaseNames();
        }
        return this.typeName;
    }

    @Override
    public boolean basic() {
        return true;
    }

    @Override
    public void setPackage(String s) {
        s = parser.pack_replace(s);
        this.pack_name = this.pack_name.length() > 0 ? s + "." + this.pack_name : s;
    }

    @Override
    public void setEnclosingSymbol(IdlSymbol s) {
        if (this.enclosing_symbol != null && this.enclosing_symbol != s) {
            throw new RuntimeException("Compiler Error: trying to reassign container for " + this.name);
        }
        this.enclosing_symbol = s;
    }

    @Override
    public void parse() {
        if (this.parsed) {
            return;
        }
        this.parsed = true;
        this.escapeName();
        try {
            ConstrTypeSpec ctspec = new ConstrTypeSpec(EnumType.new_num());
            ctspec.c_type_spec = this;
            NameTable.define(this.full_name(), IDLTypes.TYPE);
            TypeMap.typedef(this.full_name(), ctspec);
            String enum_ident = null;
            String prefix = this.pack_name.length() > 0 ? this.full_name().substring(0, this.full_name().lastIndexOf(46) + 1) : "";
            Enumeration e = this.enumlist.v.elements();
            while (e.hasMoreElements()) {
                enum_ident = (String)e.nextElement();
                try {
                    NameTable.define(prefix + enum_ident, IDLTypes.ENUM_LABEL);
                    ScopedName.enumMap(prefix + enum_ident, this.full_name() + "." + enum_ident);
                }
                catch (NameAlreadyDefined p) {
                    parser.error("Identifier " + enum_ident + " already defined in immediate scope", this.token);
                }
            }
        }
        catch (NameAlreadyDefined p) {
            parser.error("Enum " + this.full_name() + " already defined", this.token);
        }
    }

    public String className() {
        String fullName = this.typeName();
        if (fullName.indexOf(46) > 0) {
            return fullName.substring(fullName.lastIndexOf(46) + 1);
        }
        return fullName;
    }

    @Override
    public String printReadExpression(String streamname) {
        return this.toString() + "Helper.read(" + streamname + ")";
    }

    @Override
    public String printWriteStatement(String var_name, String streamname) {
        return this.toString() + "Helper.write(" + streamname + "," + var_name + ");";
    }

    @Override
    public String holderName() {
        return this.typeName() + "Holder";
    }

    @Override
    public String helperName() {
        return this.typeName() + "Helper";
    }

    @Override
    public String getTypeCodeExpression() {
        return this.getTypeCodeExpression(new HashSet());
    }

    @Override
    public String getTypeCodeExpression(Set knownTypes) {
        if (knownTypes.contains(this)) {
            return this.getRecursiveTypeCodeExpression();
        }
        StringBuffer sb = new StringBuffer();
        sb.append("org.omg.CORBA.ORB.init().create_enum_tc(" + this.typeName() + "Helper.id(),\"" + this.className() + "\",");
        sb.append("new String[]{");
        Enumeration e = this.enumlist.v.elements();
        while (e.hasMoreElements()) {
            sb.append("\"" + (String)e.nextElement() + "\"");
            if (!e.hasMoreElements()) continue;
            sb.append(",");
        }
        sb.append("})");
        return sb.toString();
    }

    private void printHolderClass(String className, PrintWriter ps) {
        if (!this.pack_name.equals("")) {
            ps.println("package " + this.pack_name + ";");
        }
        this.printClassComment("enum", className, ps);
        ps.println("public" + parser.getFinalString() + " class " + className + "Holder");
        ps.println("\timplements org.omg.CORBA.portable.Streamable");
        ps.println("{");
        ps.println("\tpublic " + className + " value;" + Environment.NL);
        ps.println("\tpublic " + className + "Holder ()");
        ps.println("\t{");
        ps.println("\t}");
        ps.println("\tpublic " + className + "Holder (final " + className + " initial)");
        ps.println("\t{");
        ps.println("\t\tvalue = initial;");
        ps.println("\t}");
        ps.println("\tpublic org.omg.CORBA.TypeCode _type ()");
        ps.println("\t{");
        ps.println("\t\treturn " + className + "Helper.type ();");
        ps.println("\t}");
        ps.println("\tpublic void _read (final org.omg.CORBA.portable.InputStream in)");
        ps.println("\t{");
        ps.println("\t\tvalue = " + className + "Helper.read (in);");
        ps.println("\t}");
        ps.println("\tpublic void _write (final org.omg.CORBA.portable.OutputStream out)");
        ps.println("\t{");
        ps.println("\t\t" + className + "Helper.write (out,value);");
        ps.println("\t}");
        ps.println("}");
    }

    private void printHelperClass(String className, PrintWriter ps) {
        if (!this.pack_name.equals("")) {
            ps.println("package " + this.pack_name + ";");
        }
        this.printClassComment("enum", className, ps);
        ps.println("public abstract class " + className + "Helper");
        ps.println("{");
        ps.println("\tprivate volatile static org.omg.CORBA.TypeCode _type;");
        ps.println("\tpublic static org.omg.CORBA.TypeCode type ()");
        ps.println("\t{");
        ps.println("\t\tif (_type == null)");
        ps.println("\t\t{");
        ps.println("\t\t\tsynchronized(" + className + "Helper.class)");
        ps.println("\t\t\t{");
        ps.println("\t\t\t\tif (_type == null)");
        ps.println("\t\t\t\t{");
        ps.println("\t\t\t\t\t_type = " + this.getTypeCodeExpression() + ";");
        ps.println("\t\t\t\t}");
        ps.println("\t\t\t}");
        ps.println("\t\t}");
        ps.println("\t\treturn _type;");
        ps.println("\t}" + Environment.NL);
        String type = this.typeName();
        TypeSpec.printInsertExtractMethods(ps, type);
        this.printIdMethod(ps);
        ps.println("\tpublic static " + className + " read (final org.omg.CORBA.portable.InputStream in)");
        ps.println("\t{");
        ps.println("\t\treturn " + className + ".from_int(in.read_long());");
        ps.println("\t}" + Environment.NL);
        ps.println("\tpublic static void write (final org.omg.CORBA.portable.OutputStream out, final " + className + " s)");
        ps.println("\t{");
        ps.println("\t\tout.write_long(s.value());");
        ps.println("\t}");
        ps.println("}");
    }

    private void printEnumClass(String className, PrintWriter pw) {
        String label;
        if (!this.pack_name.equals("")) {
            pw.println("package " + this.pack_name + ";");
        }
        this.printClassComment("enum", className, pw);
        pw.println("public" + parser.getFinalString() + " class " + className);
        pw.println("\timplements org.omg.CORBA.portable.IDLEntity" + Environment.NL + "{");
        this.printSerialVersionUID(pw);
        pw.println("\tprivate int value = -1;");
        Enumeration e = this.enumlist.v.elements();
        while (e.hasMoreElements()) {
            label = (String)e.nextElement();
            pw.println("\tpublic static final int _" + label + " = " + this.const_counter++ + ";");
            pw.println("\tpublic static final " + this.name + " " + label + " = new " + this.name + "(_" + label + ");");
        }
        pw.println("\tpublic int value()");
        pw.println("\t{");
        pw.println("\t\treturn value;");
        pw.println("\t}");
        pw.println("\tpublic static " + this.name + " from_int(int value)");
        pw.println("\t{");
        pw.println("\t\tswitch (value) {");
        e = this.enumlist.v.elements();
        while (e.hasMoreElements()) {
            label = (String)e.nextElement();
            pw.println("\t\t\tcase _" + label + ": return " + label + ";");
        }
        pw.println("\t\t\tdefault: throw new org.omg.CORBA.BAD_PARAM();");
        pw.println("\t\t}");
        pw.println("\t}");
        pw.println("\tpublic String toString()");
        pw.println("\t{");
        pw.println("\t\tswitch (value) {");
        e = this.enumlist.v.elements();
        while (e.hasMoreElements()) {
            label = (String)e.nextElement();
            pw.println("\t\t\tcase _" + label + ": return \"" + label + "\";");
        }
        pw.println("\t\t\tdefault: throw new org.omg.CORBA.BAD_PARAM();");
        pw.println("\t\t}");
        pw.println("\t}");
        pw.println("\tprotected " + this.name + "(int i)");
        pw.println("\t{");
        pw.println("\t\tvalue = i;");
        pw.println("\t}");
        pw.println("\t/**");
        pw.println("\t * Designate replacement object when deserialized from stream. See");
        pw.println("\t * http://www.omg.org/docs/ptc/02-01-03.htm#Issue4271");
        pw.println("\t *");
        pw.println("\t * @throws java.io.ObjectStreamException");
        pw.println("\t */");
        pw.println("\tjava.lang.Object readResolve()");
        if (!parser.cldc10) {
            pw.println("\tthrows java.io.ObjectStreamException");
        }
        pw.println("\t{");
        pw.println("\t\treturn from_int(value());");
        pw.println("\t}");
        pw.println("}");
    }

    @Override
    public void print(PrintWriter ps) {
        this.setPrintPhaseNames();
        if (this.included && !this.generateIncluded()) {
            return;
        }
        if (!this.written) {
            try {
                PrintWriter printWriter;
                String fname;
                File f;
                String className = this.className();
                String path = parser.out_dir + fileSeparator + this.pack_name.replace('.', fileSeparator);
                File dir = new File(path);
                if (!dir.exists() && !dir.mkdirs()) {
                    parser.fatal_error("Unable to create " + path, null);
                }
                if (GlobalInputStream.isMoreRecentThan(f = new File(dir, fname = className + ".java"))) {
                    printWriter = new PrintWriter(new FileWriter(f));
                    this.printEnumClass(className, printWriter);
                    printWriter.close();
                }
                if (GlobalInputStream.isMoreRecentThan(f = new File(dir, fname = className + "Holder.java"))) {
                    printWriter = new PrintWriter(new FileWriter(f));
                    this.printHolderClass(className, printWriter);
                    printWriter.close();
                }
                if (GlobalInputStream.isMoreRecentThan(f = new File(dir, fname = className + "Helper.java"))) {
                    printWriter = new PrintWriter(new FileWriter(f));
                    this.printHelperClass(className, printWriter);
                    printWriter.close();
                }
                this.written = true;
            }
            catch (IOException i) {
                throw new RuntimeException("File IO error" + i);
            }
        }
    }

    @Override
    public String toString() {
        return this.typeName();
    }

    @Override
    public boolean isSwitchable() {
        return true;
    }

    @Override
    public void printInsertIntoAny(PrintWriter ps, String anyname, String varname) {
        ps.println("\t\t" + this.pack_name + "." + this.className() + "Helper.insert(" + anyname + ", " + varname + ");");
    }

    @Override
    public void printExtractResult(PrintWriter ps, String resultname, String anyname, String resulttype) {
        ps.println("\t\t" + resultname + " = " + this.pack_name + "." + this.className() + "Helper.extract(" + anyname + ");");
    }

    @Override
    public void accept(IDLTreeVisitor visitor) {
        visitor.visitEnum(this);
    }
}

