/*
 * Decompiled with CFR 0.152.
 */
package csfs.datatransfer.nonblockingnio;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;

public class NonBlockingNIOClient {
    private static final String ENCODING = "ISO-8859-1";
    private static final String DEFAULT_SERVER = "localhost";
    private static final int DEFAULT_PORT_NUMBER = 7780;

    public static void main(String[] args) {
        String filePath;
        int port;
        String server;
        NonBlockingNIOClient client;
        boolean success;
        if (args.length < 1) {
            NonBlockingNIOClient.terminate();
        }
        System.out.println((success = (client = new NonBlockingNIOClient()).sendFile(server = NonBlockingNIOClient.getServer(args), port = NonBlockingNIOClient.getServerPort(args), filePath = NonBlockingNIOClient.getFilePath(args), filePath + ".copy")) ? "Transfer\u00cdncia completada com sucesso." : "Erro na transfer\u00cdncia.");
    }

    private static String getServer(String[] args) {
        String server = DEFAULT_SERVER;
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals("-s")) continue;
            if (args.length < i + 2) {
                NonBlockingNIOClient.terminate();
            }
            server = args[i + 1];
            break;
        }
        System.out.println("Conectando ao servidor: " + server);
        return server;
    }

    private static int getServerPort(String[] args) {
        int port = 7780;
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals("-p")) continue;
            try {
                if (args.length < i + 2) {
                    NonBlockingNIOClient.terminate();
                }
                port = Integer.parseInt(args[i + 1]);
            }
            catch (NumberFormatException ex) {
                NonBlockingNIOClient.terminate();
            }
            break;
        }
        System.out.println("Porta: " + port);
        return port;
    }

    private static String getFilePath(String[] args) {
        String path = null;
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals("-f")) continue;
            if (args.length < i + 2) {
                NonBlockingNIOClient.terminate();
            }
            path = args[i + 1];
            break;
        }
        if (path == null) {
            NonBlockingNIOClient.terminate();
        }
        System.out.println("Caminho do arquivo: " + path);
        return path;
    }

    private static void terminate() {
        System.out.println("Uso: java FTPNIOClient [-s <servidor>] [-p <numero_porta>] -f <caminho_arquivo>");
        System.exit(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendFile(String server, int port, String sourcePath, String targetPath) {
        SocketChannel serverChannel = null;
        while (serverChannel == null || !serverChannel.isConnected()) {
            try {
                serverChannel = SocketChannel.open();
                serverChannel.socket().setSoTimeout(14400000);
                serverChannel.socket().connect(new InetSocketAddress(server, port), 14400000);
            }
            catch (IOException e) {
                System.out.println("DATE: " + System.currentTimeMillis() + "\tIOException em NonBlockingNIOClient:sendfile():connect()! Ignoring!!!");
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
            }
        }
        FileInputStream in = null;
        AbstractInterruptibleChannel fileChannel = null;
        try {
            int pathSize = targetPath.length();
            this.putPathSize(pathSize, serverChannel);
            this.putPath(targetPath, serverChannel);
            in = new FileInputStream(sourcePath);
            fileChannel = in.getChannel();
            long fileSize = ((FileChannel)fileChannel).size();
            this.putFileSize(fileSize, serverChannel);
            this.putFile((FileChannel)fileChannel, fileSize, serverChannel);
            boolean bl = this.waitForAck(serverChannel);
            return bl;
        }
        catch (FileNotFoundException e) {
            System.err.println("N\u201eo foi poss\u00ccvel abrir o arquivo " + sourcePath + ".");
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            System.err.println("N\u201eo foi poss\u00ccvel transferir o arquivo " + sourcePath + ".");
            System.out.println("TIME:" + System.currentTimeMillis());
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (fileChannel != null) {
                try {
                    fileChannel.close();
                }
                catch (IOException e) {}
            }
            if (serverChannel != null) {
                try {
                    serverChannel.close();
                }
                catch (IOException e) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private boolean waitForAck(SocketChannel channel) throws IOException {
        ByteBuffer ack = ByteBuffer.allocate(1);
        channel.read(ack);
        ack.flip();
        return ack.get() == 10;
    }

    private void putPath(String filePath, SocketChannel channel) throws IOException {
        CharBuffer charBuffer = CharBuffer.wrap(filePath.toCharArray());
        Charset charset = Charset.forName(ENCODING);
        CharsetEncoder encoder = charset.newEncoder();
        ByteBuffer byteBuffer = encoder.encode(charBuffer);
        channel.write(byteBuffer);
    }

    private void putFile(FileChannel sourceChannel, long remainingBytes, SocketChannel targetChannel) throws IOException {
        while (remainingBytes > 0L) {
            long readBytes = sourceChannel.transferTo(0L, remainingBytes, targetChannel);
            remainingBytes -= readBytes;
        }
    }

    private void putFileSize(long fileSize, SocketChannel channel) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocateDirect(8);
        buffer.putLong(fileSize);
        buffer.flip();
        channel.write(buffer);
    }

    private void putPathSize(int pathSize, SocketChannel channel) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocateDirect(4);
        buffer.putInt(pathSize);
        buffer.flip();
        channel.write(buffer);
    }
}

