/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.iiop;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.Socket;
import javax.net.ssl.SSLSocket;
import org.jacorb.config.Configuration;
import org.jacorb.config.ConfigurationException;
import org.jacorb.orb.iiop.IIOPAddress;
import org.jacorb.orb.iiop.IIOPConnection;
import org.jacorb.orb.iiop.IIOPProfile;
import org.jacorb.orb.listener.TCPConnectionEvent;
import org.jacorb.orb.listener.TCPConnectionListener;
import org.omg.ETF.Profile;

public class ServerIIOPConnection
extends IIOPConnection {
    private final TCPConnectionListener tcpListener;

    public ServerIIOPConnection(Socket socket, boolean is_ssl, TCPConnectionListener tcpListener) throws IOException {
        this.socket = socket;
        this.use_ssl = is_ssl;
        this.in_stream = socket.getInputStream();
        this.out_stream = new BufferedOutputStream(socket.getOutputStream());
        this.tcpListener = tcpListener;
    }

    @Override
    public void configure(Configuration configuration) throws ConfigurationException {
        super.configure(configuration);
        IIOPAddress address = new IIOPAddress(this.socket.getInetAddress().getHostAddress(), this.socket.getPort());
        address.configure(configuration);
        this.profile = new IIOPProfile(address, null, this.orb.getGIOPMinorVersion());
        this.profile.configure(configuration);
        this.connection_info = address.toString();
        this.connected = true;
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Opened new server-side TCP/IP transport to " + this.connection_info);
        }
    }

    public synchronized void close() {
        if (this.socket != null) {
            try {
                if (!(this.socket instanceof SSLSocket) && !this.socket.isClosed()) {
                    this.socket.shutdownOutput();
                }
                this.socket.close();
                if (this.in_stream != null) {
                    this.in_stream.close();
                }
                if (this.out_stream != null) {
                    this.out_stream.close();
                }
            }
            catch (IOException ex) {
                throw this.handleCommFailure(ex);
            }
            finally {
                if (this.tcpListener.isListenerEnabled()) {
                    this.tcpListener.connectionClosed(new TCPConnectionEvent(this, this.socket.getInetAddress().toString(), this.socket.getPort(), this.socket.getLocalPort(), this.getLocalhost()));
                }
            }
        }
        this.socket = null;
        this.connected = false;
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Closed server-side transport to " + this.connection_info);
        }
    }

    public void connect(Profile server_profile, long time_out) {
    }
}

