/*
 * Decompiled with CFR 0.152.
 */
package csfs.impl;

import csfs.datatransfer.DataTransferMethod;
import csfs.impl.FileServerImpl;
import csfs.impl.filetracker.FileTracker;
import csfs.impl.filetracker.FileTrackerLeasing;
import csfs.impl.metadata.MetadataManager;
import csfs.impl.performancetracker.DataTransferPerformanceTracker;
import csfs.impl.util.FileLocker;
import csfs.impl.util.IDGenerator;
import csfs.impl.util.NativeFileSystem;
import csfs.impl.util.ServerExceptionBuilder;
import csfs.impl.util.SystemProperties;
import csfs.impl.util.Util;
import csfs.remote.FileAlreadyExistsException;
import csfs.remote.FileInUseException;
import csfs.remote.FileServer;
import csfs.remote.FileServerHelper;
import csfs.remote.InvalidPathException;
import csfs.remote.InvalidStateException;
import csfs.remote.Metadata;
import csfs.remote.MetadataValue;
import csfs.remote.NotDirectoryException;
import csfs.remote.NotEmptyException;
import csfs.remote.NotFileException;
import csfs.remote.RandomAccessChannel;
import csfs.remote.RandomAccessChannelHelper;
import csfs.remote.ReadChannel;
import csfs.remote.ReadChannelHelper;
import csfs.remote.RemoteFile;
import csfs.remote.RemoteFileHelper;
import csfs.remote.RemoteFilePOA;
import csfs.remote.ServerException;
import csfs.remote.WriteChannel;
import csfs.remote.WriteChannelHelper;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Vector;
import java.util.logging.Logger;
import org.omg.CORBA.Object;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.UserException;
import org.omg.PortableServer.POA;

public class RemoteFileDefaultServantImpl
extends RemoteFilePOA {
    private static final String CSFS_MOUNT_HEADER = "CSFS Mount - HEADER! DO NOT EDIT THIS FILE!";
    private static final int MAX_CHANNELS = 1000;
    private String homeDirectory;
    private FileServerImpl fileServer;
    private MetadataManager metadataManager;
    private FileTracker fileTracker;
    private FileLocker fileLocker;

    public RemoteFileDefaultServantImpl(String homeDirectory, FileServerImpl fileServer) {
        this.homeDirectory = homeDirectory;
        this.fileServer = fileServer;
        this.fileTracker = FileTrackerLeasing.getInstance();
        this.metadataManager = new MetadataManager();
        this.fileLocker = new FileLocker();
    }

    @Override
    public String getName() throws InvalidStateException, ServerException {
        try {
            String systemPath = this.getPath();
            File localFile = this.getLocalFile(systemPath);
            return localFile.getName();
        }
        catch (RuntimeException e) {
            Logger.getLogger("global").severe(e.getMessage());
            e.printStackTrace();
            throw ServerExceptionBuilder.createServerException(e);
        }
    }

    @Override
    public boolean isDirectory() throws InvalidStateException, ServerException {
        try {
            String systemPath = this.getPath();
            File localFile = this.getLocalFile(systemPath);
            return localFile.isDirectory();
        }
        catch (RuntimeException e) {
            Logger.getLogger("global").severe(e.getMessage());
            e.printStackTrace();
            throw ServerExceptionBuilder.createServerException(e);
        }
    }

    @Override
    public boolean tryLock() throws InvalidStateException, ServerException, NotFileException {
        try {
            String systemPath = this.getPath();
            File localFile = this.getLocalFile(systemPath);
            if (!localFile.isFile()) {
                throw new NotFileException(this.getFullName());
            }
            return this.fileLocker.tryLock(localFile);
        }
        catch (RuntimeException e) {
            Logger.getLogger("global").severe(e.getMessage());
            e.printStackTrace();
            throw ServerExceptionBuilder.createServerException(e);
        }
    }

    @Override
    public boolean unlock() throws NotFileException, InvalidStateException, ServerException {
        try {
            String systemPath = this.getPath();
            File localFile = this.getLocalFile(systemPath);
            if (!localFile.isFile()) {
                throw new NotFileException(this.getFullName());
            }
            return this.fileLocker.unlock(localFile);
        }
        catch (RuntimeException e) {
            Logger.getLogger("global").severe(e.getMessage());
            e.printStackTrace();
            throw ServerExceptionBuilder.createServerException(e);
        }
    }

    @Override
    public RemoteFile createDirectory(String[] name) throws InvalidPathException, InvalidStateException, FileAlreadyExistsException, NotDirectoryException, ServerException {
        try {
            String systemPath = this.getPath();
            String[] resolvedName = this.resolveNewPath(name);
            File localChild = this.createElement(systemPath, resolvedName);
            boolean success = localChild.mkdirs();
            if (!success) {
                throw new InvalidPathException(Util.getPathArray(systemPath, name));
            }
            return this.createRemoteFile(resolvedName);
        }
        catch (RuntimeException e) {
            Logger.getLogger("global").severe(e.getMessage());
            e.printStackTrace();
            throw ServerExceptionBuilder.createServerException(e);
        }
    }

    @Override
    public RemoteFile createFile(String[] name) throws InvalidPathException, InvalidStateException, FileAlreadyExistsException, NotDirectoryException, ServerException {
        try {
            String systemPath = this.getPath();
            String[] resolvedName = this.resolveNewPath(name);
            File newFile = this.createElement(systemPath, resolvedName);
            boolean created = false;
            try {
                newFile.getParentFile().mkdirs();
                created = newFile.createNewFile();
            }
            catch (IOException exc) {
                exc.printStackTrace();
                throw new InvalidPathException(Util.getPathArray(systemPath, name));
            }
            if (!created) {
                throw new InvalidPathException(Util.getPathArray(systemPath, name));
            }
            return this.createRemoteFile(resolvedName);
        }
        catch (RuntimeException e) {
            Logger.getLogger("global").severe(e.getMessage());
            e.printStackTrace();
            throw ServerExceptionBuilder.createServerException(e);
        }
    }

    @Override
    public boolean addMountPoint(String[] name, RemoteFile target) throws InvalidStateException, NotDirectoryException, FileAlreadyExistsException, InvalidPathException, ServerException {
        try {
            String systemPath = this.getPath();
            File newFile = this.createElement(systemPath, name);
            boolean created = false;
            try {
                newFile.getParentFile().mkdirs();
                created = newFile.createNewFile();
                BufferedWriter writer = new BufferedWriter(new FileWriter(newFile));
                writer.write("CSFS Mount - HEADER! DO NOT EDIT THIS FILE!\n");
                writer.write(this._orb().object_to_string((Object)target) + "\n");
                writer.close();
            }
            catch (IOException exc) {
                created = false;
                newFile.delete();
                exc.printStackTrace();
                throw new InvalidStateException("error persisting object reference to disk", Util.getPathArray(systemPath, name));
            }
            if (!created) {
                throw new InvalidPathException(Util.getPathArray(systemPath, name));
            }
            return created;
        }
        catch (RuntimeException e) {
            Logger.getLogger("global").severe(e.getMessage());
            e.printStackTrace();
            throw ServerExceptionBuilder.createServerException(e);
        }
    }

    @Override
    public RemoteFile removeMountPoint(String[] name) throws NotDirectoryException, csfs.remote.FileNotFoundException, InvalidPathException, InvalidStateException, ServerException {
        try {
            RemoteFile response = null;
            String systemPath = this.getPath();
            File localFile = this.getLocalFile(systemPath);
            if (name.length > 1) {
                String[] parent = new String[name.length - 1];
                for (int i = 0; i < parent.length; ++i) {
                    parent[i] = name[i];
                }
                RemoteFile mountDir = this.getChild(parent);
                response = mountDir.removeMountPoint(new String[]{name[name.length - 1]});
            } else {
                if (name.length == 0) {
                    throw new InvalidPathException(name);
                }
                File probe = new File(localFile, name[0]);
                if (probe.exists() && (response = this.resolveMountPoint(probe)) != null && !probe.delete()) {
                    response = null;
                }
            }
            if (response == null) {
                throw new csfs.remote.FileNotFoundException(Util.getPathArray(systemPath, name));
            }
            return response;
        }
        catch (RuntimeException e) {
            Logger.getLogger("global").severe(e.getMessage());
            e.printStackTrace();
            throw ServerExceptionBuilder.createServerException(e);
        }
    }

    @Override
    public String[] getFullName() throws InvalidStateException, ServerException {
        try {
            String systemPath = this.getPath();
            this.getLocalFile(systemPath);
            return Util.stringToStringArray(systemPath);
        }
        catch (RuntimeException e) {
            Logger.getLogger("global").severe(e.getMessage());
            e.printStackTrace();
            throw ServerExceptionBuilder.createServerException(e);
        }
    }

    @Override
    public boolean copyTo(RemoteFile destination, String method) throws InvalidStateException, NotFileException, ServerException {
        try {
            long elapsedTime;
            String systemPath = this.getPath();
            File localFile = this.getLocalFile(systemPath);
            if (!localFile.isFile()) {
                throw new NotFileException(this.getFullName());
            }
            int index = method.indexOf(45);
            if (index == -1) {
                index = method.length();
            }
            String methodCore = method.substring(0, index);
            DataTransferMethod bulkTransfer = this.fileServer.getDataTransferMethod(methodCore);
            long startTime = System.currentTimeMillis();
            boolean success = bulkTransfer.copy(localFile, destination, method);
            if (success && (elapsedTime = System.currentTimeMillis() - startTime) > 0L) {
                String destinationHost = destination.getFileServer().getName();
                DataTransferPerformanceTracker.getInstance().update(destinationHost, localFile.length(), elapsedTime);
            }
            return success;
        }
        catch (IOException e) {
            Logger.getLogger("global").severe(e.getMessage());
            e.printStackTrace();
            throw ServerExceptionBuilder.createServerException(e);
        }
        catch (RuntimeException e) {
            Logger.getLogger("global").severe(e.getMessage());
            e.printStackTrace();
            throw ServerExceptionBuilder.createServerException(e);
        }
    }

    @Override
    public boolean moveTo(RemoteFile destination, String method) throws NotFileException, FileInUseException, ServerException, InvalidStateException {
        try {
            String systemPath = this.getPath();
            File localFile = this.getLocalFile(systemPath);
            if (!localFile.isFile()) {
                throw new NotFileException(this.getFullName());
            }
            if (this.fileTracker.inUse(systemPath)) {
                throw new FileInUseException(this.getFullName());
            }
            boolean success = false;
            if (this._this().getFileServer().getName().equals(destination.getFileServer().getName())) {
                String destinationSystemPath = Util.stringArrayToString(destination.getFullName());
                File targetFile = this.getLocalFile(destinationSystemPath);
                if (targetFile.delete()) {
                    success = localFile.renameTo(targetFile);
                }
            } else if (this._this().copyTo(destination, method)) {
                try {
                    success = this._this().remove();
                }
                catch (NotEmptyException e) {
                    Logger.getLogger("global").severe("ACESSO CONCORRENTE! O arquivo " + this._this().getName() + "foi substituido por um diretorio");
                }
            }
            return success;
        }
        catch (RuntimeException e) {
            Logger.getLogger("global").severe(e.getMessage());
            e.printStackTrace();
            throw ServerExceptionBuilder.createServerException(e);
        }
    }

    @Override
    public boolean truncate(long size) throws NotFileException, FileInUseException, ServerException, InvalidStateException {
        try {
            String systemPath = this.getPath();
            File localFile = this.getLocalFile(systemPath);
            if (!localFile.isFile()) {
                throw new NotFileException(this.getFullName());
            }
            FileChannel nioChannel = new RandomAccessFile(localFile, "rw").getChannel();
            nioChannel.truncate(size);
            return true;
        }
        catch (IOException e) {
            Logger.getLogger("global").severe(e.getMessage());
            e.printStackTrace();
            throw ServerExceptionBuilder.createServerException(e);
        }
        catch (RuntimeException e) {
            Logger.getLogger("global").severe(e.getMessage());
            e.printStackTrace();
            throw ServerExceptionBuilder.createServerException(e);
        }
    }

    @Override
    public long lastModified() throws ServerException, InvalidStateException {
        try {
            String systemPath = this.getPath();
            File localFile = this.getLocalFile(systemPath);
            return localFile.lastModified();
        }
        catch (RuntimeException e) {
            Logger.getLogger("global").severe(e.getMessage());
            e.printStackTrace();
            throw ServerExceptionBuilder.createServerException(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean remove() throws FileInUseException, NotEmptyException, InvalidStateException, ServerException {
        try {
            boolean response = false;
            String systemPath = this.getPath();
            File localFile = this.getLocalFile(systemPath);
            if (this.fileTracker.inUse(systemPath)) {
                throw new FileInUseException(this.getFullName());
            }
            if (localFile.isFile()) {
                response = localFile.delete();
            }
            if (!localFile.isDirectory()) return response;
            File[] child = localFile.listFiles();
            if (child.length != 0) throw new NotEmptyException(this.getFullName());
            if (systemPath.length() <= 1) throw new FileInUseException(this.getFullName());
            return localFile.delete();
        }
        catch (RuntimeException e) {
            Logger.getLogger("global").severe(e.getMessage());
            e.printStackTrace();
            throw ServerExceptionBuilder.createServerException(e);
        }
    }

    @Override
    public RemoteFile[] getChildren() throws InvalidStateException, NotDirectoryException, ServerException {
        try {
            String systemPath = this.getPath();
            File localFile = this.getLocalFile(systemPath);
            if (!localFile.isDirectory()) {
                throw new NotDirectoryException(this.getFullName());
            }
            File[] dirContents = localFile.listFiles();
            RemoteFile mountProbe = null;
            Vector<RemoteFile> response = new Vector<RemoteFile>();
            for (int i = 0; i < dirContents.length; ++i) {
                File child = dirContents[i];
                if (this.metadataManager.isMetadataFile(child.getName()) || this.fileLocker.isLockFile(child.getName())) continue;
                if (child.isFile()) {
                    mountProbe = this.resolveMountPoint(child);
                }
                if (mountProbe == null) {
                    response.add(this.createRemoteFile(systemPath + '/' + child.getName()));
                    continue;
                }
                response.add(mountProbe);
            }
            return response.toArray(new RemoteFile[response.size()]);
        }
        catch (RuntimeException e) {
            Logger.getLogger("global").severe(e.getMessage());
            e.printStackTrace();
            throw ServerExceptionBuilder.createServerException(e);
        }
    }

    @Override
    public RemoteFile getChild(String[] name) throws InvalidPathException, InvalidStateException, NotDirectoryException, csfs.remote.FileNotFoundException, ServerException {
        try {
            RemoteFile response;
            if (name.length == 1) {
                response = this.localGetChild(name[0]);
            } else {
                response = this._this();
                for (int i = 0; i < name.length; ++i) {
                    response = response.getChild(new String[]{name[i]});
                }
            }
            return response;
        }
        catch (InvalidPathException e) {
            throw e;
        }
        catch (InvalidStateException e) {
            throw e;
        }
        catch (NotDirectoryException e) {
            throw e;
        }
        catch (csfs.remote.FileNotFoundException e) {
            throw e;
        }
        catch (RuntimeException e) {
            Logger.getLogger("global").severe(e.getMessage());
            e.printStackTrace();
            throw ServerExceptionBuilder.createServerException(e);
        }
    }

    private RemoteFile localGetChild(String name) throws NotDirectoryException, csfs.remote.FileNotFoundException, InvalidPathException, InvalidStateException, ServerException {
        String systemPath = this.getPath();
        File localFile = this.getLocalFile(systemPath);
        if (!localFile.isDirectory()) {
            throw new NotDirectoryException(this.getFullName());
        }
        File existingFile = new File(localFile, name);
        if (!existingFile.exists()) {
            throw new csfs.remote.FileNotFoundException(Util.getPathArray(systemPath, name));
        }
        if (this.metadataManager.isMetadataFile(existingFile.getName())) {
            throw new InvalidPathException(Util.getPathArray(systemPath, name));
        }
        if (this.fileLocker.isLockFile(existingFile.getName())) {
            throw new InvalidPathException(Util.getPathArray(systemPath, name));
        }
        if (!Util.isValid(existingFile)) {
            throw new InvalidPathException(Util.getPathArray(systemPath, name));
        }
        RemoteFile response = this.resolveMountPoint(existingFile);
        if (response == null) {
            response = name.equals(".") ? this._this() : (name.equals("..") ? this.createRemoteFile(systemPath.substring(0, systemPath.lastIndexOf(47))) : this.createRemoteFile(systemPath + '/' + name));
        }
        return response;
    }

    private String[] resolveNewPath(String[] path) throws ServerException, InvalidStateException, InvalidPathException, NotDirectoryException {
        String[] resolvedPathArray = null;
        RemoteFile lastResolvedFile = this._this();
        for (int i = 0; i < path.length; ++i) {
            String element = path[i];
            try {
                RemoteFile file;
                lastResolvedFile = file = lastResolvedFile.getChild(new String[]{element});
                continue;
            }
            catch (csfs.remote.FileNotFoundException e) {
                String[] lastResolvedFilePath = lastResolvedFile.getFullName();
                resolvedPathArray = new String[lastResolvedFilePath.length + (path.length - i)];
                System.arraycopy(lastResolvedFilePath, 0, resolvedPathArray, 0, lastResolvedFilePath.length);
                System.arraycopy(path, i, resolvedPathArray, lastResolvedFilePath.length, path.length - i);
                String systemPath = this.getPath();
                String[] rootPath = Util.stringToStringArray(systemPath);
                if (rootPath.length <= 0) break;
                String resolvedPathString = Util.stringArrayToString(resolvedPathArray);
                String rootPathString = Util.stringArrayToString(rootPath);
                resolvedPathString = resolvedPathString.replaceFirst(rootPathString, "");
                resolvedPathArray = Util.stringToStringArray(resolvedPathString);
                break;
            }
        }
        if (resolvedPathArray == null) {
            return path;
        }
        return resolvedPathArray;
    }

    private RemoteFile resolveMountPoint(File file) throws InvalidStateException, ServerException {
        try {
            RemoteFile response = null;
            try {
                if (file.isFile() && file.length() < 1024L) {
                    BufferedReader reader = new BufferedReader(new FileReader(file));
                    String line = reader.readLine();
                    if (CSFS_MOUNT_HEADER.equals(line)) {
                        String ior = reader.readLine();
                        response = RemoteFileHelper.narrow(this._orb().string_to_object(ior));
                    }
                    reader.close();
                }
            }
            catch (IOException exc) {
                exc.printStackTrace();
                throw new InvalidStateException("Unable to resolve mount: " + exc.getMessage(), this.getFullName());
            }
            return response;
        }
        catch (RuntimeException e) {
            Logger.getLogger("global").severe(e.getMessage());
            e.printStackTrace();
            throw ServerExceptionBuilder.createServerException(e);
        }
    }

    @Override
    public RemoteFile getParent() throws InvalidPathException, InvalidStateException, ServerException {
        try {
            String systemPath = this.getPath();
            if (systemPath.length() <= 1) {
                throw new InvalidPathException(new String[]{".."});
            }
            this.getLocalFile(systemPath);
            return this.createRemoteFile(systemPath.substring(0, systemPath.lastIndexOf(47)));
        }
        catch (RuntimeException e) {
            Logger.getLogger("global").severe(e.getMessage());
            e.printStackTrace();
            throw ServerExceptionBuilder.createServerException(e);
        }
    }

    @Override
    public long size() throws NotFileException, InvalidStateException, ServerException {
        try {
            String systemPath = this.getPath();
            File localFile = this.getLocalFile(systemPath);
            if (localFile.isDirectory()) {
                throw new NotFileException(this.getFullName());
            }
            return localFile.length();
        }
        catch (RuntimeException e) {
            Logger.getLogger("global").severe(e.getMessage());
            e.printStackTrace();
            throw ServerExceptionBuilder.createServerException(e);
        }
    }

    @Override
    public WriteChannel getWriteChannel() throws InvalidStateException, NotFileException, ServerException {
        if (this.fileTracker.totalOpenFileDescriptors() >= 1000) {
            throw new InvalidStateException("MAX OPEN CHANNEL REACHED", this.getFullName());
        }
        WriteChannel response = null;
        try {
            try {
                String systemPath = this.getPath();
                File localFile = this.getLocalFile(systemPath);
                if (!localFile.isFile()) {
                    throw new NotFileException(this.getFullName());
                }
                FileOutputStream output = new FileOutputStream(localFile);
                String channelId = systemPath + "_" + IDGenerator.nextId();
                this.fileTracker.setFileDescriptor(channelId, output);
                response = WriteChannelHelper.narrow(this.getChannel("WriteChannelDefaultServantPOA", channelId, WriteChannelHelper.type()));
            }
            catch (FileNotFoundException ex) {
                throw new InvalidStateException("java.io.FileNotFoundException:" + ex.getMessage(), this.getFullName());
            }
        }
        catch (RuntimeException e) {
            Logger.getLogger("global").severe(e.getMessage());
            e.printStackTrace();
            throw ServerExceptionBuilder.createServerException(e);
        }
        catch (Throwable t) {
            System.out.println("t.getMessage()=" + t.getMessage());
            Logger.getLogger("global").severe(t.getMessage());
            t.printStackTrace();
        }
        return response;
    }

    @Override
    public ReadChannel getReadChannel() throws InvalidStateException, NotFileException, ServerException {
        if (this.fileTracker.totalOpenFileDescriptors() >= 1000) {
            throw new InvalidStateException("MAX OPEN CHANNEL REACHED", this.getFullName());
        }
        try {
            ReadChannel response = null;
            try {
                String systemPath = this.getPath();
                File localFile = this.getLocalFile(systemPath);
                if (!localFile.isFile()) {
                    throw new NotFileException(this.getFullName());
                }
                FileInputStream input = new FileInputStream(localFile);
                String channelId = systemPath + "_" + IDGenerator.nextId();
                this.fileTracker.setFileDescriptor(channelId, input);
                response = ReadChannelHelper.narrow(this.getChannel("ReadChannelDefaultServantPOA", channelId, ReadChannelHelper.type()));
            }
            catch (FileNotFoundException ex) {
                throw new InvalidStateException("java.io.FileNotFoundException:" + ex.getMessage(), this.getFullName());
            }
            return response;
        }
        catch (RuntimeException e) {
            Logger.getLogger("global").severe(e.getMessage());
            e.printStackTrace();
            throw ServerExceptionBuilder.createServerException(e);
        }
    }

    @Override
    public RandomAccessChannel getRandomAccessChannel() throws InvalidStateException, NotFileException, ServerException {
        if (this.fileTracker.totalOpenFileDescriptors() >= 1000) {
            throw new InvalidStateException("MAX OPEN CHANNEL REACHED", this.getFullName());
        }
        try {
            RandomAccessChannel response = null;
            try {
                String systemPath = this.getPath();
                File localFile = this.getLocalFile(systemPath);
                if (!localFile.isFile()) {
                    throw new NotFileException(this.getFullName());
                }
                RandomAccessFile raf = new RandomAccessFile(localFile, "rw");
                String channelId = systemPath + "_" + IDGenerator.nextId();
                this.fileTracker.setFileDescriptor(channelId, raf);
                response = RandomAccessChannelHelper.narrow(this.getChannel("RandomAccessChannelDefaultServantPOA", channelId, RandomAccessChannelHelper.type()));
            }
            catch (FileNotFoundException ex) {
                throw new InvalidStateException("java.io.FileNotFoundException:" + ex.getMessage(), this.getFullName());
            }
            return response;
        }
        catch (RuntimeException e) {
            Logger.getLogger("global").severe(e.getMessage());
            e.printStackTrace();
            throw ServerExceptionBuilder.createServerException(e);
        }
    }

    @Override
    public byte[] hash() throws NotFileException, InvalidStateException, ServerException {
        try {
            byte[] digest = null;
            try {
                String systemPath = this.getPath();
                File localFile = this.getLocalFile(systemPath);
                if (!localFile.isFile()) {
                    throw new NotFileException(this.getFullName());
                }
                MessageDigest digester = MessageDigest.getInstance("MD5");
                byte[] buffer = new byte[4096];
                long read = 0L;
                long size = localFile.length();
                BufferedInputStream input = new BufferedInputStream(new FileInputStream(localFile), SystemProperties.getIntProperty("BUFFERED_STREAM_SIZE_HASH"));
                while (read < size) {
                    int localRead = 0;
                    int bufferPosition = 0;
                    while ((localRead = input.read(buffer, bufferPosition, buffer.length - bufferPosition)) > 0) {
                        digester.update(buffer, bufferPosition, localRead);
                        bufferPosition += localRead;
                        read += (long)localRead;
                    }
                }
                input.close();
                if (read != size) {
                    throw new InvalidStateException("Could NOT read expected " + read + " bytes", this.getFullName());
                }
                digest = digester.digest();
            }
            catch (IOException ex) {
                throw new InvalidStateException("IOException:" + ex.getMessage(), this.getFullName());
            }
            catch (NoSuchAlgorithmException ex) {
                throw new InvalidStateException("There is no MD5 digester! " + ex.getMessage(), this.getFullName());
            }
            return digest;
        }
        catch (RuntimeException e) {
            Logger.getLogger("global").severe(e.getMessage());
            e.printStackTrace();
            throw ServerExceptionBuilder.createServerException(e);
        }
    }

    @Override
    public void setMetadata(Metadata[] metadata) throws NotFileException, InvalidStateException, ServerException {
        try {
            String systemPath = this.getPath();
            File localFile = this.getLocalFile(systemPath);
            if (!localFile.isFile()) {
                throw new NotFileException(this.getFullName());
            }
            try {
                this.metadataManager.saveMetadataInfo(metadata, localFile);
            }
            catch (IOException ex) {
                throw new InvalidStateException("metadata problem" + ex.getMessage(), this.getFullName());
            }
        }
        catch (RuntimeException e) {
            Logger.getLogger("global").severe(e.getMessage());
            e.printStackTrace();
            throw ServerExceptionBuilder.createServerException(e);
        }
    }

    @Override
    public Metadata[] getMetadata(String[] fields) throws NotFileException, InvalidStateException, ServerException {
        try {
            String systemPath = this.getPath();
            File localFile = this.getLocalFile(systemPath);
            if (!localFile.isFile()) {
                throw new NotFileException(this.getFullName());
            }
            Metadata[] response = new Metadata[fields.length];
            for (int i = 0; i < response.length; ++i) {
                response[i] = new Metadata(fields[i], new MetadataValue());
            }
            try {
                this.metadataManager.lookupMetadata(response, localFile);
            }
            catch (IOException ex) {
                throw new InvalidStateException("metadata problem" + ex.getMessage(), this.getFullName());
            }
            return response;
        }
        catch (RuntimeException e) {
            Logger.getLogger("global").severe(e.getMessage());
            e.printStackTrace();
            throw ServerExceptionBuilder.createServerException(e);
        }
    }

    @Override
    public Metadata[] getAllMetadata() throws NotFileException, InvalidStateException, ServerException {
        try {
            Metadata[] response = null;
            String systemPath = this.getPath();
            File localFile = this.getLocalFile(systemPath);
            if (!localFile.isFile()) {
                throw new NotFileException(this.getFullName());
            }
            try {
                response = this.metadataManager.getMetadata(localFile);
            }
            catch (IOException ex) {
                throw new InvalidStateException("metadata problem" + ex.getMessage(), this.getFullName());
            }
            return response;
        }
        catch (RuntimeException e) {
            Logger.getLogger("global").severe(e.getMessage());
            e.printStackTrace();
            throw ServerExceptionBuilder.createServerException(e);
        }
    }

    @Override
    public void updateMetadata(Metadata[] metadata) throws NotFileException, InvalidStateException, ServerException {
        try {
            String systemPath = this.getPath();
            File localFile = this.getLocalFile(systemPath);
            if (!localFile.isFile()) {
                throw new NotFileException(this.getFullName());
            }
            try {
                this.metadataManager.updateMetadata(metadata, localFile);
            }
            catch (IOException ex) {
                throw new InvalidStateException("metadata problem" + ex.getMessage(), this.getFullName());
            }
        }
        catch (RuntimeException e) {
            Logger.getLogger("global").severe(e.getMessage());
            e.printStackTrace();
            throw ServerExceptionBuilder.createServerException(e);
        }
    }

    @Override
    public FileServer getFileServer() throws ServerException {
        try {
            Object o = this._poa().the_parent().find_POA("FileServerPOA", false).create_reference_with_id("FileServer".getBytes(), FileServerHelper.type().id());
            return FileServerHelper.narrow(o);
        }
        catch (Exception e) {
            Logger.getLogger("global").severe(e.getMessage());
            e.printStackTrace();
            throw ServerExceptionBuilder.createServerException(e);
        }
    }

    @Override
    public void enableExecutionPermission() throws InvalidStateException, ServerException {
        try {
            String systemPath = this.getPath();
            File localFile = this.getLocalFile(systemPath);
            if (!System.getProperty("os.name").toLowerCase().startsWith("windows")) {
                String filename = localFile.getAbsolutePath();
                try {
                    filename = localFile.getCanonicalPath();
                    NativeFileSystem.enableExecutionPermission(filename);
                }
                catch (IOException ex) {
                    Logger.getLogger("global").severe("ERRO: atribuindo permissao de execucao para " + filename);
                    ex.printStackTrace();
                }
            }
        }
        catch (RuntimeException e) {
            Logger.getLogger("global").severe(e.getMessage());
            e.printStackTrace();
            throw ServerExceptionBuilder.createServerException(e);
        }
    }

    private String getPath() throws InvalidStateException {
        return new String(this._object_id());
    }

    private File createElement(String systemPath, String[] name) throws FileAlreadyExistsException, NotDirectoryException, InvalidPathException, InvalidStateException, ServerException {
        File localFile = this.getLocalFile(systemPath);
        if (!localFile.isDirectory()) {
            throw new NotDirectoryException(this.getFullName());
        }
        for (int i = 0; i < name.length; ++i) {
            if (name[i].indexOf(47) == -1 && name[i].indexOf(92) == -1) continue;
            throw new InvalidPathException(name);
        }
        if (this.metadataManager.isMetadataFile(name[name.length - 1]) || this.fileLocker.isLockFile(name[name.length - 1])) {
            throw new InvalidPathException(name);
        }
        String systemNewElement = Util.stringArrayToString(name);
        File newFile = new File(localFile, Util.systemFileSeparatorToLocalFileSeparator(systemNewElement));
        if (newFile == null || !Util.isValid(newFile)) {
            throw new InvalidPathException(name);
        }
        if (newFile.exists()) {
            throw new FileAlreadyExistsException(Util.getPathArray(systemPath, name));
        }
        return newFile;
    }

    private RemoteFile createRemoteFile(String[] name) throws InvalidStateException, ServerException {
        String path = this.getPath() + '/' + Util.stringArrayToString(name);
        return this.createRemoteFile(path);
    }

    private File getLocalFile(String systemPath) throws InvalidStateException {
        File localFile = new File(this.homeDirectory, Util.systemFileSeparatorToLocalFileSeparator(systemPath));
        if (!localFile.exists()) {
            throw new InvalidStateException("The file has been erased", Util.stringToStringArray(systemPath));
        }
        return localFile;
    }

    private Object getChannel(String poaName, String id, TypeCode type) throws InvalidStateException, ServerException {
        Object o = null;
        try {
            POA poa = this._poa().find_POA(poaName, false);
            o = poa.create_reference_with_id(id.getBytes(), type.id());
        }
        catch (UserException ex) {
            throw new InvalidStateException(ex.getMessage(), this.getFullName());
        }
        return o;
    }

    private RemoteFile createRemoteFile(String path) throws InvalidStateException, ServerException {
        Object o = null;
        try {
            o = this._poa().create_reference_with_id(path.getBytes(), RemoteFileHelper.type().id());
        }
        catch (UserException ex) {
            ex.printStackTrace();
            throw new InvalidStateException("Internal misconfiguration problem: " + ex.getMessage(), this.getFullName());
        }
        return RemoteFileHelper.narrow(o);
    }
}

