#!/bin/sh

BASE_DIR=$PWD
LUA51_BIN=/usr/local/bin/lua5.1
SVN_TECENG=https://subversion.tecgraf.puc-rio.br/engdist
SVN_PUTS=$SVN_TECENG/openbus/puts/trunk
SVN_REPO=$SVN_TECENG/openbus/puts/repository
BUILD_DIR=$BASE_DIR/build
BUILD_MODULES="sgad-1.0snapshot"
PUTS_HOME=$BASE_DIR/puts
PUTS_REPO=$BASE_DIR/repository
PUTS_BIN="$LUA51_BIN -epackage.path=[[$PUTS_HOME/lua/?.lua]] $PUTS_HOME/lua/tools/console.lua --config=$BUILD_DIR/puts.conf"

echo "BASEDIR = '$BUILD_DIR'"      > $BUILD_DIR/puts.conf
echo "SPEC_SERVERS={'$PUTS_REPO'}" >> $BUILD_DIR/puts.conf

if [ ! -f $PUTS_HOME ]; then
  svn co $SVN_PUTS $PUTS_HOME
else
  svn update $PUTS_HOME
fi

# if [ ! -f $PUTS_REPO ]; then
#   svn co $SVN_REPO $PUTS_REPO
# else
#   svn update $PUTS_REPO
# fi
$PUTS_BIN --make_manifest $PUTS_REPO

#rm -fr $BUILD_DIR/{install,build,packs}

$PUTS_BIN --compile --verbose --rebuild --update --force \
          --select="$BUILD_MODULES" --dependencies
