/*
 * Decompiled with CFR 0.152.
 */
package csfs.impl.filetracker;

import csfs.impl.filetracker.FileTracker;
import csfs.impl.filetracker.FileTrackerLeasingThread;
import csfs.impl.util.SystemProperties;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Logger;

public class FileTrackerLeasing
extends FileTracker {
    private static FileTracker instance;
    private Hashtable leasing = new Hashtable();
    private FileTrackerLeasingThread clock = new FileTrackerLeasingThread(this, INACTIVITY_LIMIT);
    private static final int INACTIVITY_LIMIT;

    protected FileTrackerLeasing() {
        this.clock.start();
    }

    public static FileTracker getInstance() {
        if (instance == null) {
            instance = new FileTrackerLeasing();
        }
        return instance;
    }

    @Override
    public synchronized void setFileDescriptor(String key, Object fileDescriptor) {
        super.setFileDescriptor(key, fileDescriptor);
        long time = System.currentTimeMillis();
        this.leasing.put(key, new Long(time + (long)INACTIVITY_LIMIT));
    }

    @Override
    public Object getFileDescriptor(String key) {
        Object response = super.getFileDescriptor(key);
        long time = System.currentTimeMillis();
        this.leasing.put(key, new Long(time + (long)INACTIVITY_LIMIT));
        return response;
    }

    @Override
    public synchronized void removeFileDescriptor(String key) {
        super.removeFileDescriptor(key);
        this.leasing.remove(key);
    }

    public synchronized void verifyObjectValidity() {
        long currentTime = System.currentTimeMillis();
        Vector collected = new Vector();
        for (Object key : this.leasing.keySet()) {
            Long value = (Long)this.leasing.get(key);
            if (value >= currentTime) continue;
            collected.add(key);
        }
        for (int i = 0; i < collected.size(); ++i) {
            this.removeFileDescriptor((String)collected.elementAt(i));
        }
        if (collected.size() > 0) {
            Logger.global.info("FileTrackerLeasing decided to collect " + collected.size() + " objects!");
        }
    }

    static {
        INACTIVITY_LIMIT = SystemProperties.getIntProperty("INACTIVITY_LIMIT");
    }
}

