/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.listener;

import org.jacorb.config.Configurable;
import org.jacorb.config.Configuration;
import org.jacorb.orb.iiop.IIOPListener;
import org.jacorb.orb.listener.AcceptorExceptionEvent;
import org.jacorb.orb.listener.AcceptorExceptionListener;
import org.jacorb.util.ObjectUtil;
import org.slf4j.Logger;

public class DefaultAcceptorExceptionListener
implements AcceptorExceptionListener,
Configurable {
    private Class sslException;
    private Logger logger;

    @Override
    public void configure(Configuration configuration) {
        this.sslException = null;
        String exceptionClass = configuration.getAttribute("javax.net.ssl.SSLException", null);
        if (exceptionClass != null) {
            try {
                this.sslException = ObjectUtil.classForName(exceptionClass);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        this.logger = configuration.getLogger("org.jacorb.orb.iiop");
    }

    @Override
    public void exceptionCaught(AcceptorExceptionEvent e) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Caught acceptor event", e.getException());
        }
        if (e.getException() instanceof Error || !((IIOPListener.Acceptor)e.getSource()).getAcceptorSocketLoop() && this.sslException != null && this.sslException.isInstance(e.getException())) {
            this.logger.error("fatal exception. will shutdown orb", e.getException());
            e.getORB().shutdown(true);
        }
    }
}

