/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.imr.util;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.MutableComboBoxModel;
import org.jacorb.imr.util.ImRModel;

public class AddServerWindow
extends JFrame
implements ActionListener,
KeyListener {
    private transient ImRModel m_model;
    private JTextField m_name_tf;
    private JComboBox m_host_box;
    private JTextField m_command_tf;
    private Component host_box_tf = null;
    private JButton m_add_btn;
    private JButton m_cancel_btn;
    private transient Clipboard clip_board = null;

    public AddServerWindow(ImRModel model) {
        super("Add Server");
        this.m_model = model;
        this.clip_board = Toolkit.getDefaultToolkit().getSystemClipboard();
        this.addKeyListener(this);
        JPanel _panel = new JPanel();
        GridBagLayout _gbl = new GridBagLayout();
        GridBagConstraints _constraints = new GridBagConstraints();
        _constraints.fill = 2;
        JLabel _name_lbl = new JLabel("Servername: ");
        this.buildConstraints(_constraints, 0, 0, 1, 1, 1, 1);
        _gbl.setConstraints(_name_lbl, _constraints);
        _panel.add(_name_lbl);
        this.m_name_tf = new JTextField();
        this.m_name_tf.requestFocus();
        this.buildConstraints(_constraints, 1, 0, 1, 1, 100, 1);
        _gbl.setConstraints(this.m_name_tf, _constraints);
        _panel.add(this.m_name_tf);
        JLabel _host_lbl = new JLabel("Host: ");
        this.buildConstraints(_constraints, 0, 1, 1, 1, 1, 1);
        _gbl.setConstraints(_host_lbl, _constraints);
        _panel.add(_host_lbl);
        this.m_host_box = this.m_model.getHostSelector();
        this.buildConstraints(_constraints, 1, 1, 1, 1, 100, 1);
        _gbl.setConstraints(this.m_host_box, _constraints);
        _panel.add(this.m_host_box);
        this.host_box_tf = this.m_host_box.getEditor().getEditorComponent();
        JLabel _cmd_lbl = new JLabel("Command: ");
        this.buildConstraints(_constraints, 0, 2, 1, 1, 1, 1);
        _gbl.setConstraints(_cmd_lbl, _constraints);
        _panel.add(_cmd_lbl);
        this.m_command_tf = new JTextField(30);
        this.buildConstraints(_constraints, 1, 2, 1, 1, 100, 1);
        _gbl.setConstraints(this.m_command_tf, _constraints);
        _panel.add(this.m_command_tf);
        this.m_add_btn = new JButton("Add");
        this.m_add_btn.addActionListener(this);
        this.buildConstraints(_constraints, 0, 3, 1, 1, 1, 1);
        _constraints.fill = 0;
        _gbl.setConstraints(this.m_add_btn, _constraints);
        _panel.add(this.m_add_btn);
        this.m_cancel_btn = new JButton("Cancel");
        this.m_cancel_btn.addActionListener(this);
        this.buildConstraints(_constraints, 1, 3, 1, 1, 1, 1);
        _gbl.setConstraints(this.m_cancel_btn, _constraints);
        _panel.add(this.m_cancel_btn);
        _panel.setLayout(_gbl);
        this.getContentPane().add(_panel);
        this.pack();
        this.setVisible(true);
    }

    private void buildConstraints(GridBagConstraints gbc, int gx, int gy, int gw, int gh, int wx, int wy) {
        gbc.gridx = gx;
        gbc.gridy = gy;
        gbc.gridwidth = gw;
        gbc.gridheight = gh;
        gbc.weightx = wx;
        gbc.weighty = wy;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        JButton _source = (JButton)event.getSource();
        if (_source == this.m_cancel_btn) {
            this.dispose();
        } else if (_source == this.m_add_btn) {
            this.dispose();
            this.m_model.addServer(this.m_name_tf.getText(), this.m_command_tf.getText(), (String)this.m_host_box.getSelectedItem());
        }
    }

    @Override
    public void keyTyped(KeyEvent kevt) {
    }

    @Override
    public void keyPressed(KeyEvent kevt) {
        try {
            if (kevt.getKeyCode() == 65487) {
                Transferable cb_data = this.clip_board.getContents(this);
                String text = (String)cb_data.getTransferData(DataFlavor.stringFlavor);
                if (this.m_name_tf.hasFocus()) {
                    this.m_name_tf.setText(text);
                } else if (this.m_command_tf.hasFocus()) {
                    this.m_command_tf.setText(text);
                } else if (this.host_box_tf.hasFocus()) {
                    MutableComboBoxModel model = (MutableComboBoxModel)this.m_host_box.getModel();
                    model.addElement(text);
                    model.setSelectedItem(text);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void keyReleased(KeyEvent kevt) {
    }
}

