/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.ftc_1_2.server.states;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import tecgraf.ftc_1_2.common.logic.ErrorCode;
import tecgraf.ftc_1_2.common.logic.PrimitiveTypeSize;
import tecgraf.ftc_1_2.server.FileChannelRequestInfo;
import tecgraf.ftc_1_2.server.FileServer;
import tecgraf.ftc_1_2.server.Session;
import tecgraf.ftc_1_2.server.states.GetOperationState;
import tecgraf.ftc_1_2.server.states.State;
import tecgraf.ftc_1_2.utils.IOUtils;

public final class ReadState
implements State {
    static long CHUNK_SIZE = 2048L;
    private InternalState currentState = InternalState.INITIAL;
    private long position;
    private long count;
    private static final Logger logger = Logger.getLogger("tecgraf.ftc");
    public static final long MAX_BYTES = Integer.MAX_VALUE;
    private long bytesSent = 0L;
    private long chunkBytesSent = 0L;
    private long currentChunkSize = 0L;
    private long fileSize = 0L;
    private boolean endOfFile = false;

    public ReadState() {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Estado de leitura.");
        }
    }

    @Override
    public boolean read(Session session) {
        ByteBuffer buffer = session.getBuffer();
        SocketChannel channel = session.getChannel();
        FileChannel fileChannel = session.getFileChannel();
        switch (this.currentState) {
            case INITIAL: {
                buffer.limit(PrimitiveTypeSize.LONG.getSize());
                try {
                    if (channel.read(buffer) > 0) {
                        session.markLastActivity();
                    }
                }
                catch (IOException e) {
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer("Erro ao ler do canal.");
                    }
                    return false;
                }
                if (buffer.hasRemaining()) {
                    return true;
                }
                buffer.flip();
                this.position = buffer.getLong();
                buffer.clear();
                if (this.position < 0L) {
                    try {
                        this.position = fileChannel.position();
                    }
                    catch (Exception e1) {
                        if (logger.isLoggable(Level.FINER)) {
                            logger.finer("Erro ao ler posi\u00e7\u00e3o do arquivo.");
                        }
                        return false;
                    }
                }
                this.currentState = InternalState.POSITION_READ;
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Position " + this.position);
                }
            }
            case POSITION_READ: {
                buffer.limit(PrimitiveTypeSize.LONG.getSize());
                try {
                    if (channel.read(buffer) > 0) {
                        session.markLastActivity();
                    }
                }
                catch (IOException e) {
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer("Erro ao ler do canal.");
                    }
                    return false;
                }
                if (buffer.hasRemaining()) {
                    return true;
                }
                buffer.flip();
                this.count = buffer.getLong();
                buffer.clear();
                this.currentState = InternalState.BYTE_COUNT_READ;
                try {
                    this.fileSize = fileChannel.size();
                }
                catch (IOException e) {
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer("Erro ao ler tamanho do arquivo.");
                    }
                    return false;
                }
                if (!logger.isLoggable(Level.FINER)) break;
                logger.finer("Quantidade pedida " + this.count);
            }
        }
        return true;
    }

    @Override
    public boolean write(Session session) {
        SocketChannel channel = session.getChannel();
        ByteBuffer buffer = session.getBuffer();
        FileChannel fileChannel = session.getFileChannel();
        FileChannelRequestInfo fileInfo = session.getFileChannelInfo();
        switch (this.currentState) {
            case BYTE_COUNT_READ: {
                buffer.clear();
                long bytesLeftOnFile = this.fileSize - (this.position + this.bytesSent);
                if (bytesLeftOnFile <= 0L) {
                    logger.finer("Final do arquivo atingido enviando EOF");
                    buffer.limit(PrimitiveTypeSize.BYTE.getSize());
                    buffer.put(ErrorCode.END_OF_FILE.getCode());
                    buffer.flip();
                    this.endOfFile = true;
                } else {
                    long missingBytes = this.count - this.bytesSent;
                    this.currentChunkSize = missingBytes > CHUNK_SIZE ? CHUNK_SIZE : missingBytes;
                    long l = this.currentChunkSize = this.currentChunkSize > bytesLeftOnFile ? bytesLeftOnFile : this.currentChunkSize;
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer("Enviando chunk de tamanho " + this.currentChunkSize);
                    }
                    buffer.limit(PrimitiveTypeSize.BYTE.getSize() + PrimitiveTypeSize.LONG.getSize());
                    buffer.put(ErrorCode.OK.getCode());
                    buffer.putLong(this.currentChunkSize);
                    buffer.flip();
                }
                this.currentState = InternalState.CHUNK_HEADER_WRITTEN;
            }
            case CHUNK_HEADER_WRITTEN: {
                try {
                    if (channel.write(buffer) > 0) {
                        session.markLastActivity();
                    }
                }
                catch (IOException e) {
                    buffer.clear();
                    session.getFileServer().exceptionRaised(e, session.getFileChannelInfo().getFileId());
                    return false;
                }
                if (buffer.hasRemaining()) {
                    return true;
                }
                buffer.clear();
                if (this.endOfFile) {
                    session.setCurrentState(new GetOperationState());
                    return true;
                }
                this.currentState = InternalState.CHUNK_HEADER_SENT;
            }
            case CHUNK_HEADER_SENT: {
                long bytesToread = this.currentChunkSize - this.chunkBytesSent;
                long bytesWritten = 0L;
                try {
                    if (fileInfo.useTransferTo() && (this.count <= Integer.MAX_VALUE || !FileServer.PLATAFORM_HAS_TRANSFERTO_BUG)) {
                        if (logger.isLoggable(Level.FINEST)) {
                            logger.finest("Using TransferTo");
                        }
                        bytesWritten = fileChannel.transferTo(this.position + this.bytesSent, bytesToread, channel);
                    } else {
                        bytesWritten = IOUtils.transferToNonBlock(fileChannel, this.position + this.bytesSent, bytesToread, channel, buffer);
                        buffer.clear();
                    }
                    if (bytesWritten > 0L) {
                        session.markLastActivity();
                        this.bytesSent += bytesWritten;
                        fileChannel.position(this.position + this.bytesSent);
                    }
                }
                catch (IOException e) {
                    buffer.clear();
                    session.getFileServer().exceptionRaised(e, session.getFileChannelInfo().getFileId());
                    return false;
                }
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("Enviados " + bytesWritten);
                }
                this.chunkBytesSent += bytesWritten;
                if (this.chunkBytesSent == this.currentChunkSize) {
                    this.chunkBytesSent = 0L;
                    this.currentState = InternalState.BYTE_COUNT_READ;
                }
                if (this.bytesSent != this.count) break;
                buffer.clear();
                this.currentState = InternalState.BYTES_SENT;
                session.setCurrentState(new GetOperationState());
            }
        }
        return true;
    }

    private static enum InternalState {
        INITIAL,
        POSITION_READ,
        BYTE_COUNT_READ,
        CHUNK_HEADER_WRITTEN,
        CHUNK_HEADER_SENT,
        BYTES_SENT;

    }
}

