/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.ftc_1_4.server.states.v1_1;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import tecgraf.ftc_1_4.common.logic.ErrorCode;
import tecgraf.ftc_1_4.common.logic.PrimitiveTypeSize;
import tecgraf.ftc_1_4.server.ChannelClosedReason;
import tecgraf.ftc_1_4.server.Session;
import tecgraf.ftc_1_4.server.states.State;

public final class CloseState
implements State {
    private InternalState currentState = InternalState.INITIAL;
    private ErrorCode errorCode = ErrorCode.FAILURE;
    private static final Logger logger = Logger.getLogger("tecgraf.ftc");
    private boolean writing = true;

    public CloseState() {
        this(ErrorCode.FAILURE);
    }

    public CloseState(ErrorCode error) {
        this.errorCode = error;
    }

    @Override
    public boolean read(Session session) {
        return true;
    }

    @Override
    public boolean write(Session session) throws IOException {
        ByteBuffer buffer = session.getBuffer();
        SocketChannel channel = session.getChannel();
        SocketAddress clientAddress = channel.socket().getRemoteSocketAddress();
        switch (this.currentState) {
            case INITIAL: {
                if (session.closeFileChannel(ChannelClosedReason.REQUESTED_BY_CLIENT)) {
                    this.errorCode = ErrorCode.OK;
                }
                buffer.limit(PrimitiveTypeSize.BYTE.getSize());
                buffer.put(this.errorCode.getCode());
                buffer.flip();
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest(String.format("Close data channel result (%s) written into buffer to connection %s", new Object[]{this.errorCode, clientAddress}));
                }
                this.currentState = InternalState.CHANNEL_CLOSED;
            }
            case CHANNEL_CLOSED: {
                if (channel.write(buffer) > 0) {
                    session.markLastActivity();
                }
                if (buffer.hasRemaining()) {
                    return true;
                }
                this.writing = false;
                buffer.clear();
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest(String.format("Close data channel result (%s) sent successfully to %s", new Object[]{this.errorCode, clientAddress}));
                }
                session.setCurrentState(null);
                channel.close();
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isWriting() {
        return this.writing;
    }

    private static enum InternalState {
        INITIAL,
        CHANNEL_CLOSED;

    }
}

