/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.ftc_1_4.server.states.v1_1;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import tecgraf.ftc_1_4.common.IDataChannel;
import tecgraf.ftc_1_4.common.exception.DataChannelException;
import tecgraf.ftc_1_4.common.logic.PrimitiveTypeSize;
import tecgraf.ftc_1_4.server.FileServer;
import tecgraf.ftc_1_4.server.Session;
import tecgraf.ftc_1_4.server.states.State;
import tecgraf.ftc_1_4.server.states.v1_1.GetOperationState;

public final class ReadState
implements State {
    private InternalState currentState = InternalState.INITIAL;
    private long position;
    private long count;
    private boolean readUsesTransferTo = false;
    private static final Logger logger = Logger.getLogger("tecgraf.ftc");
    public static final long MAX_BYTES = Integer.MAX_VALUE;
    private long bytesSent = 0L;
    private boolean writing = false;

    @Override
    public boolean read(Session session) throws IOException {
        ByteBuffer buffer = session.getBuffer();
        SocketChannel channel = session.getChannel();
        IDataChannel dataChannel = session.getFileChannel();
        SocketAddress clientAddress = channel.socket().getRemoteSocketAddress();
        switch (this.currentState) {
            case INITIAL: {
                buffer.limit(PrimitiveTypeSize.LONG.getSize());
                if (channel.read(buffer) < 0) {
                    return false;
                }
                session.markLastActivity();
                if (buffer.hasRemaining()) {
                    return true;
                }
                buffer.flip();
                this.position = buffer.getLong();
                buffer.clear();
                this.currentState = InternalState.POSITION_READ;
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest(String.format("Read operation of connection %s starts at position %d", clientAddress, this.position));
                }
            }
            case POSITION_READ: {
                buffer.limit(PrimitiveTypeSize.LONG.getSize());
                if (channel.read(buffer) < 0) {
                    return false;
                }
                session.markLastActivity();
                if (buffer.hasRemaining()) {
                    return true;
                }
                buffer.flip();
                this.count = buffer.getLong();
                buffer.clear();
                this.readUsesTransferTo = (dataChannel.supportedOperations() & 0x80) != 0 && session.getFileChannelInfo().useTransferTo() && (this.count <= Integer.MAX_VALUE || !FileServer.PLATAFORM_HAS_TRANSFERTO_BUG);
                this.currentState = InternalState.BYTE_COUNT_READ;
                this.writing = true;
                buffer.limit(0);
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest(String.format("Read operation of connection %s requested %d bytes", clientAddress, this.count));
                }
                return true;
            }
        }
        return true;
    }

    @Override
    public boolean write(Session session) throws IOException, DataChannelException {
        SocketChannel channel = session.getChannel();
        SocketAddress clientAddress = channel.socket().getRemoteSocketAddress();
        switch (this.currentState) {
            case BYTE_COUNT_READ: {
                ByteBuffer buffer = session.getBuffer();
                IDataChannel fileChannel = session.getFileChannel();
                long bytesToRead = this.count - this.bytesSent;
                long bytesWritten = this.transferBytesToSocket(fileChannel, channel, buffer, bytesToRead);
                if (bytesWritten < 0L) {
                    return false;
                }
                session.markLastActivity();
                this.bytesSent += bytesWritten;
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(String.format("Read operation statistics of connection %s: %d bytes written, %d bytes sent and %d total expected", clientAddress, bytesWritten, this.bytesSent, this.count));
                }
                if (this.bytesSent == this.count) {
                    this.writing = false;
                    buffer.clear();
                    this.currentState = InternalState.BYTES_SENT;
                    session.setCurrentState(new GetOperationState());
                }
                return true;
            }
        }
        return true;
    }

    private long transferBytesToSocket(IDataChannel byteChannel, SocketChannel channel, ByteBuffer buffer, long bytesToRead) throws IOException, DataChannelException {
        long bytesWritten = -1L;
        if (this.readUsesTransferTo) {
            logger.finest(String.format("Read operation using transferTo for connection %s", channel.socket().getRemoteSocketAddress()));
            if (this.position == -1L) {
                this.position = byteChannel.getPosition();
            }
            bytesWritten = byteChannel.transferTo(this.position + this.bytesSent, bytesToRead, channel);
        } else if (buffer.hasRemaining()) {
            bytesWritten = channel.write(buffer);
        } else {
            int bytesRead;
            if (this.position >= 0L) {
                byteChannel.setPosition(this.position + this.bytesSent);
            }
            buffer.clear();
            if ((long)buffer.remaining() > bytesToRead) {
                buffer.limit((int)bytesToRead);
            }
            if ((bytesRead = byteChannel.read(buffer)) == -1) {
                return -1L;
            }
            buffer.flip();
            bytesWritten = channel.write(buffer);
        }
        return bytesWritten;
    }

    @Override
    public boolean isWriting() {
        return this.writing;
    }

    private static enum InternalState {
        INITIAL,
        POSITION_READ,
        BYTE_COUNT_READ,
        BYTES_SENT;

    }
}

