/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.ftc_1_4.server.states.v1_2;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import tecgraf.ftc_1_4.common.IDataChannel;
import tecgraf.ftc_1_4.common.exception.DataChannelException;
import tecgraf.ftc_1_4.common.logic.ErrorCode;
import tecgraf.ftc_1_4.common.logic.PrimitiveTypeSize;
import tecgraf.ftc_1_4.server.FileServer;
import tecgraf.ftc_1_4.server.Session;
import tecgraf.ftc_1_4.server.states.State;
import tecgraf.ftc_1_4.server.states.v1_2.GetOperationState;

public final class ReadState
implements State {
    private InternalState currentState = InternalState.INITIAL;
    private ErrorCode errorCode;
    private long position;
    private long count;
    private boolean readUsesTransferTo = false;
    private static final Logger logger = Logger.getLogger("tecgraf.ftc");
    public static final long MAX_BYTES = Integer.MAX_VALUE;
    private long bytesSent = 0L;
    private long chunkBytesSent = 0L;
    private long currentChunkSize = 0L;
    private boolean changeState = false;
    private boolean writing = false;

    @Override
    public boolean read(Session session) throws IOException {
        ByteBuffer buffer = session.getBuffer();
        SocketChannel channel = session.getChannel();
        IDataChannel dataChannel = session.getFileChannel();
        SocketAddress clientAddress = channel.socket().getRemoteSocketAddress();
        switch (this.currentState) {
            case INITIAL: {
                buffer.limit(PrimitiveTypeSize.LONG.getSize());
                if (channel.read(buffer) < 0) {
                    return false;
                }
                session.markLastActivity();
                if (buffer.hasRemaining()) {
                    return true;
                }
                buffer.flip();
                this.position = buffer.getLong();
                buffer.clear();
                this.currentState = InternalState.POSITION_READ;
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest(String.format("Read operation of connection %s starts at position %d", clientAddress, this.position));
                }
            }
            case POSITION_READ: {
                buffer.limit(PrimitiveTypeSize.LONG.getSize());
                if (channel.read(buffer) < 0) {
                    return false;
                }
                session.markLastActivity();
                if (buffer.hasRemaining()) {
                    return true;
                }
                buffer.flip();
                this.count = buffer.getLong();
                buffer.clear();
                this.readUsesTransferTo = (dataChannel.supportedOperations() & 0x80) != 0 && session.getFileChannelInfo().useTransferTo() && (this.count <= Integer.MAX_VALUE || !FileServer.PLATAFORM_HAS_TRANSFERTO_BUG);
                this.currentState = InternalState.BYTE_COUNT_READ;
                this.writing = true;
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest(String.format("Read operation of connection %s requested %d bytes", clientAddress, this.count));
                }
                return true;
            }
        }
        return true;
    }

    @Override
    public boolean write(Session session) throws IOException, DataChannelException {
        SocketChannel channel = session.getChannel();
        ByteBuffer buffer = session.getBuffer();
        IDataChannel byteChannel = session.getFileChannel();
        SocketAddress clientAddress = channel.socket().getRemoteSocketAddress();
        switch (this.currentState) {
            case BYTE_COUNT_READ: {
                this.errorCode = ErrorCode.FAILURE;
                buffer.clear();
                short operations = byteChannel.supportedOperations();
                if ((operations & 0x10) == 0 || this.position != -1L && (operations & 8) == 0) {
                    buffer.limit(PrimitiveTypeSize.BYTE.getSize());
                    buffer.put(this.errorCode.getCode());
                    buffer.flip();
                    this.changeState = true;
                } else {
                    if (this.position >= 0L) {
                        byteChannel.setPosition(this.position + this.bytesSent);
                    }
                    this.changeState = this.createChunkHeader(session, buffer, byteChannel);
                }
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest(String.format("Read operation result (%s) written into buffer to connection %s", new Object[]{this.errorCode, clientAddress}));
                }
                this.currentState = InternalState.CHUNK_HEADER_WRITTEN;
            }
            case CHUNK_HEADER_WRITTEN: {
                if (channel.write(buffer) > 0) {
                    session.markLastActivity();
                }
                if (buffer.hasRemaining()) {
                    return true;
                }
                buffer.clear();
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest(String.format("Read operation result (%s) sent successfully to %s", new Object[]{this.errorCode, clientAddress}));
                }
                if (this.changeState) {
                    session.setCurrentState(new GetOperationState());
                    return true;
                }
                buffer.limit(0);
                this.currentState = InternalState.CHUNK_HEADER_SENT;
            }
            case CHUNK_HEADER_SENT: {
                long bytesToRead = this.currentChunkSize - this.chunkBytesSent;
                long bytesWritten = this.transferBytesToSocket(byteChannel, channel, buffer, bytesToRead);
                if (bytesWritten > 0L) {
                    session.markLastActivity();
                    this.bytesSent += bytesWritten;
                }
                if (bytesWritten == -1L) {
                    return true;
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(String.format("Read operation statistics of connection %s: %d bytes written, %d bytes sent and %d total expected", clientAddress, bytesWritten, this.bytesSent, this.count));
                }
                this.chunkBytesSent += bytesWritten;
                if (this.chunkBytesSent == this.currentChunkSize) {
                    buffer.clear();
                    this.chunkBytesSent = 0L;
                    this.currentState = InternalState.BYTE_COUNT_READ;
                }
                if (this.bytesSent == this.count) {
                    this.writing = false;
                    buffer.clear();
                    this.currentState = InternalState.BYTES_SENT;
                    session.setCurrentState(new GetOperationState());
                }
                return true;
            }
        }
        return true;
    }

    private boolean createChunkHeader(Session session, ByteBuffer buffer, IDataChannel dataChannel) throws IOException, DataChannelException {
        boolean returnValue = false;
        long bytesLeftOnFile = dataChannel.remaining();
        if (bytesLeftOnFile < 0L) {
            this.errorCode = ErrorCode.END_OF_FILE;
            buffer.limit(PrimitiveTypeSize.BYTE.getSize());
            buffer.put(this.errorCode.getCode());
            buffer.flip();
            returnValue = true;
        } else {
            long missingBytes = this.count - this.bytesSent;
            this.currentChunkSize = Math.min(Math.min(missingBytes, (long)session.getFileServer().getConfig().getChunkSize()), bytesLeftOnFile);
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(String.format("Read operation using chunk size of %d bytes to send data to connection %s", this.currentChunkSize, session.getChannel().socket().getRemoteSocketAddress()));
            }
            this.errorCode = ErrorCode.OK;
            buffer.limit(PrimitiveTypeSize.BYTE.getSize() + PrimitiveTypeSize.LONG.getSize());
            buffer.put(this.errorCode.getCode());
            buffer.putLong(this.currentChunkSize);
            buffer.flip();
        }
        return returnValue;
    }

    private long transferBytesToSocket(IDataChannel byteChannel, SocketChannel channel, ByteBuffer buffer, long bytesToRead) throws IOException, UnsupportedOperationException, DataChannelException {
        long bytesWritten = -1L;
        if (this.readUsesTransferTo) {
            logger.finest(String.format("Read operation using transferTo for connection %s", channel.socket().getRemoteSocketAddress()));
            if (this.position == -1L) {
                this.position = byteChannel.getPosition();
            }
            bytesWritten = byteChannel.transferTo(this.position + this.bytesSent, bytesToRead, channel);
        } else if (buffer.hasRemaining()) {
            bytesWritten = channel.write(buffer);
        } else {
            int bytesRead;
            if (this.position >= 0L) {
                byteChannel.setPosition(this.position + this.bytesSent);
            }
            buffer.clear();
            if ((long)buffer.remaining() > bytesToRead) {
                buffer.limit((int)bytesToRead);
            }
            if ((bytesRead = byteChannel.read(buffer)) == -1) {
                return -1L;
            }
            buffer.flip();
            bytesWritten = channel.write(buffer);
        }
        return bytesWritten;
    }

    @Override
    public boolean isWriting() {
        return this.writing;
    }

    private static enum InternalState {
        INITIAL,
        POSITION_READ,
        BYTE_COUNT_READ,
        CHUNK_HEADER_WRITTEN,
        CHUNK_HEADER_SENT,
        BYTES_SENT;

    }
}

