/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.ftc_1_4.server.states.v1_4;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import tecgraf.ftc_1_4.common.IDataChannel;
import tecgraf.ftc_1_4.common.logic.ErrorCode;
import tecgraf.ftc_1_4.common.logic.PrimitiveTypeSize;
import tecgraf.ftc_1_4.common.logic.ResultMessage;
import tecgraf.ftc_1_4.server.ErrorMessages;
import tecgraf.ftc_1_4.server.Session;
import tecgraf.ftc_1_4.server.states.State;
import tecgraf.ftc_1_4.server.states.StateUtil;
import tecgraf.ftc_1_4.server.states.v1_4.GetOperationState;

public final class SetPositionState
implements State {
    private InternalState currentState = InternalState.INITIAL;
    private long position;
    private ResultMessage result = new ResultMessage();
    private static final Logger logger = Logger.getLogger("tecgraf.ftc");
    private boolean writing = false;

    @Override
    public boolean read(Session session) throws IOException {
        ByteBuffer buffer = session.getBuffer();
        SocketChannel channel = session.getChannel();
        SocketAddress clientAddress = channel.socket().getRemoteSocketAddress();
        switch (this.currentState) {
            case INITIAL: {
                buffer.limit(PrimitiveTypeSize.LONG.getSize());
                if (channel.read(buffer) < 0) {
                    return false;
                }
                session.markLastActivity();
                if (buffer.hasRemaining()) {
                    return true;
                }
                buffer.flip();
                this.position = buffer.getLong();
                buffer.clear();
                this.writing = true;
                IDataChannel byteChannel = session.getFileChannel();
                if ((byteChannel.supportedOperations() & 8) == 0) {
                    if (logger.isLoggable(Level.WARNING)) {
                        logger.warning(String.format("SET_POSITION operation requested by %s is not supported on data channel for fileId %s", clientAddress, ErrorMessages.hexString(session.getFileChannelInfo().getFileId())));
                    }
                    this.result.code = ErrorCode.UNSUPPORTED_OPERATION;
                } else {
                    try {
                        if (logger.isLoggable(Level.FINEST)) {
                            logger.finest(String.format("Set position operation (value: %d) received successfully from %s", this.position, clientAddress));
                        }
                        byteChannel.setPosition(this.position);
                        this.result.success = true;
                    }
                    catch (Exception e) {
                        byte[] fileId = session.getFileChannelInfo().getFileId();
                        if (logger.isLoggable(Level.SEVERE)) {
                            logger.log(Level.SEVERE, String.format("Failed to change data channel position (connection %s) for fileId %s", clientAddress, ErrorMessages.hexString(fileId)), e);
                        }
                        session.getFileServer().exceptionRaised(e, fileId);
                        this.result.code = ErrorCode.FAILURE;
                        this.result.message = e.getMessage();
                    }
                }
                this.currentState = InternalState.POSITION_READ;
                return true;
            }
        }
        return true;
    }

    @Override
    public boolean write(Session session) throws IOException {
        ByteBuffer buffer = session.getBuffer();
        SocketChannel channel = session.getChannel();
        SocketAddress clientAddress = channel.socket().getRemoteSocketAddress();
        switch (this.currentState) {
            case POSITION_READ: {
                StateUtil.writeResultMessage(buffer, this.result);
                buffer.flip();
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest(String.format("Set position operation result (%s) written into buffer to connection %s", this.result, clientAddress));
                }
                this.currentState = InternalState.RESULT_MESSAGE_WRITTEN;
            }
            case RESULT_MESSAGE_WRITTEN: {
                if (channel.write(buffer) > 0) {
                    session.markLastActivity();
                }
                if (buffer.hasRemaining()) {
                    return true;
                }
                this.writing = false;
                buffer.clear();
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest(String.format("Set position operation result (%s) sent successfully to %s", this.result, clientAddress));
                }
                session.setCurrentState(new GetOperationState());
                return true;
            }
        }
        return true;
    }

    @Override
    public boolean isWriting() {
        return this.writing;
    }

    private static enum InternalState {
        INITIAL,
        POSITION_READ,
        RESULT_MESSAGE_WRITTEN;

    }
}

