/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.ftc_1_4.server;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.SocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import tecgraf.ftc_1_4.common.exception.InvalidArraySize;
import tecgraf.ftc_1_4.server.AccessKey;
import tecgraf.ftc_1_4.server.ChannelClosedReason;
import tecgraf.ftc_1_4.server.DataChannelProvider;
import tecgraf.ftc_1_4.server.ErrorMessages;
import tecgraf.ftc_1_4.server.FileChannelAccessInfo;
import tecgraf.ftc_1_4.server.FileChannelRequestInfo;
import tecgraf.ftc_1_4.server.FileServerConfig;
import tecgraf.ftc_1_4.server.FileServerConfigImpl;
import tecgraf.ftc_1_4.server.FileServerExceptionHandler;
import tecgraf.ftc_1_4.server.MaxChannelRequestsException;
import tecgraf.ftc_1_4.server.Session;
import tecgraf.ftc_1_4.server.states.State;

public final class FileServer {
    public static final int FILEID_MAX_LENGTH = 255;
    private DataChannelProvider fileProvider;
    private volatile boolean wasStopped;
    protected boolean initialized = false;
    private Selector selector;
    private Map<AccessKey, FileChannelRequestInfo> channels;
    private FileServerConfig config = null;
    private ServerSocketChannel serverChannel = null;
    SelectionKey serverKey = null;
    private long lastTimeoutCheck = 0L;
    private FileServerExceptionHandler exceptionHandler = null;
    private static final Logger logger = Logger.getLogger("tecgraf.ftc");
    public static final boolean PLATAFORM_HAS_TRANSFERTO_BUG = System.getProperty("os.name").contains("Linux") && System.getProperty("sun.arch.data.model").contains("32") && !System.getProperty("java.version").contains("1.7.0");

    public FileServer(DataChannelProvider fileProvider) throws IOException {
        this.fileProvider = fileProvider;
        this.config = new FileServerConfigImpl();
        this.channels = new HashMap<AccessKey, FileChannelRequestInfo>();
    }

    public DataChannelProvider getDataProvider() {
        return this.fileProvider;
    }

    public boolean serverSetup() {
        if (!this.initialized) {
            try {
                this.serverChannel = ServerSocketChannel.open();
                this.serverChannel.configureBlocking(false);
                ServerSocket serverSocket = this.serverChannel.socket();
                serverSocket.bind(new InetSocketAddress(this.config.getHostName(), this.config.getPort()));
                this.selector = Selector.open();
                this.serverKey = this.serverChannel.register(this.selector, 16);
            }
            catch (Exception e) {
                this.serverKey = null;
                this.selector = null;
                this.serverChannel = null;
                if (logger.isLoggable(Level.SEVERE)) {
                    logger.log(Level.SEVERE, "Failed attempting to register the server socket selector", e);
                }
                this.exceptionRaised(e);
                return false;
            }
            if (logger.isLoggable(Level.INFO)) {
                logger.info(String.format("FTC server listening at %s:%d", this.config.getHostName(), this.serverChannel.socket().getLocalPort()));
            }
            this.initialized = true;
        }
        return this.initialized;
    }

    public void dispatch() {
        if (!this.serverSetup()) {
            return;
        }
        while (!this.wasStopped) {
            this.select();
        }
        this.shutdownConnections();
    }

    private void select() {
        try {
            int selectedKeyCount = this.selector.select(this.config.getSelectTimeout());
            this.checkTimedOutConnections();
            if (selectedKeyCount == 0) {
                return;
            }
        }
        catch (IOException e) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "Failed attempting to select sockets ready for I/O operations", e);
            }
            this.exceptionRaised(e);
            return;
        }
        Iterator<SelectionKey> selectedKeys = this.selector.selectedKeys().iterator();
        while (selectedKeys.hasNext()) {
            SelectionKey key = selectedKeys.next();
            selectedKeys.remove();
            if (!key.isValid()) continue;
            if (this.serverKey.equals(key)) {
                if (!key.isAcceptable()) continue;
                this.accept(key);
                continue;
            }
            this.read(key);
            if (key.isValid() && key.isWritable()) {
                this.write(key);
            }
            Session session = (Session)key.attachment();
            if (!key.isValid() || !session.isValid()) continue;
            int ops = 1;
            if (session.isWriting()) {
                ops |= 4;
            }
            key.interestOps(ops);
        }
    }

    private synchronized void checkTimedOutConnections() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastTimeoutCheck < this.config.getSelectTimeout()) {
            return;
        }
        this.lastTimeoutCheck = currentTime;
        Set<SelectionKey> keys = this.selector.keys();
        for (SelectionKey key : keys) {
            long test;
            Session session = (Session)key.attachment();
            if (session == null || (test = currentTime - session.getLastActivity()) <= this.config.getClientTimeout()) continue;
            if (logger.isLoggable(Level.WARNING)) {
                logger.warning(String.format("Connection to %s will be closed due to inactivity timeout of %d miliseconds", session.getChannel().socket().getRemoteSocketAddress(), this.config.getClientTimeout()));
            }
            this.stopConnection(key, session, ChannelClosedReason.CHANNEL_TIMEOUT);
        }
        Set<Map.Entry<AccessKey, FileChannelRequestInfo>> channelSet = this.channels.entrySet();
        Iterator<Map.Entry<AccessKey, FileChannelRequestInfo>> iter = channelSet.iterator();
        while (iter.hasNext()) {
            Map.Entry<AccessKey, FileChannelRequestInfo> entry = iter.next();
            FileChannelRequestInfo requestInfo = entry.getValue();
            long test = currentTime - requestInfo.getCreationTime();
            if (test <= this.config.getChannelRequestTimeout()) continue;
            if (logger.isLoggable(Level.WARNING)) {
                logger.warning(String.format("Channel request for access key %s will be discarded due to timeout of %d miliseconds", entry.getKey(), this.config.getChannelRequestTimeout()));
            }
            iter.remove();
        }
    }

    private void shutdownConnections() {
        block5: {
            if (logger.isLoggable(Level.INFO)) {
                logger.info("FTC server is shutting down and will close all connections");
            }
            for (SelectionKey key : this.selector.keys()) {
                Session session = (Session)key.attachment();
                this.stopConnection(key, session, ChannelClosedReason.SERVER_SHUTDOWN);
            }
            try {
                this.selector.close();
            }
            catch (IOException e) {
                if (!logger.isLoggable(Level.WARNING)) break block5;
                logger.log(Level.WARNING, "Failed attempting to close the server socket selector", e);
            }
        }
        this.serverChannel = null;
        if (logger.isLoggable(Level.INFO)) {
            logger.info("FTC server shutdown completed");
        }
    }

    public void stop() {
        this.wasStopped = true;
    }

    public FileChannelAccessInfo createFileChannelInfo(Object requester, byte[] fileId) throws InvalidArraySize, MaxChannelRequestsException {
        return this.createFileChannelInfo(requester, fileId, null);
    }

    public FileChannelAccessInfo createFileChannelInfo(Object requester, byte[] fileId, byte[] accessKey) throws InvalidArraySize, MaxChannelRequestsException {
        return this.createFileChannelInfo(requester, fileId, accessKey, true);
    }

    public synchronized FileChannelAccessInfo createFileChannelInfo(Object requester, byte[] fileId, byte[] accessKey, boolean useTransferTo) throws InvalidArraySize, MaxChannelRequestsException {
        if (fileId == null) {
            throw new IllegalArgumentException("fileId cannot be null");
        }
        if (fileId.length > 255) {
            throw new InvalidArraySize(String.format("%s length %d exceed the maximum of %d bytes", "file id", fileId.length, 255));
        }
        if (this.channels.size() + 1 > this.config.getMaxChannelRequests()) {
            throw new MaxChannelRequestsException("reached the maximum of " + this.config.getMaxChannelRequests() + " pending channel requests");
        }
        AccessKey key = accessKey != null ? new AccessKey(accessKey) : new AccessKey();
        FileChannelRequestInfo fileChannelIinfo = new FileChannelRequestInfo(requester, fileId);
        fileChannelIinfo.useTransferTo(useTransferTo);
        this.channels.put(key, fileChannelIinfo);
        if (logger.isLoggable(Level.INFO)) {
            logger.info(String.format("Channel request registered at %d timestamp for access key %s and fileId %s", fileChannelIinfo.getCreationTime(), key, ErrorMessages.hexString(fileId)));
        }
        return new FileChannelAccessInfo(this.config.getHostName(), this.serverChannel.socket().getLocalPort(), key.getBytes(), fileId);
    }

    public synchronized FileChannelRequestInfo removeFileChannelInfo(AccessKey key) {
        FileChannelRequestInfo result = this.channels.remove(key);
        if (result != null && logger.isLoggable(Level.INFO)) {
            logger.info(String.format("Channel request discarded at %d timestamp for access key %s and fileId %s", System.currentTimeMillis(), key, ErrorMessages.hexString(result.getFileId())));
        }
        return result;
    }

    public synchronized FileChannelRequestInfo getFileChannelInfo(AccessKey accessKey) {
        if (this.config.isTestMode()) {
            return this.channels.get(accessKey);
        }
        return this.channels.remove(accessKey);
    }

    public void exceptionRaised(Exception e, byte[] fileId) {
        if (this.exceptionHandler != null) {
            this.exceptionHandler.exceptionRaised(e, fileId);
        }
    }

    public void exceptionRaised(Exception e) {
        if (this.exceptionHandler != null) {
            this.exceptionHandler.exceptionRaised(e);
        }
    }

    private void accept(SelectionKey key) {
        SocketChannel socketChannel;
        block14: {
            ServerSocketChannel serverChannel = (ServerSocketChannel)key.channel();
            socketChannel = null;
            try {
                while ((socketChannel = serverChannel.accept()) != null) {
                    socketChannel.configureBlocking(false);
                    Session session = new Session(socketChannel, this);
                    session.markLastActivity();
                    socketChannel.register(this.selector, 1, session);
                    SocketAddress clientAddress = socketChannel.socket().getRemoteSocketAddress();
                    int clients = this.selector.keys().size() - 1;
                    if (clients > this.config.getMaxClients()) {
                        if (logger.isLoggable(Level.WARNING)) {
                            logger.warning(String.format("Refusing connection from %s because server reached the maximum of %d clients", clientAddress, this.config.getMaxClients()));
                        }
                        session.setMaxClientsReached(true);
                        break;
                    }
                    if (logger.isLoggable(Level.INFO)) {
                        logger.info(String.format("Client connected %s (%d of %d allowed)", clientAddress, clients, this.config.getMaxClients()));
                    }
                    if (this.config.acceptMaxPossible()) continue;
                    break;
                }
                return;
            }
            catch (IOException e) {
                if (logger.isLoggable(Level.SEVERE)) {
                    StringBuilder details = new StringBuilder();
                    if (socketChannel != null) {
                        details.append(" of client ");
                        details.append(socketChannel.socket().getRemoteSocketAddress());
                    }
                    logger.log(Level.SEVERE, String.format("Failed accepting connection%s", details.toString()), e);
                }
                this.exceptionRaised(e);
            }
            catch (OutOfMemoryError e) {
                if (!logger.isLoggable(Level.SEVERE)) break block14;
                logger.log(Level.SEVERE, "No resources available", e);
            }
        }
        if (socketChannel != null) {
            SocketAddress clientAddress = socketChannel.socket().getRemoteSocketAddress();
            try {
                socketChannel.close();
                if (logger.isLoggable(Level.WARNING)) {
                    logger.warning(String.format("Discarding connection of client %s after server failure", clientAddress));
                }
            }
            catch (IOException e) {
                if (logger.isLoggable(Level.SEVERE)) {
                    logger.log(Level.SEVERE, String.format("Failed to close connection %s after server failure", clientAddress), e);
                }
                this.exceptionRaised(e);
            }
        }
    }

    private void read(SelectionKey key) {
        Session session = (Session)key.attachment();
        State currentState = null;
        try {
            currentState = session.getCurrentState();
            if (currentState == null || !currentState.read(session)) {
                if (logger.isLoggable(Level.WARNING)) {
                    logger.warning(String.format("Connection to %s will be closed due to channel error in %s", this.getAddress(session), this.getStateId(currentState)));
                }
                this.stopConnection(key, session, ChannelClosedReason.CHANNEL_ERROR);
            }
        }
        catch (Exception e) {
            String currentStateId = this.getStateId(currentState);
            if (session != null && session.getFileChannelInfo() != null) {
                byte[] fileId = session.getFileChannelInfo().getFileId();
                if (logger.isLoggable(Level.SEVERE)) {
                    logger.log(Level.SEVERE, String.format("Unexpected exception during read operation of %s state (connection %s) for fileId %s", currentStateId, session.getChannel().socket().getRemoteSocketAddress(), ErrorMessages.hexString(fileId)), e);
                }
                this.exceptionRaised(e, fileId);
            } else {
                if (logger.isLoggable(Level.SEVERE)) {
                    logger.log(Level.SEVERE, String.format("Unexpected exception during read operation of %s state (connection %s)", currentStateId, this.getAddress(session)), e);
                }
                this.exceptionRaised(e);
            }
            this.stopConnection(key, session, ChannelClosedReason.CHANNEL_ERROR);
        }
    }

    private void write(SelectionKey key) {
        Session session = (Session)key.attachment();
        State currentState = null;
        try {
            currentState = session.getCurrentState();
            if (currentState == null || !currentState.write(session)) {
                if (logger.isLoggable(Level.WARNING)) {
                    logger.warning(String.format("Connection to %s will be closed due to channel error in %s", this.getAddress(session), this.getStateId(currentState)));
                }
                this.stopConnection(key, session, ChannelClosedReason.CHANNEL_ERROR);
            }
        }
        catch (Exception e) {
            String currentStateId = this.getStateId(currentState);
            if (session != null && session.getFileChannelInfo() != null) {
                byte[] fileId = session.getFileChannelInfo().getFileId();
                if (logger.isLoggable(Level.SEVERE)) {
                    logger.log(Level.SEVERE, String.format("Unexpected exception during write operation of %s state (connection %s) for fileId %s", currentStateId, session.getChannel().socket().getRemoteSocketAddress(), ErrorMessages.hexString(fileId)), e);
                }
                this.exceptionRaised(e, fileId);
            } else {
                if (logger.isLoggable(Level.SEVERE)) {
                    logger.log(Level.SEVERE, String.format("Unexpected exception during write operation of %s state (connection %s)", currentStateId, this.getAddress(session)), e);
                }
                this.exceptionRaised(e);
            }
            this.stopConnection(key, session, ChannelClosedReason.CHANNEL_ERROR);
        }
    }

    private String getStateId(State currentState) {
        return currentState != null ? currentState.getClass().getCanonicalName() : "<unknown>";
    }

    private String getAddress(Session session) {
        return session != null ? session.getChannel().socket().getRemoteSocketAddress().toString() : "<no client attached>";
    }

    private void stopConnection(SelectionKey key, Session session, ChannelClosedReason reason) {
        if (session != null) {
            session.close(reason);
        } else {
            try {
                key.channel().close();
            }
            catch (IOException e) {
                if (logger.isLoggable(Level.WARNING)) {
                    logger.log(Level.WARNING, String.format("Failed to close connection %s after server failure", "<no session associated>"), e);
                }
                this.exceptionRaised(e);
            }
        }
        key.attach(null);
        key.cancel();
    }

    public FileServerConfig getConfig() {
        return this.config;
    }

    public void setConfig(FileServerConfig config) {
        this.config = config;
    }

    public FileServerExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public void setExceptionHandler(FileServerExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }
}

