/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.ftc_1_4.server.states.v1_2;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import tecgraf.ftc_1_4.common.logic.ErrorCode;
import tecgraf.ftc_1_4.common.logic.PrimitiveTypeSize;
import tecgraf.ftc_1_4.server.Session;
import tecgraf.ftc_1_4.server.states.State;
import tecgraf.ftc_1_4.server.states.v1_2.GetOperationState;

public class KeepAliveState
implements State {
    private InternalState currentState = InternalState.INITIAL;
    private static final Logger logger = Logger.getLogger("tecgraf.ftc");
    private boolean writing = true;

    @Override
    public boolean read(Session session) {
        return true;
    }

    @Override
    public boolean write(Session session) throws IOException {
        ByteBuffer buffer = session.getBuffer();
        SocketChannel channel = session.getChannel();
        switch (this.currentState) {
            case INITIAL: {
                buffer.limit(PrimitiveTypeSize.BYTE.getSize());
                buffer.put(ErrorCode.OK.getCode());
                buffer.flip();
                this.currentState = InternalState.RETURN_MSG_WRITTEN;
            }
            case RETURN_MSG_WRITTEN: {
                if (channel.write(buffer) > 0) {
                    session.markLastActivity();
                }
                if (buffer.hasRemaining()) {
                    return true;
                }
                this.writing = false;
                buffer.clear();
                if (logger.isLoggable(Level.FINEST)) {
                    SocketAddress clientAddress = channel.socket().getRemoteSocketAddress();
                    logger.finest(String.format("Keep alive operation result (%s) sent successfully to %s", new Object[]{ErrorCode.OK, clientAddress}));
                }
                session.setCurrentState(new GetOperationState());
                return true;
            }
        }
        return true;
    }

    @Override
    public boolean isWriting() {
        return this.writing;
    }

    private static enum InternalState {
        INITIAL,
        RETURN_MSG_WRITTEN;

    }
}

