/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.ftc_1_4.server.states.v1_4;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import tecgraf.ftc_1_4.common.IDataChannel;
import tecgraf.ftc_1_4.common.exception.DataChannelException;
import tecgraf.ftc_1_4.common.logic.ErrorCode;
import tecgraf.ftc_1_4.common.logic.PrimitiveTypeSize;
import tecgraf.ftc_1_4.common.logic.ResultMessage;
import tecgraf.ftc_1_4.server.FileChannelRequestInfo;
import tecgraf.ftc_1_4.server.Session;
import tecgraf.ftc_1_4.server.states.State;
import tecgraf.ftc_1_4.server.states.StateUtil;
import tecgraf.ftc_1_4.server.states.v1_4.GetOperationState;

public final class WriteState
implements State {
    private InternalState currentState = InternalState.INITIAL;
    private long position;
    private long count;
    private long bytesReceived;
    private boolean writeUseTransferFrom = false;
    private ResultMessage result = new ResultMessage();
    private static final Logger logger = Logger.getLogger("tecgraf.ftc");
    private boolean writing = false;

    @Override
    public boolean read(Session session) throws IOException, DataChannelException {
        ByteBuffer buffer = session.getBuffer();
        SocketChannel channel = session.getChannel();
        IDataChannel byteChannel = session.getFileChannel();
        switch (this.currentState) {
            case INITIAL: {
                buffer.limit(PrimitiveTypeSize.LONG.getSize());
                if (channel.read(buffer) < 0) {
                    return false;
                }
                session.markLastActivity();
                if (buffer.hasRemaining()) {
                    return true;
                }
                buffer.flip();
                this.position = buffer.getLong();
                buffer.clear();
                this.currentState = InternalState.POSITION_READ;
            }
            case POSITION_READ: {
                buffer.limit(PrimitiveTypeSize.LONG.getSize());
                if (channel.read(buffer) < 0) {
                    return false;
                }
                session.markLastActivity();
                if (buffer.hasRemaining()) {
                    return true;
                }
                buffer.flip();
                this.count = buffer.getLong();
                buffer.clear();
                this.writing = true;
                this.currentState = InternalState.BYTE_COUNT_READ;
                return true;
            }
            case RESULT_MESSAGE_SENT: {
                long remainingBytes = this.count - this.bytesReceived;
                long bytesRead = this.transferBytesFromSocket(byteChannel, channel, buffer, remainingBytes);
                if (bytesRead > 0L) {
                    session.markLastActivity();
                }
                if (bytesRead == -1L) {
                    return true;
                }
                this.bytesReceived += bytesRead;
                if (logger.isLoggable(Level.FINE)) {
                    SocketAddress clientAddress = channel.socket().getRemoteSocketAddress();
                    logger.fine(String.format("Write operation statistics of connection %s: %d bytes read, %d bytes received and %d total expected", clientAddress, bytesRead, this.bytesReceived, this.count));
                }
                if (this.bytesReceived == this.count) {
                    buffer.clear();
                    this.currentState = InternalState.BYTES_RECEIVED;
                    session.setCurrentState(new GetOperationState());
                }
                return true;
            }
        }
        return true;
    }

    @Override
    public boolean write(Session session) throws IOException {
        ByteBuffer buffer = session.getBuffer();
        SocketChannel channel = session.getChannel();
        IDataChannel fileChannel = session.getFileChannel();
        SocketAddress clientAddress = channel.socket().getRemoteSocketAddress();
        switch (this.currentState) {
            case BYTE_COUNT_READ: {
                FileChannelRequestInfo fileChannelInfo = session.getFileChannelInfo();
                short operations = fileChannel.supportedOperations();
                if ((operations & 0x20) == 0 || this.position != -1L && (operations & 8) == 0) {
                    this.result.code = ErrorCode.UNSUPPORTED_OPERATION;
                } else if (session.getFileServer().getDataProvider().isLocked(fileChannelInfo.getRequester(), fileChannelInfo.getFileId())) {
                    this.result.code = ErrorCode.FILE_LOCKED;
                } else {
                    this.result.success = true;
                }
                StateUtil.writeResultMessage(buffer, this.result);
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest(String.format("Write operation result (%s) written into buffer to connection %s", this.result, clientAddress));
                }
                buffer.flip();
                this.currentState = InternalState.RESULT_MESSAGE_WRITTEN;
            }
            case RESULT_MESSAGE_WRITTEN: {
                if (channel.write(buffer) > 0) {
                    session.markLastActivity();
                }
                if (buffer.hasRemaining()) {
                    return true;
                }
                this.writing = false;
                buffer.clear();
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest(String.format("Write operation result (%s) sent successfully to %s", this.result, clientAddress));
                }
                if (this.result.success.booleanValue()) {
                    this.currentState = InternalState.RESULT_MESSAGE_SENT;
                    this.writeUseTransferFrom = (fileChannel.supportedOperations() & 0x40) != 0 && session.getFileChannelInfo().useTransferTo();
                    buffer.limit(0);
                } else {
                    session.setCurrentState(new GetOperationState());
                }
                return true;
            }
        }
        return true;
    }

    private long transferBytesFromSocket(IDataChannel byteChannel, SocketChannel channel, ByteBuffer buffer, long remainingBytes) throws IOException, UnsupportedOperationException, DataChannelException {
        long bytesRead = -1L;
        if (this.writeUseTransferFrom) {
            if (this.position == -1L) {
                this.position = byteChannel.getPosition();
            }
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(String.format("Write operation using transferFrom for connection %s", channel.socket().getRemoteSocketAddress()));
            }
            bytesRead = byteChannel.transferFrom(channel, this.position + this.bytesReceived, this.count - this.bytesReceived);
        } else if (buffer.hasRemaining()) {
            int bytesWritten = byteChannel.write(buffer);
            bytesRead = bytesWritten;
        } else {
            if (this.position >= 0L) {
                byteChannel.setPosition(this.position + this.bytesReceived);
            }
            buffer.clear();
            if ((long)buffer.remaining() > remainingBytes) {
                buffer.limit((int)remainingBytes);
            }
            if (channel.read(buffer) == -1) {
                return -1L;
            }
            buffer.flip();
            int bytesWritten = byteChannel.write(buffer);
            bytesRead = bytesWritten;
        }
        return bytesRead;
    }

    @Override
    public boolean isWriting() {
        return this.writing;
    }

    private static enum InternalState {
        INITIAL,
        POSITION_READ,
        BYTE_COUNT_READ,
        BYTES_RECEIVED,
        RESULT_MESSAGE_WRITTEN,
        RESULT_MESSAGE_SENT;

    }
}

