/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.ftc_1_4.utils;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import tecgraf.ftc_1_4.common.logic.PrimitiveTypeSize;

public final class ByteBufferUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long readLong(ByteBuffer buffer, ReadableByteChannel channel) throws IOException {
        buffer.limit(PrimitiveTypeSize.LONG.getSize());
        int nbytes = 0;
        try {
            while ((nbytes = channel.read(buffer)) != -1 && buffer.hasRemaining()) {
            }
            if (buffer.hasRemaining()) {
                long l = -1L;
                return l;
            }
            buffer.flip();
            long l = buffer.getLong();
            return l;
        }
        finally {
            buffer.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int readInt(ByteBuffer buffer, ReadableByteChannel channel) throws IOException {
        buffer.limit(PrimitiveTypeSize.INTEGER.getSize());
        int nbytes = 0;
        try {
            while ((nbytes = channel.read(buffer)) != -1 && buffer.hasRemaining()) {
            }
            if (buffer.hasRemaining()) {
                int n = -1;
                return n;
            }
            buffer.flip();
            int n = buffer.getInt();
            return n;
        }
        finally {
            buffer.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static short readShort(ByteBuffer buffer, ReadableByteChannel channel) throws IOException {
        buffer.limit(PrimitiveTypeSize.SHORT.getSize());
        int nbytes = 0;
        try {
            while ((nbytes = channel.read(buffer)) != -1 && buffer.hasRemaining()) {
            }
            if (buffer.hasRemaining()) {
                short s = -1;
                return s;
            }
            buffer.flip();
            short s = buffer.getShort();
            return s;
        }
        finally {
            buffer.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte readByte(ByteBuffer buffer, ReadableByteChannel channel) throws IOException {
        buffer.limit(PrimitiveTypeSize.BYTE.getSize());
        int nbytes = 0;
        try {
            while ((nbytes = channel.read(buffer)) != -1 && buffer.hasRemaining()) {
            }
            if (buffer.hasRemaining()) {
                byte by = -1;
                return by;
            }
            buffer.flip();
            byte by = buffer.get();
            return by;
        }
        finally {
            buffer.clear();
        }
    }

    public static void writeByte(ByteBuffer buffer, WritableByteChannel channel, byte value) throws IOException {
        ByteBufferUtils.writeByte(buffer, channel, 0, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeByte(ByteBuffer buffer, WritableByteChannel channel, int extraBytes, byte value) throws IOException {
        buffer.put(value);
        buffer.flip();
        try {
            int bytesWritten = 0;
            while ((bytesWritten += channel.write(buffer)) < PrimitiveTypeSize.BYTE.getSize() + extraBytes) {
            }
        }
        finally {
            buffer.clear();
        }
    }

    public static void writeLong(ByteBuffer buffer, WritableByteChannel channel, long value) throws IOException {
        ByteBufferUtils.writeLong(buffer, channel, 0, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeLong(ByteBuffer buffer, WritableByteChannel channel, int extraBytes, long value) throws IOException {
        buffer.putLong(value);
        buffer.flip();
        try {
            int bytesWritten = 0;
            while ((bytesWritten += channel.write(buffer)) < PrimitiveTypeSize.LONG.getSize() + extraBytes) {
            }
        }
        finally {
            buffer.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeBytesByteSize(ByteBuffer buffer, WritableByteChannel channel, byte[] value) throws IOException {
        short valueLength = (short)(value.length > 255 ? 255 : value.length & 0xFF);
        buffer.put((byte)valueLength);
        buffer.put(value, 0, valueLength);
        buffer.flip();
        try {
            do {
                if (channel.write(buffer) >= 0) continue;
                break;
            } while (buffer.hasRemaining());
        }
        finally {
            buffer.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeBytesShortSize(ByteBuffer buffer, WritableByteChannel channel, byte[] value) throws IOException {
        char valueLength = (char)(value.length > 65535 ? 65535 : value.length & 0xFFFF);
        buffer.putChar(valueLength);
        buffer.put(value, 0, valueLength);
        buffer.flip();
        try {
            do {
                if (channel.write(buffer) >= 0) continue;
                break;
            } while (buffer.hasRemaining());
        }
        finally {
            buffer.clear();
        }
    }
}

