/*
 * Decompiled with CFR 0.152.
 */
package ibase.rest.api.drmaa2.v1.impl;

import ibase.rest.api.authentication.v1.adapter.AuthenticationService;
import ibase.rest.api.drmaa2.v1.adapter.Drmaa2ServiceAdapter;
import ibase.rest.api.drmaa2.v1.adapter.JobMonitorListener;
import ibase.rest.model.drmaa2.v1.InlineResponse200;
import ibase.rest.model.drmaa2.v1.Job;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.CompletionCallback;
import javax.ws.rs.container.ConnectionCallback;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ManagedAsync;

@Path(value="/jobs")
@Produces(value={"application/json;"})
@Singleton
@Api(description="the drmaa2 API")
public class Drmaa2RealTimeApiService {
    @Path(value="/pull")
    @GET
    @ManagedAsync
    @ApiOperation(value="Monitor job execution.", notes="This endpoint makes a long polling request for get jobs information update after their submission. This operation returns if there is a jobstatus change, or when you get a timeout in the long polling request, or the connection drops.", response=InlineResponse200.class, tags={"Jobs"})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation. The server lists the information aboutjobs modified after the date informed as query parameter.", response=InlineResponse200.class), @ApiResponse(code=401, message="Unauthorized request")})
    public void pull(final @Suspended AsyncResponse asyncResp, @ApiParam(value="Filter jobs associated with the project identified by projectId parameter.") @QueryParam(value="projectId") String projectId, @ApiParam(value="Filter the single job identified by jobId parameter.") @QueryParam(value="jobId") String jobId, @ApiParam(value="Filter jobs modified after the date parameter.") @QueryParam(value="date") long date, @ApiParam(value="The locale adopted for internationalization. When provided, this locale defines the language for message responses.") @QueryParam(value="locale") String locale, @Context ContainerRequest request, @Context AuthenticationService authenticationService, final @Context Drmaa2ServiceAdapter service) throws Exception {
        try {
            final HashMap<String, Object> m = new HashMap<String, Object>();
            if (request.getProperty("userId") == null) {
                m.put("date", System.currentTimeMillis());
                asyncResp.resume((Object)Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity(m).build());
            }
            authenticationService.parserToken(authenticationService.createToken(request.getProperty("userId").toString(), null, null), null);
            asyncResp.setTimeout(50000L, TimeUnit.MILLISECONDS);
            final JobMonitorListener listener = new JobMonitorListener(){

                @Override
                public void statusChanged(Job job) {
                    m.put("jobs", Collections.singletonList(job));
                    Drmaa2RealTimeApiService.this.resumeSuccess(m, asyncResp);
                }

                @Override
                public void infoChanged(List<Job> jobs) {
                    m.put("jobs", Collections.unmodifiableList(jobs));
                    Drmaa2RealTimeApiService.this.resumeSuccess(m, asyncResp);
                }
            };
            service.addJobMonitorListener(listener);
            Collection<Job> jobs = service.getLastJobs(date, projectId, jobId);
            if (jobs != null && !jobs.isEmpty()) {
                m.put("jobs", jobs);
                this.resumeSuccess(m, asyncResp);
            }
            asyncResp.register((Object)new CompletionCallback(){

                public void onComplete(Throwable throwable) {
                    service.removeJobMonitorListener(listener);
                }
            });
            asyncResp.register((Object)new ConnectionCallback(){

                public void onDisconnect(AsyncResponse disconnected) {
                    service.removeJobMonitorListener(listener);
                }
            });
            asyncResp.setTimeoutHandler(ar -> {
                m.put("timeout", true);
                this.resumeSuccess(m, ar);
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    private void resumeSuccess(HashMap<String, Object> m, AsyncResponse ar) {
        m.put("date", System.currentTimeMillis());
        ar.resume((Object)Response.status((Response.Status)Response.Status.OK).entity(m).build());
    }

    private class MyObserver {
        String projectId;
        String jobId;
        long date;

        public MyObserver(String projectId, String jobId, long date) {
            this.projectId = projectId;
            this.jobId = jobId;
            this.date = date;
        }
    }
}

