/*
 * Decompiled with CFR 0.152.
 */
package ibase.rest.api.drmaa2.v1.impl;

import ibase.rest.api.authentication.v1.adapter.AuthenticationService;
import ibase.rest.api.authentication.v1.adapter.UnauthorizedException;
import ibase.rest.api.drmaa2.v1.adapter.Drmaa2ServiceAdapter;
import ibase.rest.api.drmaa2.v1.adapter.JobMonitorListener;
import ibase.rest.model.drmaa2.v1.InlineResponse200;
import ibase.rest.model.drmaa2.v1.Job;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.CompletionCallback;
import javax.ws.rs.container.ConnectionCallback;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ManagedAsync;

@Path(value="/jobs")
@Produces(value={"application/json;"})
@Singleton
@Api(description="the drmaa2 API")
public class Drmaa2RealTimeApiService {
    private static final String OUT_LOG = "out.log";
    private static final Logger logger = Logger.getLogger(Drmaa2RealTimeApiService.class.getName());

    @Path(value="/pull")
    @GET
    @ManagedAsync
    @ApiOperation(value="Monitor job execution.", notes="This endpoint makes a long polling request for get jobs information update after their submission. This operation returns if there is a jobstatus change, or when you get a timeout in the long polling request, or the connection drops.", response=InlineResponse200.class, tags={"Jobs", "date"})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation. The server lists the information aboutjobs modified after the date informed as query parameter.", response=InlineResponse200.class), @ApiResponse(code=401, message="Unauthorized request")})
    public void pull(final @Suspended AsyncResponse asyncResp, @ApiParam(value="Filter jobs associated with the project identified by projectId parameter.") @QueryParam(value="projectId") String projectId, @ApiParam(value="Filter the single job identified by jobId parameter.") @QueryParam(value="jobId") String jobId, @ApiParam(value="Filter jobs modified after the date parameter.") @QueryParam(value="date") long date, @ApiParam(value="The locale adopted for internationalization. When provided, this locale defines the language for message responses.") @QueryParam(value="locale") String locale, @Context ContainerRequest request, @Context AuthenticationService authenticationService, final @Context Drmaa2ServiceAdapter service) throws Exception {
        try {
            this.authenticate(request, authenticationService);
            asyncResp.setTimeout(50000L, TimeUnit.MILLISECONDS);
            final InternalMonitor monitor = new InternalMonitor();
            final JobMonitorListener listener = new JobMonitorListener(){

                @Override
                public void statusChanged(Job job) {
                    if (monitor.block) {
                        try {
                            monitor.addJob(job);
                        }
                        catch (ParseException e) {
                            logger.log(Level.SEVERE, "", e);
                        }
                    } else {
                        Drmaa2RealTimeApiService.this.resumeJobSuccess(asyncResp, Collections.singletonList(job));
                    }
                }

                @Override
                public void infoChanged(List<Job> jobs) {
                    if (monitor.block) {
                        try {
                            monitor.addJobs(jobs);
                        }
                        catch (ParseException e) {
                            logger.log(Level.SEVERE, "", e);
                        }
                    } else {
                        Drmaa2RealTimeApiService.this.resumeJobSuccess(asyncResp, jobs);
                    }
                }
            };
            service.addJobMonitorListener(listener);
            asyncResp.register((Object)new CompletionCallback(){

                public void onComplete(Throwable throwable) {
                    service.removeJobMonitorListener(listener);
                }
            });
            asyncResp.register((Object)new ConnectionCallback(){

                public void onDisconnect(AsyncResponse disconnected) {
                    service.removeJobMonitorListener(listener);
                }
            });
            asyncResp.setTimeoutHandler(ar -> this.resumeJobSuccess(ar, null));
            Collection<Job> jobs = service.getLastJobs(date, projectId, jobId);
            monitor.addJobs(jobs);
            if (monitor.jobs.values().size() > 0) {
                this.resumeJobSuccess(asyncResp, monitor.jobs.values());
            }
            monitor.block = false;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "", e);
            throw e;
        }
    }

    private void authenticate(ContainerRequest request, AuthenticationService authenticationService) throws ibase.rest.api.authentication.v1.adapter.ParseException, UnauthorizedException {
        authenticationService.parserToken(authenticationService.createToken(request.getProperty("userId").toString(), null, null), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Path(value="/pull/log")
    @GET
    @ManagedAsync
    public void pullLog(@Suspended AsyncResponse asyncResp, @QueryParam(value="jobId") String jobId, @QueryParam(value="lastPosition") Long logPosParam, @Context ContainerRequest request, @Context AuthenticationService authenticationService, @Context Drmaa2ServiceAdapter service) throws ibase.rest.api.authentication.v1.adapter.ParseException, UnauthorizedException, IOException, InterruptedException {
        if (logPosParam == null) {
            logPosParam = 0L;
        }
        long logPosition = logPosParam;
        WatchService watchService = null;
        try {
            java.nio.file.Path pathToFile;
            this.authenticate(request, authenticationService);
            String logDirPath = service.getLogDir(jobId);
            if (logDirPath == null) {
                this.resumeLogSuccess(asyncResp, null, logPosition, jobId);
                return;
            }
            java.nio.file.Path logFilePath = Paths.get(logDirPath + File.separator + OUT_LOG, new String[0]);
            if (Files.size(logFilePath) > logPosition) {
                StringBuilder builder = new StringBuilder();
                long returnedPosition = this.getPartialLog(logFilePath, logPosition, builder);
                if (returnedPosition <= 0L) return;
                this.resumeLogSuccess(asyncResp, builder.toString(), returnedPosition, jobId);
                return;
            }
            java.nio.file.Path path = Paths.get(logDirPath, new String[0]);
            FileSystem fileSystem = path.getFileSystem();
            System.out.println(path.toAbsolutePath() + File.separator + OUT_LOG);
            asyncResp.setTimeout(50000L, TimeUnit.MILLISECONDS);
            WatchService finalWatchService = watchService = fileSystem.newWatchService();
            asyncResp.setTimeoutHandler(ar -> {
                try {
                    this.resumeLogSuccess(asyncResp, null, logPosition, jobId);
                    finalWatchService.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
            path.register(watchService, StandardWatchEventKinds.ENTRY_MODIFY);
            boolean monitor = true;
            do {
                if (!monitor) return;
                WatchKey watchKey = watchService.take();
                pathToFile = null;
                for (WatchEvent<?> event : watchKey.pollEvents()) {
                    java.nio.file.Path changed = (java.nio.file.Path)event.context();
                    if (!changed.toString().endsWith(OUT_LOG)) continue;
                    pathToFile = changed;
                    break;
                }
                monitor = watchKey.reset();
            } while (pathToFile == null);
            StringBuilder builder = new StringBuilder();
            long returnedPosition = this.getPartialLog(logFilePath, logPosition, builder);
            if (returnedPosition <= 0L) return;
            this.resumeLogSuccess(asyncResp, builder.toString(), returnedPosition, jobId);
            return;
        }
        catch (ClosedWatchServiceException logDirPath) {
            return;
        }
        catch (Exception e) {
            logger.log(Level.FINE, "Ocorreu uma excecao nao planejada.");
            logger.log(Level.SEVERE, "", e);
            this.resumeLogSuccess(asyncResp, null, logPosition, jobId);
            return;
        }
        finally {
            if (watchService != null) {
                try {
                    watchService.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long getPartialLog(java.nio.file.Path logPath, Long logPos, StringBuilder contents) throws IOException {
        File logFile = logPath.toFile();
        if (!logFile.exists()) {
            return -1L;
        }
        try (RandomAccessFile r = new RandomAccessFile(logFile, "r");){
            r.seek(logPos);
            long pos = r.getFilePointer();
            long length = r.length();
            while (pos < length) {
                contents.append(r.readLine()).append("\n");
                pos = r.getFilePointer();
            }
            long l = pos;
            return l;
        }
    }

    private void resumeLogSuccess(AsyncResponse ar, String log, Long pos, String jobId) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        if (log != null) {
            m.put("log", log);
        }
        m.put("lastPosition", pos);
        m.put("jobId", jobId);
        ar.resume((Object)Response.status((Response.Status)Response.Status.OK).entity(m).build());
    }

    private void resumeJobSuccess(AsyncResponse ar, Collection<Job> jobs) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        if (jobs != null) {
            m.put("jobs", jobs);
        }
        m.put("date", System.currentTimeMillis());
        ar.resume((Object)Response.status((Response.Status)Response.Status.OK).entity(m).build());
    }

    private class InternalMonitor {
        public boolean block = true;
        public Map<String, Job> jobs = new HashMap<String, Job>();

        private InternalMonitor() {
        }

        public void addJob(Job job) throws ParseException {
            if (job != null) {
                if (this.jobs.containsKey(job.getJobId())) {
                    Date oldDate;
                    Date newDate = this.parserData(job.getLastModifiedTime());
                    if (newDate.after(oldDate = this.parserData(this.jobs.get(job.getJobId()).getLastModifiedTime()))) {
                        this.jobs.put(job.getJobId(), job);
                    }
                } else {
                    this.jobs.put(job.getJobId(), job);
                }
            }
        }

        public void addJobs(Collection<Job> jobs) throws ParseException {
            if (jobs != null) {
                for (Job job : jobs) {
                    this.addJob(job);
                }
            }
        }

        private Date parserData(String dateToParser) throws ParseException {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
            return format.parse(dateToParser);
        }
    }
}

