/*
 * Decompiled with CFR 0.152.
 */
package ibase.rest.api.drmaa2.v1.impl;

import ibase.common.ServiceAdapter;
import ibase.common.ServiceUtil;
import ibase.exception.InternalServiceException;
import ibase.rest.api.drmaa2.v1.Drmaa2ApiService;
import ibase.rest.api.drmaa2.v1.NotFoundException;
import ibase.rest.api.drmaa2.v1.adapter.Drmaa2ServiceAdapter;
import ibase.rest.model.drmaa2.v1.Job;
import ibase.rest.model.drmaa2.v1.JobSession;
import ibase.rest.model.drmaa2.v1.JobTemplate;
import java.util.List;
import java.util.logging.Logger;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;

public class Drmaa2ApiServiceImpl
extends Drmaa2ApiService {
    public static final String RESOURCE_BUNDLE = "language.Drmaa2Api";
    private static final Logger logger = Logger.getLogger("Drmaa2Api");

    @Override
    public Response drmaa2JobPost(String jobSessionId, JobTemplate jobTemplate, String locale, SecurityContext securityContext) throws NotFoundException {
        logger.info(ServiceUtil.getTranslator((String)locale, (String)RESOURCE_BUNDLE).message("drmaa2JobPost.info", new String[0]));
        try {
            Drmaa2ServiceAdapter service = (Drmaa2ServiceAdapter)ServiceAdapter.getInstance(Drmaa2ServiceAdapter.class, (String)locale);
            Job job = service.runJob(jobSessionId, jobTemplate);
            return Response.ok().entity((Object)job).build();
        }
        catch (InternalServiceException e) {
            return ServiceUtil.buildException((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (Logger)logger, (Exception)((Object)e));
        }
    }

    @Override
    public Response drmaa2JobsessionGet(String locale, SecurityContext securityContext) throws NotFoundException {
        logger.info(ServiceUtil.getTranslator((String)locale, (String)RESOURCE_BUNDLE).message("drmaa2JobsessionGet.info", new String[0]));
        try {
            Drmaa2ServiceAdapter service = (Drmaa2ServiceAdapter)ServiceAdapter.getInstance(Drmaa2ServiceAdapter.class, (String)locale);
            List<JobSession> jobSessions = service.getAllJobSessions();
            return Response.ok().entity(jobSessions).build();
        }
        catch (InternalServiceException e) {
            return ServiceUtil.buildException((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (Logger)logger, (Exception)((Object)e));
        }
    }

    @Override
    public Response drmaa2JobsessionJobSessionNameGet(String jobSessionName, String locale, SecurityContext securityContext) throws NotFoundException {
        logger.info(ServiceUtil.getTranslator((String)locale, (String)RESOURCE_BUNDLE).message("drmaa2JobsessionJobSessionNameGet.info", new String[0]));
        try {
            Drmaa2ServiceAdapter service = (Drmaa2ServiceAdapter)ServiceAdapter.getInstance(Drmaa2ServiceAdapter.class, (String)locale);
            JobSession jobSession = service.getJobSession(jobSessionName);
            return Response.ok().entity((Object)jobSession).build();
        }
        catch (InternalServiceException e) {
            return ServiceUtil.buildException((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (Logger)logger, (Exception)((Object)e));
        }
    }

    @Override
    public Response drmaa2JobsessionPost(String name, String locale, SecurityContext securityContext) throws NotFoundException {
        logger.info(ServiceUtil.getTranslator((String)locale, (String)RESOURCE_BUNDLE).message("drmaa2JobsessionPost.info", new String[0]));
        try {
            Drmaa2ServiceAdapter service = (Drmaa2ServiceAdapter)ServiceAdapter.getInstance(Drmaa2ServiceAdapter.class, (String)locale);
            JobSession jobSession = service.createJobSession(name);
            return Response.ok().entity((Object)jobSession).build();
        }
        catch (InternalServiceException e) {
            return ServiceUtil.buildException((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (Logger)logger, (Exception)((Object)e));
        }
    }
}

