/*
 * Decompiled with CFR 0.152.
 */
package ibase.rest.model.algorithm.v2;

import ibase.rest.model.algorithm.v2.AlgorithmVersion;
import ibase.rest.model.algorithm.v2.User;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Algorithm {
    private String id = null;
    private String name = null;
    private List<String> categories = new ArrayList<String>();
    private User whoCreated = null;
    private Boolean hidden = null;
    private AlgorithmVersion lastVersion = null;
    private List<AlgorithmVersion> versions = new ArrayList<AlgorithmVersion>();

    public Algorithm id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="Unique identifier of an algorithm.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Algorithm name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="The name of the algorithm.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Algorithm categories(List<String> categories) {
        this.categories = categories;
        return this;
    }

    public Algorithm addCategoriesItem(String categoriesItem) {
        this.categories.add(categoriesItem);
        return this;
    }

    @ApiModelProperty(value="The categories of the algorithm.")
    public List<String> getCategories() {
        return this.categories;
    }

    public void setCategories(List<String> categories) {
        this.categories = categories;
    }

    public Algorithm whoCreated(User whoCreated) {
        this.whoCreated = whoCreated;
        return this;
    }

    @ApiModelProperty(value="")
    public User getWhoCreated() {
        return this.whoCreated;
    }

    public void setWhoCreated(User whoCreated) {
        this.whoCreated = whoCreated;
    }

    public Algorithm hidden(Boolean hidden) {
        this.hidden = hidden;
        return this;
    }

    @ApiModelProperty(value="Indicates if the algorithm should be hidden from interface.")
    public Boolean getHidden() {
        return this.hidden;
    }

    public void setHidden(Boolean hidden) {
        this.hidden = hidden;
    }

    public Algorithm lastVersion(AlgorithmVersion lastVersion) {
        this.lastVersion = lastVersion;
        return this;
    }

    @ApiModelProperty(value="")
    public AlgorithmVersion getLastVersion() {
        return this.lastVersion;
    }

    public void setLastVersion(AlgorithmVersion lastVersion) {
        this.lastVersion = lastVersion;
    }

    public Algorithm versions(List<AlgorithmVersion> versions) {
        this.versions = versions;
        return this;
    }

    public Algorithm addVersionsItem(AlgorithmVersion versionsItem) {
        this.versions.add(versionsItem);
        return this;
    }

    @ApiModelProperty(value="The versions of this algoritm.")
    public List<AlgorithmVersion> getVersions() {
        return this.versions;
    }

    public void setVersions(List<AlgorithmVersion> versions) {
        this.versions = versions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Algorithm algorithm = (Algorithm)o;
        return Objects.equals(this.id, algorithm.id) && Objects.equals(this.name, algorithm.name) && Objects.equals(this.categories, algorithm.categories) && Objects.equals(this.whoCreated, algorithm.whoCreated) && Objects.equals(this.hidden, algorithm.hidden) && Objects.equals(this.lastVersion, algorithm.lastVersion) && Objects.equals(this.versions, algorithm.versions);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.categories, this.whoCreated, this.hidden, this.lastVersion, this.versions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Algorithm {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    categories: ").append(this.toIndentedString(this.categories)).append("\n");
        sb.append("    whoCreated: ").append(this.toIndentedString(this.whoCreated)).append("\n");
        sb.append("    hidden: ").append(this.toIndentedString(this.hidden)).append("\n");
        sb.append("    lastVersion: ").append(this.toIndentedString(this.lastVersion)).append("\n");
        sb.append("    versions: ").append(this.toIndentedString(this.versions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

