/*
 * Decompiled with CFR 0.152.
 */
package ibase.rest.api.algorithm.v2.impl;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import ibase.common.v2.ServiceAdapter;
import ibase.common.v2.ServiceUtil;
import ibase.rest.api.algorithm.v2.AlgorithmsApiService;
import ibase.rest.api.algorithm.v2.NotFoundException;
import ibase.rest.api.algorithm.v2.adapter.AlgorithmNotFoundException;
import ibase.rest.api.algorithm.v2.adapter.AlgorithmServiceAdapter;
import ibase.rest.api.algorithm.v2.adapter.VersionNotFoundException;
import ibase.rest.model.algorithm.v2.Algorithm;
import ibase.rest.model.algorithm.v2.AlgorithmConfiguration;
import ibase.rest.model.algorithm.v2.AlgorithmDocumentation;
import ibase.rest.model.algorithm.v2.AlgorithmDocumentationSummary;
import ibase.rest.model.algorithm.v2.AlgorithmVersion;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.StreamingOutput;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPSClient;

public class AlgorithmsApiServiceImpl
extends AlgorithmsApiService {
    public static final String RESOURCE_BUNDLE = "language.v2.AlgorithmsApi";
    private static final String PUBLIC_CATEGORY = "Publico";
    private static final Logger logger = Logger.getLogger("AlgorithmsApi");

    private ResourceBundle getBundle(String localeString) {
        Locale locale = ServiceUtil.getLocale((String)localeString);
        ResourceBundle bundle = ResourceBundle.getBundle(RESOURCE_BUNDLE, locale, this.getClass().getClassLoader());
        return bundle;
    }

    @Override
    public Response algorithmsAlgorithmIdGet(String algorithmId, String locale, SecurityContext securityContext) throws NotFoundException {
        logger.info(ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("algorithms.id.get.info", new String[0]));
        AlgorithmServiceAdapter service = (AlgorithmServiceAdapter)ServiceAdapter.getInstance(AlgorithmServiceAdapter.class, (String)locale);
        Optional<Algorithm> algorithm = service.getAlgorithm(algorithmId);
        if (algorithm.isPresent()) {
            return Response.ok().entity((Object)algorithm.get()).build();
        }
        return ServiceUtil.buildException((Response.Status)Response.Status.NOT_FOUND, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("algorithms.id.not.found", new String[]{algorithmId}));
    }

    @Override
    public Response algorithmsAlgorithmIdVersionsGet(String algorithmId, String locale, SecurityContext securityContext) throws NotFoundException {
        logger.info(ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("algorithms.versions.get.info", new String[0]));
        if (algorithmId == null || algorithmId.isEmpty()) {
            return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("algorithms.id.empty", new String[]{algorithmId}));
        }
        AlgorithmServiceAdapter service = (AlgorithmServiceAdapter)ServiceAdapter.getInstance(AlgorithmServiceAdapter.class, (String)locale);
        try {
            List<AlgorithmVersion> versions = service.getAlgorithmVersions(algorithmId);
            return Response.ok().entity(versions).build();
        }
        catch (AlgorithmNotFoundException e) {
            return ServiceUtil.buildException((Response.Status)Response.Status.NOT_FOUND, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("algorithms.id.not.found", new String[]{algorithmId}));
        }
    }

    @Override
    public Response algorithmsAlgorithmIdVersionsVersionIdGet(String algorithmId, String versionId, String locale, SecurityContext securityContext) throws NotFoundException {
        logger.info(ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("algorithms.version.get.info", new String[0]));
        AlgorithmServiceAdapter service = (AlgorithmServiceAdapter)ServiceAdapter.getInstance(AlgorithmServiceAdapter.class, (String)locale);
        try {
            Optional<AlgorithmVersion> version = service.getAlgorithmVersion(algorithmId, versionId);
            if (version.isPresent()) {
                return Response.ok().entity((Object)version.get()).build();
            }
            return ServiceUtil.buildException((Response.Status)Response.Status.NOT_FOUND, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("algorithms.id.version.id.not.found", new String[]{versionId, algorithmId}));
        }
        catch (AlgorithmNotFoundException e) {
            return ServiceUtil.buildException((Response.Status)Response.Status.NOT_FOUND, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("algorithms.id.not.found", new String[]{algorithmId}));
        }
    }

    @Override
    public Response algorithmsAlgorithmIdVersionsVersionIdConfigurationGet(String algorithmId, String versionId, String locale, SecurityContext securityContext) throws NotFoundException {
        logger.info(ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("algorithms.version.configuration.get.info", new String[0]));
        AlgorithmServiceAdapter service = (AlgorithmServiceAdapter)ServiceAdapter.getInstance(AlgorithmServiceAdapter.class, (String)locale);
        try {
            AlgorithmConfiguration config = service.getAlgorithmConfiguration(algorithmId, versionId);
            return Response.ok().entity((Object)config).build();
        }
        catch (AlgorithmNotFoundException e) {
            return ServiceUtil.buildException((Response.Status)Response.Status.NOT_FOUND, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("algorithms.id.not.found", new String[]{algorithmId}));
        }
        catch (VersionNotFoundException e) {
            return ServiceUtil.buildException((Response.Status)Response.Status.NOT_FOUND, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("algorithms.id.version.id.not.found", new String[]{versionId, algorithmId}));
        }
    }

    @Override
    public Response algorithmsGet(String name, String locale, SecurityContext securityContext) throws NotFoundException {
        logger.info(ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("algorithms.get.info", new String[0]));
        AlgorithmServiceAdapter service = (AlgorithmServiceAdapter)ServiceAdapter.getInstance(AlgorithmServiceAdapter.class, (String)locale);
        List<Algorithm> algorithms = name != null ? service.getAlgorithms(a -> a.getName().toUpperCase().startsWith(name.toUpperCase())) : service.getAlgorithms(null);
        return Response.ok().entity(algorithms).build();
    }

    @Override
    public Response algorithmsToolsGet(String locale, String path, SecurityContext securityContext) throws NotFoundException {
        if (path == null) {
            return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("algorithms.path.empty", new String[]{path}));
        }
        boolean isSSL = "true".equalsIgnoreCase(ServiceAdapter.getProperty((String)"ftp.SSL.enabled"));
        FTPSClient ftpClient = isSSL ? new FTPSClient() : new FTPClient();
        try {
            ftpClient.connect(ServiceAdapter.getProperty((String)"ftp.host"), Integer.parseInt(ServiceAdapter.getProperty((String)"ftp.port")));
            if (isSSL) {
                if (ServiceAdapter.getProperty((String)"ftp.SSL.auth") != null) {
                    ftpClient.setAuthValue(ServiceAdapter.getProperty((String)"ftp.SSL.auth"));
                }
                if ("true".equalsIgnoreCase(ServiceAdapter.getProperty((String)"ftp.SSL.private"))) {
                    ftpClient.execPROT("P");
                }
            }
            if ("true".equalsIgnoreCase(ServiceAdapter.getProperty((String)"ftp.passive"))) {
                ftpClient.enterLocalPassiveMode();
            }
            ftpClient.login(ServiceAdapter.getProperty((String)"ftp.user"), ServiceAdapter.getProperty((String)"ftp.password"));
            ftpClient.setFileType(2);
            final InputStream inputStream = ftpClient.retrieveFileStream(path);
            StreamingOutput output = new StreamingOutput((FTPClient)ftpClient){
                final /* synthetic */ FTPClient val$ftpClient;
                {
                    this.val$ftpClient = fTPClient;
                }

                public void write(OutputStream out) throws IOException {
                    byte[] bytesArray = new byte[4096];
                    int bytesRead = -1;
                    while ((bytesRead = inputStream.read(bytesArray)) != -1) {
                        out.write(bytesArray, 0, bytesRead);
                    }
                    out.flush();
                    out.close();
                    inputStream.close();
                    try {
                        if (this.val$ftpClient.isConnected()) {
                            this.val$ftpClient.logout();
                            this.val$ftpClient.disconnect();
                        }
                    }
                    catch (IOException e) {
                        logger.log(Level.SEVERE, "Erro no download de ferramentas", e);
                    }
                }
            };
            return Response.ok((Object)output).type("application/octet-stream").header("Content-Disposition", (Object)("filename=\"" + path.substring(path.lastIndexOf("/") + 1) + "\"")).build();
        }
        catch (IOException ex) {
            try {
                if (ftpClient.isConnected()) {
                    ftpClient.logout();
                    ftpClient.disconnect();
                }
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Erro no download de ferramentas", e);
            }
            return ServiceUtil.buildExceptionWithoutMessage((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)"Algum erro gen\u00c3\u00a9rico no download de ferramentas");
        }
    }

    @Override
    public Response algorithmsAlgorithmIdVersionsVersionIdPlatformPlatformIdDownloadGet(String algorithmId, String versionId, String platformId, String locale, SecurityContext securityContext) throws NotFoundException {
        AlgorithmServiceAdapter service = (AlgorithmServiceAdapter)ServiceAdapter.getInstance(AlgorithmServiceAdapter.class, (String)locale);
        if (!service.validateVersion(versionId)) {
            return ServiceUtil.buildException((Response.Status)Response.Status.NOT_FOUND, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("algorithm.invalid.version", new String[]{versionId}));
        }
        String path = service.getAlgorithmDirPath(algorithmId, versionId, platformId);
        final File file = new File(path);
        if (!file.exists() || !file.isDirectory() || file.list().length == 0) {
            return ServiceUtil.buildException((Response.Status)Response.Status.NOT_FOUND, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("algorithm.binary.not.found", new String[0]));
        }
        StreamingOutput output = new StreamingOutput(){

            public void write(OutputStream out) throws IOException {
                final ZipOutputStream zos = new ZipOutputStream(out);
                final Path sourceDir = file.toPath();
                Files.walkFileTree(file.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        try {
                            Path targetFile = sourceDir.relativize(file);
                            zos.putNextEntry(new ZipEntry(targetFile.toString()));
                            byte[] bytes = Files.readAllBytes(file);
                            zos.write(bytes, 0, bytes.length);
                            zos.closeEntry();
                        }
                        catch (IOException ex) {
                            System.err.println(ex);
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
                zos.close();
                out.flush();
            }
        };
        return Response.ok((Object)output).type("application/zip").header("Content-Disposition", (Object)("filename=\"" + algorithmId + "_" + versionId + "_" + platformId + ".zip\"")).build();
    }

    @Override
    public Response algorithmsAlgorithmIdVersionsVersionIdDocumentationDownloadGet(String algorithmId, String versionId, String fileName, String locale, SecurityContext securityContext) throws NotFoundException {
        if (fileName == null) {
            return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("algorithm.fileName.empty", new String[0]));
        }
        AlgorithmServiceAdapter service = (AlgorithmServiceAdapter)ServiceAdapter.getInstance(AlgorithmServiceAdapter.class, (String)locale);
        if (!service.validateVersion(versionId)) {
            return ServiceUtil.buildException((Response.Status)Response.Status.NOT_FOUND, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("algorithm.invalid.version", new String[]{versionId}));
        }
        String path = service.getAlgorithmDocFilePath(algorithmId, versionId, fileName);
        try {
            File file = new File(path);
            final FileInputStream is = new FileInputStream(file);
            StreamingOutput output = new StreamingOutput(){

                public void write(OutputStream out) throws IOException {
                    int length;
                    byte[] buffer = new byte[1024];
                    while ((length = is.read(buffer)) != -1) {
                        out.write(buffer, 0, length);
                    }
                    out.flush();
                    is.close();
                }
            };
            String mimeType = null;
            try {
                mimeType = Files.probeContentType(file.toPath());
            }
            catch (IOException e) {
                return ServiceUtil.buildException((Response.Status)Response.Status.NOT_FOUND, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("algorithm.doc.not.found", new String[0]));
            }
            return Response.ok((Object)output).type(mimeType != null ? mimeType : "application/octet-stream").header("Content-Disposition", (Object)("filename=\"" + file.getName() + "\"")).build();
        }
        catch (FileNotFoundException e) {
            return ServiceUtil.buildException((Response.Status)Response.Status.NOT_FOUND, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("algorithm.doc.not.found", new String[0]));
        }
    }

    @Override
    public Response algorithmsDocumentationGet(String locale, SecurityContext securityContext) {
        return this.getAlgorithmsDocumentation(null, locale);
    }

    private Response getAlgorithmsDocumentation(Predicate<Algorithm> predicate, String locale) {
        AlgorithmServiceAdapter service = (AlgorithmServiceAdapter)ServiceAdapter.getInstance(AlgorithmServiceAdapter.class, (String)locale);
        List<Algorithm> algorithms = service.getAlgorithms(predicate);
        ArrayList<AlgorithmDocumentation> responseList = new ArrayList<AlgorithmDocumentation>();
        for (Algorithm algorithm : algorithms) {
            String algorithmId = algorithm.getId();
            String fileName = "page.json";
            String path = service.getAlgorithmLastVersionDocFilePath(algorithmId, fileName);
            AlgorithmDocumentation response = new AlgorithmDocumentation();
            response.setId(algorithmId);
            AlgorithmDocumentationSummary responseSummary = new AlgorithmDocumentationSummary();
            response.setVersion(algorithm.getLastVersion().getId());
            ObjectMapper mapper = new ObjectMapper();
            File algorithmDocFile = new File(path);
            if (!algorithmDocFile.exists() || algorithmDocFile.isDirectory()) continue;
            try {
                Map map = (Map)mapper.readValue(algorithmDocFile, (TypeReference)new TypeReference<Map<String, Object>>(){});
                Object ptLang = map.get("pt");
                if (ptLang != null) {
                    Map mapEnLang;
                    Object enSummary;
                    Object enLang;
                    Object ptSummary;
                    Object name;
                    Map mapPtLang = (Map)ptLang;
                    Object icon = mapPtLang.get("icon");
                    if (icon != null) {
                        response.setIcon((String)icon);
                    }
                    if ((name = mapPtLang.get("name")) != null) {
                        response.setName((String)name);
                    }
                    if ((ptSummary = mapPtLang.get("summary")) != null) {
                        responseSummary.setPt((String)ptSummary);
                    }
                    if ((enLang = map.get("en")) != null && (enSummary = (mapEnLang = (Map)enLang).get("summary")) != null) {
                        responseSummary.setEn((String)enSummary);
                    }
                    response.setSummary(responseSummary);
                    Object owner = mapPtLang.get("authors");
                    if (owner != null) {
                        response.setOwner((List)owner);
                    }
                }
                responseList.add(response);
            }
            catch (JsonParseException e) {
                logger.log(Level.SEVERE, "Erro no download de documenta\u00c3\u00a7\u00c3\u00a3o do algoritmo " + algorithmId, e);
            }
            catch (JsonMappingException e) {
                logger.log(Level.SEVERE, "Erro no download de documenta\u00c3\u00a7\u00c3\u00a3o do algoritmo " + algorithmId, e);
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Erro no download de documenta\u00c3\u00a7\u00c3\u00a3o do algoritmo " + algorithmId, e);
            }
        }
        return Response.ok(responseList).type("application/json").header("Content-Disposition", (Object)"filename=\" + algorithms\"").build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response algorithmsPublicDocumentationGet(String locale, SecurityContext securityContext) {
        ServiceAdapter.setCurrentUser((String)"admin");
        try {
            Response response = this.getAlgorithmsDocumentation(a -> a.getCategories().contains(PUBLIC_CATEGORY), locale);
            return response;
        }
        finally {
            ServiceAdapter.setCurrentUser(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response algorithmsPublicAlgorithmIdDocumentationDownloadGet(String algorithmId, String fileName, String locale, SecurityContext securityContext) throws NotFoundException {
        try {
            ServiceAdapter.setCurrentUser((String)"admin");
            AlgorithmServiceAdapter service = (AlgorithmServiceAdapter)ServiceAdapter.getInstance(AlgorithmServiceAdapter.class, (String)locale);
            Optional<Algorithm> algorithm = service.getAlgorithm(algorithmId);
            if (!algorithm.isPresent()) {
                Response response = ServiceUtil.buildException((Response.Status)Response.Status.NOT_FOUND, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("algorithms.id.not.found", new String[]{algorithmId}));
                return response;
            }
            AlgorithmVersion lastVersion = algorithm.get().getLastVersion();
            if (algorithm.get().getCategories().contains(PUBLIC_CATEGORY)) {
                Response response = this.algorithmsAlgorithmIdVersionsVersionIdDocumentationDownloadGet(algorithmId, lastVersion.getId(), fileName, locale, securityContext);
                return response;
            }
            Response response = ServiceUtil.buildException((Response.Status)Response.Status.NOT_FOUND, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("algorithms.id.not.found", new String[]{algorithmId}));
            return response;
        }
        finally {
            ServiceAdapter.setCurrentUser(null);
        }
    }
}

