/*
 * Decompiled with CFR 0.152.
 */
package ibase.rest.model.algorithm.v2;

import ibase.rest.model.algorithm.v2.Parameter;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class OutputFileParameter
extends Parameter {
    private Boolean multipleSelection = false;
    private Boolean sort = true;
    private AllowsPipeEnum allowsPipe = AllowsPipeEnum.TRUE;
    private Boolean forceExtension = false;
    private CategoryEnum category = null;
    private Boolean useFilter = false;

    public OutputFileParameter multipleSelection(Boolean multipleSelection) {
        this.multipleSelection = multipleSelection;
        return this;
    }

    @ApiModelProperty(value="If this parameter allows multiple selection.")
    public Boolean getMultipleSelection() {
        return this.multipleSelection;
    }

    public void setMultipleSelection(Boolean multipleSelection) {
        this.multipleSelection = multipleSelection;
    }

    public OutputFileParameter sort(Boolean sort) {
        this.sort = sort;
        return this;
    }

    @ApiModelProperty(value="If the files must be sorted. This option is used only if multipe_selection is true.")
    public Boolean getSort() {
        return this.sort;
    }

    public void setSort(Boolean sort) {
        this.sort = sort;
    }

    public OutputFileParameter allowsPipe(AllowsPipeEnum allowsPipe) {
        this.allowsPipe = allowsPipe;
        return this;
    }

    @ApiModelProperty(value="If the file parameter can be used as pipe or regular file (true), only as regular file (false) or only as pipe (always) by the algorithm.")
    public AllowsPipeEnum getAllowsPipe() {
        return this.allowsPipe;
    }

    public void setAllowsPipe(AllowsPipeEnum allowsPipe) {
        this.allowsPipe = allowsPipe;
    }

    public OutputFileParameter forceExtension(Boolean forceExtension) {
        this.forceExtension = forceExtension;
        return this;
    }

    @ApiModelProperty(value="If the output file requires an extension.")
    public Boolean getForceExtension() {
        return this.forceExtension;
    }

    public void setForceExtension(Boolean forceExtension) {
        this.forceExtension = forceExtension;
    }

    public OutputFileParameter category(CategoryEnum category) {
        this.category = category;
        return this;
    }

    @ApiModelProperty(value="If the parameter accepts a folder or a regular file.")
    public CategoryEnum getCategory() {
        return this.category;
    }

    public void setCategory(CategoryEnum category) {
        this.category = category;
    }

    public OutputFileParameter useFilter(Boolean useFilter) {
        this.useFilter = useFilter;
        return this;
    }

    @ApiModelProperty(value="If a filter must be provided in the user interface.")
    public Boolean getUseFilter() {
        return this.useFilter;
    }

    public void setUseFilter(Boolean useFilter) {
        this.useFilter = useFilter;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OutputFileParameter outputFileParameter = (OutputFileParameter)o;
        return Objects.equals(this.multipleSelection, outputFileParameter.multipleSelection) && Objects.equals(this.sort, outputFileParameter.sort) && Objects.equals((Object)this.allowsPipe, (Object)outputFileParameter.allowsPipe) && Objects.equals(this.forceExtension, outputFileParameter.forceExtension) && Objects.equals((Object)this.category, (Object)outputFileParameter.category) && Objects.equals(this.useFilter, outputFileParameter.useFilter) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.multipleSelection, this.sort, this.allowsPipe, this.forceExtension, this.category, this.useFilter, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OutputFileParameter {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    multipleSelection: ").append(this.toIndentedString(this.multipleSelection)).append("\n");
        sb.append("    sort: ").append(this.toIndentedString(this.sort)).append("\n");
        sb.append("    allowsPipe: ").append(this.toIndentedString((Object)this.allowsPipe)).append("\n");
        sb.append("    forceExtension: ").append(this.toIndentedString(this.forceExtension)).append("\n");
        sb.append("    category: ").append(this.toIndentedString((Object)this.category)).append("\n");
        sb.append("    useFilter: ").append(this.toIndentedString(this.useFilter)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum CategoryEnum {
        REGULAR("Regular"),
        FOLDER("Folder");

        private String value;

        private CategoryEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum AllowsPipeEnum {
        TRUE("true"),
        FALSE("false"),
        ALWAYS("always");

        private String value;

        private AllowsPipeEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

