/*
 * Decompiled with CFR 0.152.
 */
package ibase.rest.model.algorithm.v2;

import ibase.rest.model.algorithm.v2.Parameter;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class InputURLParameter
extends Parameter {
    private Boolean multipleSelection = false;
    private Boolean sort = true;
    private AllowsPipeEnum allowsPipe = AllowsPipeEnum.TRUE;
    private CategoryEnum category = null;
    private List<ProtocolEnum> protocol = new ArrayList<ProtocolEnum>();

    public InputURLParameter multipleSelection(Boolean multipleSelection) {
        this.multipleSelection = multipleSelection;
        return this;
    }

    @ApiModelProperty(value="If this parameter allows multiple selection.")
    public Boolean getMultipleSelection() {
        return this.multipleSelection;
    }

    public void setMultipleSelection(Boolean multipleSelection) {
        this.multipleSelection = multipleSelection;
    }

    public InputURLParameter sort(Boolean sort) {
        this.sort = sort;
        return this;
    }

    @ApiModelProperty(value="If the files must be sorted. This option is used only if multipe_selection is true.")
    public Boolean getSort() {
        return this.sort;
    }

    public void setSort(Boolean sort) {
        this.sort = sort;
    }

    public InputURLParameter allowsPipe(AllowsPipeEnum allowsPipe) {
        this.allowsPipe = allowsPipe;
        return this;
    }

    @ApiModelProperty(value="If the file parameter can be used as pipe or regular file (true), only as regular file (false) or only as pipe (always) by the algorithm.")
    public AllowsPipeEnum getAllowsPipe() {
        return this.allowsPipe;
    }

    public void setAllowsPipe(AllowsPipeEnum allowsPipe) {
        this.allowsPipe = allowsPipe;
    }

    public InputURLParameter category(CategoryEnum category) {
        this.category = category;
        return this;
    }

    @ApiModelProperty(value="If the parameter accepts a folder, a regular file.")
    public CategoryEnum getCategory() {
        return this.category;
    }

    public void setCategory(CategoryEnum category) {
        this.category = category;
    }

    public InputURLParameter protocol(List<ProtocolEnum> protocol) {
        this.protocol = protocol;
        return this;
    }

    public InputURLParameter addProtocolItem(ProtocolEnum protocolItem) {
        this.protocol.add(protocolItem);
        return this;
    }

    @ApiModelProperty(value="If the parameter accepts input files from a project or from a local file system")
    public List<ProtocolEnum> getProtocol() {
        return this.protocol;
    }

    public void setProtocol(List<ProtocolEnum> protocol) {
        this.protocol = protocol;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InputURLParameter inputURLParameter = (InputURLParameter)o;
        return Objects.equals(this.multipleSelection, inputURLParameter.multipleSelection) && Objects.equals(this.sort, inputURLParameter.sort) && Objects.equals((Object)this.allowsPipe, (Object)inputURLParameter.allowsPipe) && Objects.equals((Object)this.category, (Object)inputURLParameter.category) && Objects.equals(this.protocol, inputURLParameter.protocol) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.multipleSelection, this.sort, this.allowsPipe, this.category, this.protocol, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InputURLParameter {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    multipleSelection: ").append(this.toIndentedString(this.multipleSelection)).append("\n");
        sb.append("    sort: ").append(this.toIndentedString(this.sort)).append("\n");
        sb.append("    allowsPipe: ").append(this.toIndentedString((Object)this.allowsPipe)).append("\n");
        sb.append("    category: ").append(this.toIndentedString((Object)this.category)).append("\n");
        sb.append("    protocol: ").append(this.toIndentedString(this.protocol)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ProtocolEnum {
        PROJECT("Project"),
        LOCAL("Local");

        private String value;

        private ProtocolEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum CategoryEnum {
        REGULAR("Regular"),
        FOLDER("Folder");

        private String value;

        private CategoryEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum AllowsPipeEnum {
        TRUE("true"),
        FALSE("false"),
        ALWAYS("always");

        private String value;

        private AllowsPipeEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

