/*
 * Decompiled with CFR 0.152.
 */
package ibase.rest.model.algorithm.v2;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Describe how to load parameter values from another algorithm.")
public class ParametersLoader {
    private List<String> inputParameterNames = new ArrayList<String>();
    private String outputParameterName = null;
    private String algorithmName = null;
    private String algorithmVersionId = null;
    private Boolean validateInput = false;

    public ParametersLoader inputParameterNames(List<String> inputParameterNames) {
        this.inputParameterNames = inputParameterNames;
        return this;
    }

    public ParametersLoader addInputParameterNamesItem(String inputParameterNamesItem) {
        this.inputParameterNames.add(inputParameterNamesItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<String> getInputParameterNames() {
        return this.inputParameterNames;
    }

    public void setInputParameterNames(List<String> inputParameterNames) {
        this.inputParameterNames = inputParameterNames;
    }

    public ParametersLoader outputParameterName(String outputParameterName) {
        this.outputParameterName = outputParameterName;
        return this;
    }

    @ApiModelProperty(value="The algorithm parameter output name.")
    public String getOutputParameterName() {
        return this.outputParameterName;
    }

    public void setOutputParameterName(String outputParameterName) {
        this.outputParameterName = outputParameterName;
    }

    public ParametersLoader algorithmName(String algorithmName) {
        this.algorithmName = algorithmName;
        return this;
    }

    @ApiModelProperty(value="The algorithm name.")
    public String getAlgorithmName() {
        return this.algorithmName;
    }

    public void setAlgorithmName(String algorithmName) {
        this.algorithmName = algorithmName;
    }

    public ParametersLoader algorithmVersionId(String algorithmVersionId) {
        this.algorithmVersionId = algorithmVersionId;
        return this;
    }

    @ApiModelProperty(value="The ID of an algorithm version.")
    public String getAlgorithmVersionId() {
        return this.algorithmVersionId;
    }

    public void setAlgorithmVersionId(String algorithmVersionId) {
        this.algorithmVersionId = algorithmVersionId;
    }

    public ParametersLoader validateInput(Boolean validateInput) {
        this.validateInput = validateInput;
        return this;
    }

    @ApiModelProperty(value="Check if the loaded data came from inputParamaterNames.")
    public Boolean getValidateInput() {
        return this.validateInput;
    }

    public void setValidateInput(Boolean validateInput) {
        this.validateInput = validateInput;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParametersLoader parametersLoader = (ParametersLoader)o;
        return Objects.equals(this.inputParameterNames, parametersLoader.inputParameterNames) && Objects.equals(this.outputParameterName, parametersLoader.outputParameterName) && Objects.equals(this.algorithmName, parametersLoader.algorithmName) && Objects.equals(this.algorithmVersionId, parametersLoader.algorithmVersionId) && Objects.equals(this.validateInput, parametersLoader.validateInput);
    }

    public int hashCode() {
        return Objects.hash(this.inputParameterNames, this.outputParameterName, this.algorithmName, this.algorithmVersionId, this.validateInput);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ParametersLoader {\n");
        sb.append("    inputParameterNames: ").append(this.toIndentedString(this.inputParameterNames)).append("\n");
        sb.append("    outputParameterName: ").append(this.toIndentedString(this.outputParameterName)).append("\n");
        sb.append("    algorithmName: ").append(this.toIndentedString(this.algorithmName)).append("\n");
        sb.append("    algorithmVersionId: ").append(this.toIndentedString(this.algorithmVersionId)).append("\n");
        sb.append("    validateInput: ").append(this.toIndentedString(this.validateInput)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

