/*
 * Decompiled with CFR 0.152.
 */
package ibase.rest.model.algorithm.v2;

import ibase.rest.model.algorithm.v2.EnumerationItem;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="The columns of elements that a table may contain.")
public class ColumnOfElements {
    private String id = null;
    private String header = null;
    private Object defaultValue = null;
    private List<EnumerationItem> enumerationItems = new ArrayList<EnumerationItem>();
    private String elementType = null;

    public ColumnOfElements id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="The identification of the column")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ColumnOfElements header(String header) {
        this.header = header;
        return this;
    }

    @ApiModelProperty(value="the header of the column")
    public String getHeader() {
        return this.header;
    }

    public void setHeader(String header) {
        this.header = header;
    }

    public ColumnOfElements defaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    @ApiModelProperty(value="A json object that is the default value for this parameter. It depends of the parameter type.")
    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public ColumnOfElements enumerationItems(List<EnumerationItem> enumerationItems) {
        this.enumerationItems = enumerationItems;
        return this;
    }

    public ColumnOfElements addEnumerationItemsItem(EnumerationItem enumerationItemsItem) {
        this.enumerationItems.add(enumerationItemsItem);
        return this;
    }

    @ApiModelProperty(value="Configuration for enumeration items of the column of type enumeration.")
    public List<EnumerationItem> getEnumerationItems() {
        return this.enumerationItems;
    }

    public void setEnumerationItems(List<EnumerationItem> enumerationItems) {
        this.enumerationItems = enumerationItems;
    }

    public ColumnOfElements elementType(String elementType) {
        this.elementType = elementType;
        return this;
    }

    @ApiModelProperty(value="The type of the element (main types are listed on ColumnType enum).")
    public String getElementType() {
        return this.elementType;
    }

    public void setElementType(String elementType) {
        this.elementType = elementType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColumnOfElements columnOfElements = (ColumnOfElements)o;
        return Objects.equals(this.id, columnOfElements.id) && Objects.equals(this.header, columnOfElements.header) && Objects.equals(this.defaultValue, columnOfElements.defaultValue) && Objects.equals(this.enumerationItems, columnOfElements.enumerationItems) && Objects.equals(this.elementType, columnOfElements.elementType);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.header, this.defaultValue, this.enumerationItems, this.elementType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ColumnOfElements {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    header: ").append(this.toIndentedString(this.header)).append("\n");
        sb.append("    defaultValue: ").append(this.toIndentedString(this.defaultValue)).append("\n");
        sb.append("    enumerationItems: ").append(this.toIndentedString(this.enumerationItems)).append("\n");
        sb.append("    elementType: ").append(this.toIndentedString(this.elementType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

