/*
 * Decompiled with CFR 0.152.
 */
package ibase.rest.model.algorithm.v2;

import ibase.rest.model.algorithm.v2.Parameter;
import ibase.rest.model.algorithm.v2.ParametersLoader;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Groups a set of related parameters.")
public class ParameterGroup {
    private String id = null;
    private String label = null;
    private Boolean collapsable = null;
    private List<Parameter> parameters = new ArrayList<Parameter>();
    private ParametersLoader parametersLoader = null;

    public ParameterGroup id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="The identification of the group.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ParameterGroup label(String label) {
        this.label = label;
        return this;
    }

    @ApiModelProperty(value="The label of the group")
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public ParameterGroup collapsable(Boolean collapsable) {
        this.collapsable = collapsable;
        return this;
    }

    @ApiModelProperty(value="If this group can be collapsed and expanded.")
    public Boolean getCollapsable() {
        return this.collapsable;
    }

    public void setCollapsable(Boolean collapsable) {
        this.collapsable = collapsable;
    }

    public ParameterGroup parameters(List<Parameter> parameters) {
        this.parameters = parameters;
        return this;
    }

    public ParameterGroup addParametersItem(Parameter parametersItem) {
        this.parameters.add(parametersItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
    }

    public ParameterGroup parametersLoader(ParametersLoader parametersLoader) {
        this.parametersLoader = parametersLoader;
        return this;
    }

    @ApiModelProperty(value="")
    public ParametersLoader getParametersLoader() {
        return this.parametersLoader;
    }

    public void setParametersLoader(ParametersLoader parametersLoader) {
        this.parametersLoader = parametersLoader;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParameterGroup parameterGroup = (ParameterGroup)o;
        return Objects.equals(this.id, parameterGroup.id) && Objects.equals(this.label, parameterGroup.label) && Objects.equals(this.collapsable, parameterGroup.collapsable) && Objects.equals(this.parameters, parameterGroup.parameters) && Objects.equals(this.parametersLoader, parameterGroup.parametersLoader);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.label, this.collapsable, this.parameters, this.parametersLoader);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ParameterGroup {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    label: ").append(this.toIndentedString(this.label)).append("\n");
        sb.append("    collapsable: ").append(this.toIndentedString(this.collapsable)).append("\n");
        sb.append("    parameters: ").append(this.toIndentedString(this.parameters)).append("\n");
        sb.append("    parametersLoader: ").append(this.toIndentedString(this.parametersLoader)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

