package tecgraf.javautils.concurrent.locks.exceptions;

/**
 * Exceo para distinguir uma falha na tentativa de liberar um lock sobre um
 * objeto a partir de um identificador de lock invlido
 */
public class InvalidLockIdException extends RuntimeException {

  /**
   * Constri uma exceo contendo a descrio do erro correspondente.
   * 
   * @param clientMessage a descrio do erro
   */
  public InvalidLockIdException(String clientMessage) {
    super(clientMessage);
  }

  /**
   * Constri uma exceo contendo a descrio do erro e a causa/exceo
   * original.
   * 
   * @param clientMessage a descrio do erro
   * @param exception a exceo original
   */
  public InvalidLockIdException(String clientMessage, Throwable exception) {
    super(clientMessage, exception);
  }
}
