/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.concurrent.locks;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.concurrent.atomic.AtomicInteger;
import tecgraf.javautils.concurrent.locks.LockId;

public class LockFuture
implements Remote {
    private boolean isRemote = false;
    private boolean gotNotification = false;
    private LockId lockId = null;
    private AtomicInteger numberOfAttempts = new AtomicInteger();

    public LockFuture() {
    }

    public LockFuture(boolean isRemote) {
        this();
        this.isRemote = isRemote;
        if (this.isRemote) {
            try {
                UnicastRemoteObject.exportObject(this);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    public final synchronized void objectLocked(LockId lockId) throws RemoteException {
        this.lockId = lockId;
        this.gotNotification();
    }

    public final synchronized void objectLockExpired() throws RemoteException {
        this.lockId = null;
        this.gotNotification();
    }

    final int addAttempt() {
        return this.numberOfAttempts.incrementAndGet();
    }

    public int getNumberOfAttempts() {
        return this.numberOfAttempts.intValue();
    }

    private synchronized void gotNotification() {
        this.gotNotification = true;
        if (this.isRemote) {
            try {
                UnicastRemoteObject.unexportObject(this, false);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        this.notify();
    }

    public synchronized LockId get() {
        while (!this.gotNotification) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.lockId;
    }
}

