/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.concurrent.locks;

import java.util.logging.Level;
import java.util.logging.Logger;

class LockLogger {
    private static LockLogger instance = new LockLogger();
    private Logger theLogger = null;

    private LockLogger() {
    }

    static LockLogger getInstance() {
        return instance;
    }

    void setLogger(Logger logger) {
        this.theLogger = logger;
    }

    public Logger getLogger() {
        return this.theLogger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logMessage(Level level, String msg) {
        Logger logger = null;
        LockLogger lockLogger = this;
        synchronized (lockLogger) {
            logger = this.theLogger;
        }
        if (logger != null) {
            logger.log(level, msg);
        } else {
            System.out.println(level.toString() + ": " + msg);
        }
    }

    void config(String msg) {
        this.logMessage(Level.CONFIG, msg);
    }

    void warning(String msg) {
        this.logMessage(Level.WARNING, msg);
    }

    void severe(String msg) {
        this.logMessage(Level.SEVERE, msg);
    }

    void info(String msg) {
        this.logMessage(Level.INFO, msg);
    }

    void fine(String msg) {
        this.logMessage(Level.FINE, msg);
    }

    void finer(String msg) {
        this.logMessage(Level.FINER, msg);
    }

    void finest(String msg) {
        this.logMessage(Level.FINEST, msg);
    }
}

