/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.concurrent.locks;

import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Vector;
import tecgraf.javautils.concurrent.locks.LockId;
import tecgraf.javautils.concurrent.locks.LockPolicy;

public class Lock
implements Comparable<Lock> {
    private LockId id = new LockId();
    private LockPolicy policy;
    private boolean serverRequested = true;
    private LockId originatorLockId;
    private List<LockId> dependencies;
    private WeakReference<Object> ownerKeyRef = null;

    Lock(LockPolicy lockPolicy, LockId originatorLockId) {
        this.policy = lockPolicy;
        this.originatorLockId = originatorLockId;
        if (this.originatorLockId == null) {
            this.originatorLockId = this.id;
        }
        this.dependencies = new Vector<LockId>();
    }

    Lock(LockPolicy lockPolicy, Object ownerKey, LockId originatorLockId) {
        this(lockPolicy, originatorLockId);
        this.ownerKeyRef = new WeakReference<Object>(ownerKey);
        this.serverRequested = false;
    }

    LockId getId() {
        return this.id;
    }

    Object getOwnerKey() {
        if (this.ownerKeyRef == null) {
            return null;
        }
        return this.ownerKeyRef.get();
    }

    public LockPolicy getPolicy() {
        return this.policy;
    }

    public boolean isFirstOrder() {
        return this.id.equals(this.originatorLockId);
    }

    public LockId getOriginatorLockId() {
        return this.originatorLockId;
    }

    public List<LockId> getIdDependencies() {
        return this.dependencies;
    }

    public void addIdDependency(LockId lockId) {
        this.dependencies.add(lockId);
    }

    public boolean isInvalid() {
        if (this.serverRequested) {
            return false;
        }
        if (this.ownerKeyRef == null) {
            return true;
        }
        return this.ownerKeyRef.get() == null;
    }

    @Override
    public int compareTo(Lock o) {
        if (this.id.equals(o.id)) {
            return 0;
        }
        return -1;
    }
}

