/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.concurrent.locks;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import tecgraf.javautils.concurrent.locks.LockListener;

public class LockListenerManager {
    private HashMap<LockListener, Vector<ListenerVerifier>> listenerMap = new HashMap();

    LockListenerManager() {
    }

    public void addLockListener(LockListener lockListener) {
        ListenerVerifier listener = new ListenerVerifier();
        listener.lockListener = lockListener;
        this.newListener(listener);
    }

    void addLockListener(Class<?> theClass, LockListener lockListener) {
        ClassListenerVerifier listener = new ClassListenerVerifier();
        listener.theClass = theClass;
        listener.lockListener = lockListener;
        this.newListener(listener);
    }

    void addLockListener(Object object, LockListener lockListener) {
        ObjectListenerVerifier listener = new ObjectListenerVerifier();
        listener.theObject = object;
        listener.lockListener = lockListener;
        this.newListener(listener);
    }

    void removeLockListener(LockListener lockListener) {
        this.removeListener(lockListener);
    }

    public Set<LockListener> getListeners(Object object) {
        HashSet<LockListener> lockListeners = new HashSet<LockListener>();
        for (Vector<ListenerVerifier> listenerVerifierList : this.listenerMap.values()) {
            for (ListenerVerifier verifier : listenerVerifierList) {
                if (!verifier.hasInterest(object)) continue;
                lockListeners.add(verifier.lockListener);
            }
        }
        return lockListeners;
    }

    private void newListener(ListenerVerifier listener) {
        Vector<ListenerVerifier> listeners = this.listenerMap.get(listener.lockListener);
        if (listeners == null) {
            listeners = new Vector();
            this.listenerMap.put(listener.lockListener, listeners);
        }
        listeners.add(listener);
    }

    private void removeListener(LockListener lockListener) {
        this.listenerMap.remove(lockListener);
    }

    class ObjectListenerVerifier
    extends ListenerVerifier {
        Object theObject;

        ObjectListenerVerifier() {
        }

        @Override
        boolean hasInterest(Object object) {
            return this.theObject.equals(object);
        }
    }

    class ClassListenerVerifier
    extends ListenerVerifier {
        Class<?> theClass;

        ClassListenerVerifier() {
        }

        @Override
        boolean hasInterest(Object object) {
            return this.theClass.isInstance(object);
        }
    }

    class ListenerVerifier {
        LockListener lockListener;

        ListenerVerifier() {
        }

        boolean hasInterest(Object object) {
            return true;
        }
    }
}

